/*
 * BInputField.java
 *
 * Created on November 23, 2002, 8:09 PM
 */

package com.softwaterworks.gui;

import com.softwaterworks.gui.event.*;
import java.util.*;

/**
 *
 * @author  Brian Lim Youliang
 */
public class BInputField extends javax.swing.JPanel {
    
    javax.swing.event.EventListenerList listenerList = 
        new javax.swing.event.EventListenerList();
    
    /** Creates new form BInputField */
    public BInputField() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        inputField = new javax.swing.JTextField();
        inButton = new javax.swing.JButton();
        outButton = new javax.swing.JButton();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.X_AXIS));

        inputField.setMinimumSize(new java.awt.Dimension(24, 20));
        inputField.setPreferredSize(new java.awt.Dimension(120, 20));
        inputField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                inputFieldActionPerformed(evt);
            }
        });

        add(inputField);

        inButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                inButtonActionPerformed(evt);
            }
        });

        add(inButton);

        outButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                outButtonActionPerformed(evt);
            }
        });

        add(outButton);

    }//GEN-END:initComponents

    private void outButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_outButtonActionPerformed
        // Add your handling code here:
        // OUT action occurred
        if (inputField.getText().length() > 0)
            fireInputEvent(new InputEvent(evt.getSource(), inputField.getText(), 
                                          InputEvent.OUT_ACTION));
    }//GEN-LAST:event_outButtonActionPerformed

    private void inButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inButtonActionPerformed
        // Add your handling code here:
        // IN action occurred
        if (inputField.getText().length() > 0)
            fireInputEvent(new InputEvent(evt.getSource(), inputField.getText(), 
                                          InputEvent.IN_ACTION));
    }//GEN-LAST:event_inButtonActionPerformed

    private void inputFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inputFieldActionPerformed
        // Add your handling code here:
        // IN action occurred
        if (inputField.getText().length() > 0)
            fireInputEvent(new InputEvent(evt.getSource(), inputField.getText(), 
                                          InputEvent.IN_ACTION));
    }//GEN-LAST:event_inputFieldActionPerformed

    /** Getter for property inIcon.
     * @return Value of property inIcon.
     *
     */
    public javax.swing.Icon getInIcon() {
        return inButton.getIcon();
    }    
    
    /** Setter for property inIcon.
     * @param inIcon New value of property inIcon.
     *
     */
    public void setInIcon(javax.swing.Icon inIcon) {
        inButton.setIcon(inIcon);
    }    
    
    /** Getter for property outIcon.
     * @return Value of property outIcon.
     *
     */
    public javax.swing.Icon getOutIcon() {
        return outButton.getIcon();
    }
    
    /** Setter for property outIcon.
     * @param outIcon New value of property outIcon.
     *
     */
    public void setOutIcon(javax.swing.Icon outIcon) {
        outButton.setIcon(outIcon);
    }
    
    /** Getter for property text.
     * @return Value of property text.
     *
     */
    public String getText() {
        return inputField.getText();
    }
    
    /** Setter for property text.
     * @param text New value of property text.
     *
     */
    public void setText(String text) {
        inputField.setText(text);
    }
    
    public void addInputListener(InputListener l) {
        listenerList.add(InputListener.class, l);
    }
    
    public void removeInputListener(InputListener l) {
        listenerList.remove(InputListener.class, l);
    }
    
    public void fireInputEvent(InputEvent event) {
        // Guaranteed to return a non-null array
        /*Object[] listeners = listenerList.getListenerList();
        InputEvent e = null;
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==InputEvent.class) {
                // Lazily create the event:
                if (e == null) {
                    e = new InputEvent(event.getSource(), event.getAction());
                }
                ((InputListener)listeners[i+1]).inputHappened(e);
            }          
        }*/
        EventListener[] listeners = listenerList.getListeners(InputListener.class);
        if (listeners != null)
            for (int i = 0; i < listeners.length; i++)
                ((InputListener)listeners[i]).inputHappened(event);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton inButton;
    private javax.swing.JButton outButton;
    private javax.swing.JTextField inputField;
    // End of variables declaration//GEN-END:variables
    
}
