/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;

public class Trace {
    public static final String tracePrefix = "(trace)";
    public static boolean ON = false;
    protected static boolean isEclipse = false;
    protected static String pluginName = "";
    protected static String debugPrefix = "/debug/";
    String name;
    static /* synthetic */ Class class$0;

    static {
        try {
            ON = Platform.inDebugMode();
            String val = System.getProperty("org.eclipse.ecf.Trace");
            if (val != null) {
                Trace.setTrace(true);
                isEclipse = false;
                System.out.println("WARNING:  Eclipse platform not available for trace...overridden by system property org.eclipse.ecf.Trace");
            } else {
                isEclipse = true;
                pluginName = "org.eclipse.ecf";
            }
        }
        catch (Exception exception) {
            try {
                String val = System.getProperty("org.eclipse.ecf.Trace");
                if (val != null) {
                    Trace.setTrace(true);
                    isEclipse = false;
                    System.out.println("WARNING:  Eclipse platform not available for trace...using system.out for org.eclipse.ecf");
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ecf.internal.core.Trace");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                System.out.println(String.valueOf(clazz.getName()) + ": OFF");
            }
            catch (Exception exception2) {}
        }
    }

    public static void setTrace(boolean on) {
        ON = on;
    }

    public static Trace create(String key) {
        if (isEclipse) {
            String res = "";
            try {
                res = Platform.getDebugOption((String)(String.valueOf(pluginName) + debugPrefix + key));
            }
            catch (Exception exception) {}
            if (res != null) {
                Boolean on = new Boolean(res);
                if (on.booleanValue()) {
                    return new Trace(String.valueOf(pluginName) + "(" + key + ")");
                }
                return null;
            }
            return null;
        }
        return new Trace(key);
    }

    public void dumpStack(Throwable e, String msg) {
        this.msg(msg);
        e.printStackTrace(System.err);
    }

    public void msg(String msg) {
        StringBuffer sb = new StringBuffer(this.name);
        sb.append(Trace.getTimeString()).append(msg);
        System.out.println(sb.toString());
    }

    protected static String getTimeString() {
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat("[MM/dd/yy;HH:mm:ss:SSS]");
        return df.format(d);
    }

    protected Trace(String str) {
        this.name = tracePrefix + str;
    }

    public static String convertStringAToString(String[] strings) {
        if (strings == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            if (strings[i] == null) {
                sb.append("(null)");
            } else {
                sb.append(strings[i]);
            }
            if (i != strings.length - 1) {
                sb.append(";");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String convertObjectAToString(Object[] objs) {
        if (objs == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] == null) {
                sb.append("(null)");
            } else {
                sb.append(objs[i].toString());
            }
            if (i != objs.length - 1) {
                sb.append(";");
            }
            ++i;
        }
        return sb.toString();
    }

    public static void setThreadDebugGroup(Object obj) {
    }
}

