/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.core;

import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerDescription;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.comm.ConnectionDescription;
import org.eclipse.ecf.core.comm.ConnectionFactory;
import org.eclipse.ecf.core.comm.provider.ISynchAsynchConnectionInstantiator;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.internal.core.Trace;
import org.osgi.framework.BundleContext;

public class ECFPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ecf";
    public static final Trace trace = Trace.create("factoryinit");
    public static final String PLUGIN_RESOURCE_BUNDLE = "org.eclipse.ecf.ECFPluginResources";
    public static final String NAMESPACE_EPOINT = "org.eclipse.ecf.namespace";
    public static final String NAMESPACE_CLASS_ATTRIBUTE = "class";
    public static final String NAMESPACE_NAME_ATTRIBUTE = "name";
    public static final String NAMESPACE_DESCRIPTION_ATTRIBUTE = "description";
    public static final String CONTAINER_FACTORY_EPOINT = "org.eclipse.ecf.containerFactory";
    public static final String SIMPLE_CONTAINER_FACTORY_EPOINT = "org.eclipse.ecf.simpleContainerFactory";
    public static final String CONTAINER_FACTORY_EPOINT_CLASS_ATTRIBUTE = "class";
    public static final String CONTAINER_FACTORY_EPOINT_NAME_ATTRIBUTE = "name";
    public static final String CONTAINER_FACTORY_EPOINT_DESC_ATTRIBUTE = "description";
    public static final String ARG_ELEMENT_NAME = "defaultargument";
    public static final String ARG_TYPE_ATTRIBUTE = "type";
    public static final String ARG_VALUE_ATTRIBUTE = "value";
    public static final String ARG_NAME_ATTRIBUTE = "name";
    public static final String PROPERTY_ELEMENT_NAME = "property";
    public static final String PROPERTY_NAME_ATTRIBUTE = "name";
    public static final String PROPERTY_VALUE_ATTRIBUTE = "value";
    public static final String COMM_FACTORY_EPOINT = "org.eclipse.ecf.connectionFactory";
    public static final String COMM_FACTORY_EPOINT_CLASS_ATTRIBUTE = "class";
    public static final String COMM_FACTORY_EPOINT_NAME_ATTRIBUTE = "name";
    public static final String COMM_FACTORY_EPOINT_DESC_ATTRIBUTE = "description";
    public static final int FACTORY_DOES_NOT_IMPLEMENT_ERRORCODE = 10;
    public static final int FACTORY_NAME_COLLISION_ERRORCODE = 20;
    public static final int INSTANTIATOR_DOES_NOT_IMPLEMENT_ERRORCODE = 30;
    public static final int INSTANTIATOR_NAME_COLLISION_ERRORCODE = 50;
    public static final int INSTANTIATOR_NAMESPACE_LOAD_ERRORCODE = 60;
    private static ECFPlugin plugin;
    private ResourceBundle resourceBundle;
    BundleContext bundlecontext = null;

    private static void debug(String msg) {
        if (Trace.ON && trace != null) {
            trace.msg(msg);
        }
    }

    private static void dumpStack(String msg, Throwable e) {
        if (Trace.ON && trace != null) {
            trace.dumpStack(e, msg);
        }
    }

    public ECFPlugin() {
        ECFPlugin.debug("ECFPlugin.<init>");
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(PLUGIN_RESOURCE_BUNDLE);
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static void log(IStatus status) {
        if (status == null) {
            return;
        }
        ILog log = plugin.getLog();
        if (log != null) {
            log.log(status);
        } else {
            System.err.println("No log output.  Status Message: " + status.getMessage());
        }
    }

    protected DefaultArgs getDefaultArgs(IConfigurationElement[] argElements) {
        String[] argTypes = new String[]{};
        String[] argDefaults = new String[]{};
        String[] argNames = new String[]{};
        if (argElements != null && argElements.length > 0) {
            argTypes = new String[argElements.length];
            argDefaults = new String[argElements.length];
            argNames = new String[argElements.length];
            int i = 0;
            while (i < argElements.length) {
                argTypes[i] = argElements[i].getAttribute(ARG_TYPE_ATTRIBUTE);
                argDefaults[i] = argElements[i].getAttribute("value");
                argNames[i] = argElements[i].getAttribute("name");
                ++i;
            }
        }
        return new DefaultArgs(argTypes, argDefaults, argNames);
    }

    protected Map getProperties(IConfigurationElement[] propertyElements) {
        Properties props = new Properties();
        if (propertyElements != null && propertyElements.length > 0) {
            int i = 0;
            while (i < propertyElements.length) {
                String name = propertyElements[i].getAttribute("name");
                String value = propertyElements[i].getAttribute("value");
                if (name != null && !name.equals("") && value != null && !value.equals("")) {
                    props.setProperty(name, value);
                }
                ++i;
            }
        }
        return props;
    }

    protected void setupContainerExtensionPoint(BundleContext bc) {
        String bundleName = ECFPlugin.getDefault().getBundle().getSymbolicName();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = reg.getExtensionPoint(CONTAINER_FACTORY_EPOINT);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            Object exten = null;
            String name = null;
            try {
                String description;
                exten = member.createExecutableExtension("class");
                String clazz = exten.getClass().getName();
                name = member.getAttribute("name");
                if (name == null) {
                    name = clazz;
                }
                if ((description = member.getAttribute("description")) == null) {
                    description = "";
                }
                DefaultArgs defaults = this.getDefaultArgs(member.getChildren(ARG_ELEMENT_NAME));
                Map properties = this.getProperties(member.getChildren(PROPERTY_ELEMENT_NAME));
                ContainerDescription scd = new ContainerDescription(name, (IContainerInstantiator)exten, description, defaults.getTypes(), defaults.getDefaults(), defaults.getNames(), properties);
                ECFPlugin.debug("setupContainerExtensionPoint:created description:" + scd);
                IContainerFactory factory = ContainerFactory.getDefault();
                if (factory.containsDescription(scd)) {
                    throw new CoreException(this.getStatusForContException(extension, bundleName, name));
                }
                factory.addDescription(scd);
                ECFPlugin.debug("setupContainerExtensionPoint:added description to factory:" + scd);
            }
            catch (CoreException e) {
                ECFPlugin.log(e.getStatus());
                ECFPlugin.dumpStack("CoreException in setupContainerExtensionPoint", e);
            }
            catch (Exception e) {
                ECFPlugin.log(this.getStatusForContException(extension, bundleName, name));
                ECFPlugin.dumpStack("Exception in setupContainerExtensionPoint", e);
            }
            ++m;
        }
    }

    protected void setupIdentityExtensionPoint(BundleContext context) {
        String bundleName = ECFPlugin.getDefault().getBundle().getSymbolicName();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = reg.getExtensionPoint(NAMESPACE_EPOINT);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            String nsName = null;
            try {
                Namespace ns = (Namespace)member.createExecutableExtension("class");
                String clazz = ns.getClass().getName();
                nsName = member.getAttribute("name");
                if (nsName == null) {
                    nsName = clazz;
                }
                String nsDescription = member.getAttribute("description");
                ns.initialize(nsName, nsDescription);
                ECFPlugin.debug("setupIdentityExtensionPoint:created namespace:" + ns);
                if (IDFactory.getDefault().containsNamespace(ns)) {
                    throw new CoreException(this.getStatusForIDException(extension, bundleName, nsName));
                }
                IDFactory.getDefault().addNamespace(ns);
                ECFPlugin.debug("setupIdentityExtensionPoint:added namespace to factory:" + ns);
            }
            catch (CoreException e) {
                ECFPlugin.log(e.getStatus());
                ECFPlugin.dumpStack("Exception in setupIdentityExtensionPoint", e);
            }
            catch (Exception e) {
                ECFPlugin.log(this.getStatusForIDException(extension, bundleName, nsName));
                ECFPlugin.dumpStack("Exception in setupIdentityExtensionPoint", e);
            }
            ++m;
        }
    }

    protected void setupCommExtensionPoint(BundleContext bc) {
        String bundleName = ECFPlugin.getDefault().getBundle().getSymbolicName();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = reg.getExtensionPoint(COMM_FACTORY_EPOINT);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            Object exten = null;
            String name = null;
            try {
                String description;
                exten = member.createExecutableExtension("class");
                String clazz = exten.getClass().getName();
                name = member.getAttribute("name");
                if (name == null) {
                    name = clazz;
                }
                if ((description = member.getAttribute("description")) == null) {
                    description = "";
                }
                DefaultArgs defaults = this.getDefaultArgs(member.getChildren(ARG_ELEMENT_NAME));
                ConnectionDescription cd = new ConnectionDescription(name, (ISynchAsynchConnectionInstantiator)exten, description, defaults.getTypes(), defaults.getDefaults(), defaults.getNames());
                ECFPlugin.debug("setupCommExtensionPoint:created description:" + cd);
                if (ConnectionFactory.containsDescription(cd)) {
                    Status s = new Status(4, bundleName, 20, String.valueOf(ECFPlugin.getResourceString("ExtPointError.CommNameCollisionPrefix")) + name + ECFPlugin.getResourceString("ExtPointError.CommNameCollisionSuffix") + extension.getExtensionPointUniqueIdentifier(), null);
                    ECFPlugin.log((IStatus)s);
                    throw new CoreException(this.getStatusForCommException(extension, bundleName, name));
                }
                ConnectionFactory.addDescription(cd);
                ECFPlugin.debug("setupCommExtensionPoint:added description to factory:" + cd);
            }
            catch (CoreException e) {
                ECFPlugin.log(e.getStatus());
                ECFPlugin.dumpStack("CoreException in setupCommExtensionPoint", e);
            }
            catch (Exception e) {
                ECFPlugin.log(this.getStatusForCommException(extension, bundleName, name));
                ECFPlugin.dumpStack("Exception in setupCommExtensionPoint", e);
            }
            ++m;
        }
    }

    protected IStatus getStatusForCommException(IExtension ext, String bundleName, String name) {
        Status s = new Status(4, bundleName, 20, String.valueOf(ECFPlugin.getResourceString("ExtPointError.CommNameCollisionPrefix")) + name + ECFPlugin.getResourceString("ExtPointError.CommNameCollisionSuffix") + ext.getExtensionPointUniqueIdentifier(), null);
        return s;
    }

    protected IStatus getStatusForContException(IExtension ext, String bundleName, String name) {
        Status s = new Status(4, bundleName, 20, String.valueOf(ECFPlugin.getResourceString("ExtPointError.ContainerNameCollisionPrefix")) + name + ECFPlugin.getResourceString("ExtPointError.ContainerNameCollisionSuffix") + ext.getExtensionPointUniqueIdentifier(), null);
        return s;
    }

    protected IStatus getStatusForIDException(IExtension ext, String bundleName, String name) {
        Status s = new Status(4, bundleName, 20, String.valueOf(ECFPlugin.getResourceString("ExtPointError.CommNameCollisionPrefix")) + name + ECFPlugin.getResourceString("ExtPointError.CommNameCollisionSuffix") + ext.getExtensionPointUniqueIdentifier(), null);
        return s;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setupContainerExtensionPoint(context);
        this.setupIdentityExtensionPoint(context);
        this.setupCommExtensionPoint(context);
        this.bundlecontext = context;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.bundlecontext = null;
    }

    public BundleContext getBundleContext() {
        return this.bundlecontext;
    }

    public static ECFPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = ECFPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : "!" + key + "!";
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    class DefaultArgs {
        String[] types;
        String[] defaults;
        String[] names;

        public DefaultArgs(String[] types, String[] defaults, String[] names) {
            this.types = types;
            this.defaults = defaults;
            this.names = names;
        }

        public String[] getDefaults() {
            return this.defaults;
        }

        public String[] getNames() {
            return this.names;
        }

        public String[] getTypes() {
            return this.types;
        }
    }
}

