/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.security.SecureRandom;

public final class Base64 {
    public static String encode(byte[] raw) {
        if (raw == null) {
            throw new NumberFormatException("Input data cannot be null");
        }
        StringBuffer encoded = new StringBuffer();
        int i = 0;
        while (i < raw.length) {
            encoded.append(Base64.encodeBlock(raw, i));
            i += 3;
        }
        return encoded.toString();
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        int i = 0;
        while (i <= end) {
            int b = raw[offset + i];
            int neuter = b < 0 ? b + 256 : b;
            block += neuter << 8 * (2 - i);
            ++i;
        }
        char[] base64 = new char[4];
        int i2 = 0;
        while (i2 < 4) {
            int sixbit = block >>> 6 * (3 - i2) & 0x3F;
            base64[i2] = Base64.getChar(sixbit);
            ++i2;
        }
        if (slack < 1) {
            base64[2] = 45;
        }
        if (slack < 2) {
            base64[3] = 45;
        }
        return base64;
    }

    protected static char getChar(int sixBit) {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '.';
        }
        if (sixBit == 63) {
            return '_';
        }
        return '?';
    }

    public static byte[] decode(String base64) throws NumberFormatException {
        int pad = 0;
        int i = base64.length() - 1;
        while (base64.charAt(i) == '-') {
            ++pad;
            --i;
        }
        int length = base64.length() * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawIndex = 0;
        int i2 = 0;
        while (i2 < base64.length()) {
            int block = (Base64.getValue(base64.charAt(i2)) << 18) + (Base64.getValue(base64.charAt(i2 + 1)) << 12) + (Base64.getValue(base64.charAt(i2 + 2)) << 6) + Base64.getValue(base64.charAt(i2 + 3));
            int j = 0;
            while (j < 3 && rawIndex + j < raw.length) {
                raw[rawIndex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
                ++j;
            }
            rawIndex += 3;
            i2 += 4;
        }
        return raw;
    }

    protected static int getValue(char c) throws NumberFormatException {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '.') {
            return 62;
        }
        if (c == '_') {
            return 63;
        }
        if (c == '-') {
            return 0;
        }
        throw new NumberFormatException("Invalid value '" + c + "' in base64 string");
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Starting Base64 test program.");
        int byteLength = 16;
        SecureRandom ar = new SecureRandom();
        byte[] buf = new byte[byteLength];
        ar.nextBytes(buf);
        System.out.println("Secure random bytes are:");
        int i = 0;
        while (i < buf.length) {
            System.out.print(String.valueOf(buf[i]) + " ");
            ++i;
        }
        System.out.println();
        System.out.println("Converting secure random number to Base64...");
        String res = Base64.encode(buf);
        System.out.println("Converted string is: ");
        System.out.println(res);
        byte[] buf2 = new byte[byteLength];
        System.out.println("Converting string back to byte array...");
        buf2 = Base64.decode(res);
        System.out.println("Converted byte array as: ");
        int i2 = 0;
        while (i2 < buf2.length) {
            System.out.print(String.valueOf(buf2[i2]) + " ");
            ++i2;
        }
        System.out.println();
        System.out.println("Trying to decode a bogus string...");
        buf2 = Base64.decode("ADDFDSFasdfasdf%$###");
        System.out.println("Done.");
    }
}

