/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.Namespace;

public class ServiceID
extends BaseID {
    private static final long serialVersionUID = 1L;
    protected String type;
    protected String name;

    protected ServiceID(Namespace namespace, String type, String name) {
        super(namespace);
        if (type == null) {
            throw new NullPointerException("ServiceID type cannot be null");
        }
        this.type = type;
        this.name = name;
    }

    public ServiceID(String type, String name) {
        this.name = name;
        this.type = type;
    }

    protected String getFullyQualifiedName() {
        if (this.name == null) {
            return this.type;
        }
        return String.valueOf(this.type) + this.name;
    }

    protected int namespaceCompareTo(BaseID o) {
        if (o instanceof ServiceID) {
            ServiceID other = (ServiceID)o;
            String typename = other.getFullyQualifiedName();
            return this.getFullyQualifiedName().compareTo(typename);
        }
        return 1;
    }

    protected boolean namespaceEquals(BaseID o) {
        ServiceID other;
        if (o == null) {
            return false;
        }
        return o instanceof ServiceID && (other = (ServiceID)o).getName().equals(this.getName());
    }

    protected String namespaceGetName() {
        return this.getFullyQualifiedName();
    }

    protected int namespaceHashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    protected URI namespaceToURI() throws URISyntaxException {
        throw new URISyntaxException("cannot create URI from service id with name " + this.getName(), this.getName());
    }

    public String getServiceType() {
        return this.type;
    }

    public String getServiceName() {
        return this.name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ServiceID[");
        buf.append("type=").append(this.type).append(";name=").append(this.name).append(";full=" + this.getFullyQualifiedName()).append("]");
        return buf.toString();
    }
}

