/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDInstantiationException;

public abstract class Namespace
implements Serializable {
    private static final long serialVersionUID = 3976740272094720312L;
    private String name;
    private String description;
    private int hashCode;
    private boolean isInitialized = false;

    public Namespace() {
    }

    public final boolean initialize(String name, String desc) {
        if (name == null) {
            throw new RuntimeException(new InstantiationException("Namespace<init> name cannot be null"));
        }
        if (!this.isInitialized) {
            this.name = name;
            this.description = desc;
            this.hashCode = name.hashCode();
            return true;
        }
        return false;
    }

    public Namespace(String name, String desc) {
        this.initialize(name, desc);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Namespace)) {
            return false;
        }
        return ((Namespace)other).name.equals(this.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected boolean testIDEquals(BaseID first, BaseID second) {
        Namespace sn = second.getNamespace();
        if (sn == null || !this.equals(sn)) {
            return false;
        }
        return first.namespaceEquals(second);
    }

    protected String getNameForID(BaseID id) {
        return id.namespaceGetName();
    }

    protected URI getURIForID(BaseID id) throws URISyntaxException {
        return id.namespaceToURI();
    }

    protected int getCompareToForObject(BaseID first, BaseID second) {
        return first.namespaceCompareTo(second);
    }

    protected int getHashCodeForID(BaseID id) {
        return id.namespaceHashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract ID makeInstance(Class[] var1, Object[] var2) throws IDInstantiationException;

    public abstract String getScheme();

    public String toString() {
        StringBuffer b = new StringBuffer("Namespace[");
        b.append("name=").append(this.name).append(";");
        b.append("scheme=").append(this.getScheme()).append(";");
        b.append("description=").append("]");
        return b.toString();
    }
}

