/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.ecf.core.identity.GUID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDInstantiationException;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.LongID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.NamespacePermission;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.util.AbstractFactory;
import org.eclipse.ecf.internal.core.Trace;

public class IDFactory
implements IIDFactory {
    private static final Trace debug = Trace.create("idfactory");
    public static final String SECURITY_PROPERTY;
    private static Hashtable namespaces;
    private static boolean securityEnabled;
    protected static IIDFactory instance;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SECURITY_PROPERTY = String.valueOf(clazz.getName()) + ".security";
        namespaces = new Hashtable();
        securityEnabled = false;
        instance = null;
        instance = new IDFactory();
        IDFactory.addNamespace0(new StringID.StringIDNamespace());
        IDFactory.addNamespace0(new GUID.GUIDNamespace());
        IDFactory.addNamespace0(new LongID.LongNamespace());
        try {
            securityEnabled = System.getProperty(SECURITY_PROPERTY) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected IDFactory() {
    }

    public static IIDFactory getDefault() {
        return instance;
    }

    public Namespace addNamespace(Namespace n) throws SecurityException {
        if (n == null) {
            return null;
        }
        IDFactory.checkPermission(new NamespacePermission(n.toString(), "add"));
        return IDFactory.addNamespace0(n);
    }

    protected static final Namespace addNamespace0(Namespace n) {
        if (n == null) {
            return null;
        }
        return namespaces.put(n.getName(), n);
    }

    protected static final void checkPermission(NamespacePermission p) throws SecurityException {
        if (securityEnabled) {
            AccessController.checkPermission(p);
        }
    }

    public boolean containsNamespace(Namespace n) throws SecurityException {
        IDFactory.debug("containsNamespace(" + n + ")");
        if (n == null) {
            return false;
        }
        IDFactory.checkPermission(new NamespacePermission(n.toString(), "contains"));
        return IDFactory.containsNamespace0(n);
    }

    public List getNamespaces() {
        IDFactory.debug("getNamespaces()");
        return new ArrayList(namespaces.values());
    }

    private static void debug(String msg) {
        if (Trace.ON && debug != null) {
            debug.msg(msg);
        }
    }

    private static void dumpStack(String msg, Throwable e) {
        if (Trace.ON && debug != null) {
            debug.dumpStack(e, msg);
        }
    }

    protected static final boolean containsNamespace0(Namespace n) {
        if (n == null) {
            return false;
        }
        return namespaces.containsKey(n.getName());
    }

    public Namespace getNamespace(Namespace n) throws SecurityException {
        IDFactory.debug("getNamespace(" + n + ")");
        if (n == null) {
            return null;
        }
        IDFactory.checkPermission(new NamespacePermission(n.toString(), "get"));
        return IDFactory.getNamespace0(n);
    }

    public Namespace getNamespaceByName(String name) throws SecurityException {
        IDFactory.debug("getNamespaceByName(" + name + ")");
        return IDFactory.getNamespace0(name);
    }

    protected static final Namespace getNamespace0(Namespace n) {
        if (n == null) {
            return null;
        }
        return (Namespace)namespaces.get(n.getName());
    }

    protected static final Namespace getNamespace0(String name) {
        if (name == null) {
            return null;
        }
        return (Namespace)namespaces.get(name);
    }

    public ID makeGUID() throws IDInstantiationException {
        return this.makeGUID(20);
    }

    public ID makeGUID(int length) throws IDInstantiationException {
        IDFactory.debug("makeGUID(" + length + ")");
        GUID.GUIDNamespace n = new GUID.GUIDNamespace();
        String[] stringArray = new String[2];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.core.identity.Namespace");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz2.getName();
        return this.makeID(n, stringArray, new Object[]{n, new Integer(length)});
    }

    protected static void log(String s) {
        IDFactory.debug(s);
    }

    protected static void logException(String s, Throwable t) {
        IDFactory.dumpStack(s, t);
    }

    protected static void logAndThrow(String s, Throwable t) throws IDInstantiationException {
        IDInstantiationException e = null;
        if (t != null) {
            e = new IDInstantiationException(String.valueOf(s) + ": " + t.getClass().getName() + ": " + t.getMessage());
            e.setStackTrace(t.getStackTrace());
        } else {
            e = new IDInstantiationException(s);
        }
        IDFactory.logException(s, t);
        throw e;
    }

    protected static void logAndThrow(String s) throws IDInstantiationException {
        IDInstantiationException e = new IDInstantiationException(s);
        IDFactory.logException(s, null);
        throw e;
    }

    public ID makeID(Namespace n, String[] argTypes, Object[] args) throws IDInstantiationException {
        Namespace ns;
        IDFactory.debug("makeID(" + n + "," + Trace.convertStringAToString(argTypes) + "," + Trace.convertObjectAToString(args) + ")");
        if (n == null) {
            IDFactory.logAndThrow("Namespace cannot be null");
        }
        if ((ns = IDFactory.getNamespace0(n)) == null) {
            IDFactory.logAndThrow("Namespace '" + n.getName() + "' not found");
        }
        Class[] clazzes = null;
        ClassLoader cl = ns.getClass().getClassLoader();
        try {
            clazzes = AbstractFactory.getClassesForTypes(argTypes, args, cl);
        }
        catch (ClassNotFoundException e) {
            IDFactory.logAndThrow("Exception in getClassesForTypes", e);
        }
        return ns.makeInstance(clazzes, args);
    }

    public ID makeID(String namespacename, String[] argTypes, Object[] args) throws IDInstantiationException {
        Namespace n = this.getNamespaceByName(namespacename);
        if (n == null) {
            throw new IDInstantiationException("Namespace named " + namespacename + " not found");
        }
        return this.makeID(n, argTypes, args);
    }

    public ID makeID(Namespace n, Object[] args) throws IDInstantiationException {
        return this.makeID(n, null, args);
    }

    public ID makeID(String namespacename, Object[] args) throws IDInstantiationException {
        Namespace n = this.getNamespaceByName(namespacename);
        if (n == null) {
            throw new IDInstantiationException("Namespace " + namespacename + " not found");
        }
        return this.makeID(n, args);
    }

    public ID makeID(Namespace namespace, URI uri) throws IDInstantiationException {
        return this.makeID(namespace, new Object[]{uri});
    }

    public ID makeID(String namespacename, URI uri) throws IDInstantiationException {
        if (uri == null) {
            throw new IDInstantiationException("Null uri not allowed");
        }
        Namespace n = this.getNamespaceByName(namespacename);
        if (n == null) {
            throw new IDInstantiationException("Namespace " + n + " not found");
        }
        return this.makeID(n, new Object[]{uri});
    }

    public ID makeID(Namespace namespace, String uri) throws IDInstantiationException {
        return this.makeID(namespace, new Object[]{uri});
    }

    public ID makeID(String namespace, String uri) throws IDInstantiationException {
        return this.makeID(namespace, new Object[]{uri});
    }

    public ID makeStringID(String idstring) throws IDInstantiationException {
        if (idstring == null) {
            throw new IDInstantiationException("String cannot be null");
        }
        StringID.StringIDNamespace n = new StringID.StringIDNamespace();
        String[] stringArray = new String[1];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        return this.makeID(n, stringArray, new Object[]{idstring});
    }

    public ID makeLongID(Long l) throws IDInstantiationException {
        if (l == null) {
            throw new IDInstantiationException("Long cannot be null");
        }
        LongID.LongNamespace n = new LongID.LongNamespace();
        String[] stringArray = new String[1];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        return this.makeID(n, stringArray, new Object[]{l});
    }

    public ID makeLongID(long l) throws IDInstantiationException {
        LongID.LongNamespace n = new LongID.LongNamespace();
        String[] stringArray = new String[1];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        return this.makeID(n, stringArray, new Object[]{new Long(l)});
    }

    public Namespace removeNamespace(Namespace n) throws SecurityException {
        IDFactory.debug("removeNamespace(" + n + ")");
        if (n == null) {
            return null;
        }
        IDFactory.checkPermission(new NamespacePermission(n.toString(), "remove"));
        return IDFactory.removeNamespace0(n);
    }

    protected static final Namespace removeNamespace0(Namespace n) {
        if (n == null) {
            return null;
        }
        return (Namespace)namespaces.remove(n);
    }
}

