/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.security.SecureRandom;
import java.security.Security;
import java.util.Set;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDInstantiationException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.util.Base64;

public class GUID
extends StringID {
    private static final long serialVersionUID = 3545794369039972407L;
    public static final String SR_DEFAULT_ALGO = null;
    public static final String SR_DEFAULT_PROVIDER = null;
    public static final int DEFAULT_BYTE_LENGTH = 20;
    protected static transient SecureRandom random;

    protected GUID(Namespace n, String algo, String provider, int byteLength) throws IDInstantiationException {
        super(n, "");
        try {
            GUID.getRandom(algo, provider);
        }
        catch (Exception e) {
            throw new IDInstantiationException("GUID creation failure: " + e.getMessage());
        }
        if (byteLength <= 0) {
            byteLength = 1;
        }
        byte[] newBytes = new byte[byteLength];
        random.nextBytes(newBytes);
        this.value = Base64.encode(newBytes);
    }

    protected GUID(Namespace n, int byteLength) throws IDInstantiationException {
        this(n, SR_DEFAULT_ALGO, SR_DEFAULT_PROVIDER, byteLength);
    }

    protected GUID(Namespace n) throws IDInstantiationException {
        this(n, 20);
    }

    protected static synchronized SecureRandom getRandom(String algo, String provider) throws Exception {
        if (random == null) {
            GUID.initializeRandom(algo, provider);
        }
        return random;
    }

    protected static synchronized void initializeRandom(String algo, String provider) throws Exception {
        if (provider == null) {
            if (algo == null) {
                Set<String> algos = Security.getAlgorithms("SecureRandom");
                algo = algos.contains("IBMSECURERANDOM") ? "IBMSECURERANDOM" : "SHA1PRNG";
            }
            random = SecureRandom.getInstance(algo);
        } else {
            random = SecureRandom.getInstance(algo, provider);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GUID[");
        sb.append(this.value).append("]");
        return sb.toString();
    }

    public static class GUIDNamespace
    extends Namespace {
        private static final long serialVersionUID = -8546568877571886386L;
        static /* synthetic */ Class class$0;

        public GUIDNamespace() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.GUID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(clazz.getName(), "GUID Namespace");
        }

        public ID makeInstance(Class[] argTypes, Object[] args) throws IDInstantiationException {
            if (args.length == 1) {
                return new GUID((Namespace)this, (Integer)args[0]);
            }
            return new GUID(this);
        }

        public String getScheme() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.GUID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz.getName();
        }
    }
}

