/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;

public abstract class BaseID
implements ID {
    Namespace namespace;

    protected BaseID() {
    }

    protected BaseID(Namespace namespace) {
        if (namespace == null) {
            throw new RuntimeException(new InstantiationException("namespace cannot be null"));
        }
        this.namespace = namespace;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof BaseID)) {
            throw new ClassCastException("incompatible types for compare");
        }
        return this.namespace.getCompareToForObject(this, (BaseID)o);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof BaseID)) {
            return false;
        }
        return this.namespace.testIDEquals(this, (BaseID)o);
    }

    public String getName() {
        return this.namespace.getNameForID(this);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        return this.namespace.getHashCodeForID(this);
    }

    protected abstract int namespaceCompareTo(BaseID var1);

    protected abstract boolean namespaceEquals(BaseID var1);

    protected abstract String namespaceGetName();

    protected abstract int namespaceHashCode();

    protected abstract URI namespaceToURI() throws URISyntaxException;

    public URI toURI() throws URISyntaxException {
        return this.namespace.getURIForID(this);
    }
}

