/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.comm;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.ecf.core.comm.ConnectionDescription;
import org.eclipse.ecf.core.comm.ConnectionInstantiationException;
import org.eclipse.ecf.core.comm.ISynchAsynchConnection;
import org.eclipse.ecf.core.comm.ISynchAsynchConnectionEventHandler;
import org.eclipse.ecf.core.comm.provider.ISynchAsynchConnectionInstantiator;
import org.eclipse.ecf.core.util.AbstractFactory;
import org.eclipse.ecf.internal.core.Trace;

public class ConnectionFactory {
    private static Hashtable connectiontypes = new Hashtable();
    private static Trace debug = Trace.create("connectionfactory");

    public static final ConnectionDescription addDescription(ConnectionDescription scd) {
        ConnectionFactory.debug("addDescription(" + scd + ")");
        return ConnectionFactory.addDescription0(scd);
    }

    protected static ConnectionDescription addDescription0(ConnectionDescription n) {
        if (n == null) {
            return null;
        }
        return connectiontypes.put(n.getName(), n);
    }

    public static final boolean containsDescription(ConnectionDescription scd) {
        return ConnectionFactory.containsDescription0(scd);
    }

    protected static boolean containsDescription0(ConnectionDescription scd) {
        if (scd == null) {
            return false;
        }
        return connectiontypes.containsKey(scd.getName());
    }

    private static void debug(String msg) {
        if (Trace.ON && debug != null) {
            debug.msg(msg);
        }
    }

    private static void dumpStack(String msg, Throwable e) {
        if (Trace.ON && debug != null) {
            debug.dumpStack(e, msg);
        }
    }

    public static final ConnectionDescription getDescription(ConnectionDescription scd) {
        return ConnectionFactory.getDescription0(scd);
    }

    protected static ConnectionDescription getDescription0(ConnectionDescription scd) {
        if (scd == null) {
            return null;
        }
        return (ConnectionDescription)connectiontypes.get(scd.getName());
    }

    protected static ConnectionDescription getDescription0(String name) {
        if (name == null) {
            return null;
        }
        return (ConnectionDescription)connectiontypes.get(name);
    }

    public static final ConnectionDescription getDescriptionByName(String name) {
        return ConnectionFactory.getDescription0(name);
    }

    public static final List getDescriptions() {
        return ConnectionFactory.getDescriptions0();
    }

    protected static List getDescriptions0() {
        return new ArrayList(connectiontypes.values());
    }

    public static ISynchAsynchConnection makeSynchAsynchConnection(ISynchAsynchConnectionEventHandler handler, ConnectionDescription desc, Object[] args) throws ConnectionInstantiationException {
        if (handler == null) {
            throw new ConnectionInstantiationException("handler cannot be null");
        }
        return ConnectionFactory.makeSynchAsynchConnection(handler, desc, null, args);
    }

    public static ISynchAsynchConnection makeSynchAsynchConnection(ISynchAsynchConnectionEventHandler handler, ConnectionDescription desc, String[] argTypes, Object[] args) throws ConnectionInstantiationException {
        ConnectionFactory.debug("makeSynchAsynchConnection(" + handler + "," + desc + "," + Trace.convertStringAToString(argTypes) + "," + Trace.convertObjectAToString(args) + ")");
        if (handler == null) {
            throw new ConnectionInstantiationException("ISynchAsynchConnectionEventHandler cannot be null");
        }
        if (desc == null) {
            throw new ConnectionInstantiationException("ConnectionDescription cannot be null");
        }
        ConnectionDescription cd = desc;
        if (cd == null) {
            throw new ConnectionInstantiationException("ConnectionDescription " + desc.getName() + " not found");
        }
        ISynchAsynchConnectionInstantiator instantiator = null;
        Class[] clazzes = null;
        try {
            instantiator = cd.getInstantiator();
            clazzes = AbstractFactory.getClassesForTypes(argTypes, args, cd.getClassLoader());
            if (instantiator == null) {
                throw new InstantiationException("Instantiator for ConnectionDescription " + cd.getName() + " is null");
            }
        }
        catch (Exception e) {
            ConnectionInstantiationException newexcept = new ConnectionInstantiationException("makeSynchAsynchConnection exception with description: " + desc + ": " + e.getClass().getName() + ": " + e.getMessage());
            newexcept.setStackTrace(e.getStackTrace());
            ConnectionFactory.dumpStack("Exception in makeSynchAsynchConnection", newexcept);
            throw newexcept;
        }
        return instantiator.makeInstance(desc, handler, clazzes, args);
    }

    public static ISynchAsynchConnection makeSynchAsynchConnection(ISynchAsynchConnectionEventHandler handler, String descriptionName) throws ConnectionInstantiationException {
        if (handler == null) {
            throw new ConnectionInstantiationException("ISynchAsynchConnectionEventHandler cannot be null");
        }
        ConnectionDescription desc = ConnectionFactory.getDescriptionByName(descriptionName);
        if (desc == null) {
            throw new ConnectionInstantiationException("Connection type named '" + descriptionName + "' not found");
        }
        return ConnectionFactory.makeSynchAsynchConnection(handler, desc, null, null);
    }

    public static ISynchAsynchConnection makeSynchAsynchConnection(ISynchAsynchConnectionEventHandler handler, String descriptionName, Object[] args) throws ConnectionInstantiationException {
        if (handler == null) {
            throw new ConnectionInstantiationException("ISynchAsynchConnectionEventHandler cannot be null");
        }
        ConnectionDescription desc = ConnectionFactory.getDescriptionByName(descriptionName);
        if (desc == null) {
            throw new ConnectionInstantiationException("Connection type named '" + descriptionName + "' not found");
        }
        return ConnectionFactory.makeSynchAsynchConnection(handler, desc, args);
    }

    public static ISynchAsynchConnection makeSynchAsynchConnection(ISynchAsynchConnectionEventHandler handler, String descriptionName, String[] argTypes, Object[] args) throws ConnectionInstantiationException {
        if (handler == null) {
            throw new ConnectionInstantiationException("ISynchAsynchConnectionEventHandler cannot be null");
        }
        ConnectionDescription desc = ConnectionFactory.getDescriptionByName(descriptionName);
        if (desc == null) {
            throw new ConnectionInstantiationException("Connection type named '" + descriptionName + "' not found");
        }
        return ConnectionFactory.makeSynchAsynchConnection(handler, desc, argTypes, args);
    }

    public static final ConnectionDescription removeDescription(ConnectionDescription scd) {
        ConnectionFactory.debug("removeDescription(" + scd + ")");
        return ConnectionFactory.removeDescription0(scd);
    }

    protected static ConnectionDescription removeDescription0(ConnectionDescription n) {
        if (n == null) {
            return null;
        }
        return (ConnectionDescription)connectiontypes.remove(n.getName());
    }
}

