/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.comm;

import org.eclipse.ecf.core.comm.provider.ISynchAsynchConnectionInstantiator;

public class ConnectionDescription {
    protected String name;
    protected String instantiatorClass;
    protected ISynchAsynchConnectionInstantiator instantiator;
    protected int hashCode = 0;
    protected ClassLoader classLoader = null;
    protected String description;
    protected String[] argTypes;
    protected String[] argDefaults;
    protected String[] argNames;
    protected static final String[] EMPTY = new String[0];

    public ConnectionDescription(ClassLoader loader, String name, String instantiatorClass, String desc, String[] defTypes, String[] defValues, String[] defNames) {
        if (name == null) {
            throw new RuntimeException(new InstantiationException("ConnectionDescription<init> name cannot be null"));
        }
        if (instantiatorClass == null) {
            throw new RuntimeException(new InstantiationException("ConnectionDescription<init> instantiatorClass cannot be null"));
        }
        this.classLoader = loader;
        this.name = name;
        this.instantiatorClass = instantiatorClass;
        this.hashCode = name.hashCode();
        this.argTypes = defTypes;
        this.argDefaults = defValues;
        this.argNames = defNames;
    }

    public ConnectionDescription(ClassLoader loader, String name, String instantiatorClass, String desc) {
        this(loader, name, instantiatorClass, desc, EMPTY, EMPTY, EMPTY);
    }

    public ConnectionDescription(String name, String instantiatorClass, String desc) {
        this(null, name, instantiatorClass, desc);
    }

    public ConnectionDescription(String name, ISynchAsynchConnectionInstantiator inst, String desc, String[] defTypes, String[] defValues, String[] defNames) {
        if (name == null) {
            throw new RuntimeException(new InstantiationException("ConnectionDescription<init> name cannot be null"));
        }
        if (inst == null) {
            throw new RuntimeException(new InstantiationException("ConnectionDescription<init> instantiator instance cannot be null"));
        }
        this.instantiator = inst;
        this.name = name;
        this.classLoader = this.instantiator.getClass().getClassLoader();
        this.instantiatorClass = this.instantiator.getClass().getName();
        this.hashCode = name.hashCode();
        this.description = desc;
        this.argTypes = defTypes;
        this.argDefaults = defValues;
        this.argNames = defNames;
    }

    public ConnectionDescription(String name, ISynchAsynchConnectionInstantiator inst, String desc) {
        this(name, inst, desc, EMPTY, EMPTY, EMPTY);
    }

    public String getName() {
        return this.name;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConnectionDescription)) {
            return false;
        }
        ConnectionDescription scd = (ConnectionDescription)other;
        return scd.name.equals(this.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("ConnectionDescription[");
        b.append("name:").append(this.name).append(";");
        if (this.instantiator == null) {
            b.append("class:").append(this.instantiatorClass).append(";");
        } else {
            b.append("instantiator:").append(this.instantiator).append(";");
        }
        b.append("desc:").append(this.description).append("]");
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISynchAsynchConnectionInstantiator getInstantiator() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ConnectionDescription connectionDescription = this;
        synchronized (connectionDescription) {
            if (this.instantiator == null) {
                this.initializeInstantiator(this.classLoader);
            }
            return this.instantiator;
        }
    }

    protected void initializeInstantiator(ClassLoader cl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        Class<?> clazz = Class.forName(this.instantiatorClass, true, cl);
        this.instantiator = (ISynchAsynchConnectionInstantiator)clazz.newInstance();
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getArgDefaults() {
        return this.argDefaults;
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    public String[] getArgTypes() {
        return this.argTypes;
    }
}

