/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core;

import org.eclipse.ecf.core.ContainerDescription;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.ContainerInstantiationException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.ISharedObjectContainer;
import org.eclipse.ecf.core.ISharedObjectContainerFactory;
import org.eclipse.ecf.internal.core.Trace;

public class SharedObjectContainerFactory
implements ISharedObjectContainerFactory {
    private static Trace debug = Trace.create("sharedobjectcontainerfactory");
    protected static ISharedObjectContainerFactory instance = null;
    static /* synthetic */ Class class$0;

    static {
        instance = new SharedObjectContainerFactory();
    }

    protected SharedObjectContainerFactory() {
    }

    public static ISharedObjectContainerFactory getDefault() {
        return instance;
    }

    private static void trace(String msg) {
        if (Trace.ON && debug != null) {
            debug.msg(msg);
        }
    }

    public ISharedObjectContainer makeSharedObjectContainer(ContainerDescription desc, String[] argTypes, Object[] args) throws ContainerInstantiationException {
        ISharedObjectContainer soContainer;
        SharedObjectContainerFactory.trace("makeSharedObjectContainer(" + desc + "," + Trace.convertStringAToString(argTypes) + "," + Trace.convertObjectAToString(args) + ")");
        if (desc == null) {
            throw new ContainerInstantiationException("ContainerDescription cannot be null");
        }
        IContainer newContainer = ContainerFactory.getDefault().makeContainer(desc, argTypes, args);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.ISharedObjectContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((soContainer = (ISharedObjectContainer)newContainer.getAdapter(clazz)) == null) {
            newContainer.dispose();
            throw new ContainerInstantiationException("new container is not a shared object container");
        }
        return soContainer;
    }

    public ISharedObjectContainer makeSharedObjectContainer(String descriptionName) throws ContainerInstantiationException {
        return this.makeSharedObjectContainer(ContainerFactory.getDefault().getDescriptionByName(descriptionName), null, null);
    }

    public ISharedObjectContainer makeSharedObjectContainer(String descriptionName, Object[] args) throws ContainerInstantiationException {
        return this.makeSharedObjectContainer(ContainerFactory.getDefault().getDescriptionByName(descriptionName), null, args);
    }

    public ISharedObjectContainer makeSharedObjectContainer(String descriptionName, String[] argsTypes, Object[] args) throws ContainerInstantiationException {
        return this.makeSharedObjectContainer(ContainerFactory.getDefault().getDescriptionByName(descriptionName), argsTypes, args);
    }
}

