/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.ecf.core.ContainerDescription;
import org.eclipse.ecf.core.ContainerInstantiationException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.AbstractFactory;
import org.eclipse.ecf.internal.core.Trace;

public class ContainerFactory
implements IContainerFactory {
    private static Trace debug = Trace.create("containerfactory");
    private static Hashtable containerdescriptions = new Hashtable();
    protected static IContainerFactory instance = null;

    static {
        instance = new ContainerFactory();
    }

    protected ContainerFactory() {
    }

    public static IContainerFactory getDefault() {
        return instance;
    }

    private static void trace(String msg) {
        if (Trace.ON && debug != null) {
            debug.msg(msg);
        }
    }

    private static void dumpStack(String msg, Throwable e) {
        if (Trace.ON && debug != null) {
            debug.dumpStack(e, msg);
        }
    }

    public ContainerDescription addDescription(ContainerDescription scd) {
        ContainerFactory.trace("addDescription(" + scd + ")");
        return this.addDescription0(scd);
    }

    public List getDescriptions() {
        return this.getDescriptions0();
    }

    protected List getDescriptions0() {
        return new ArrayList(containerdescriptions.values());
    }

    protected ContainerDescription addDescription0(ContainerDescription n) {
        if (n == null) {
            return null;
        }
        return containerdescriptions.put(n.getName(), n);
    }

    public boolean containsDescription(ContainerDescription scd) {
        return this.containsDescription0(scd);
    }

    protected boolean containsDescription0(ContainerDescription scd) {
        if (scd == null) {
            return false;
        }
        return containerdescriptions.containsKey(scd.getName());
    }

    protected ContainerDescription getDescription0(ContainerDescription scd) {
        if (scd == null) {
            return null;
        }
        return (ContainerDescription)containerdescriptions.get(scd.getName());
    }

    protected ContainerDescription getDescription0(String name) {
        if (name == null) {
            return null;
        }
        return (ContainerDescription)containerdescriptions.get(name);
    }

    public ContainerDescription getDescriptionByName(String name) throws ContainerInstantiationException {
        ContainerFactory.trace("getDescriptionByName(" + name + ")");
        ContainerDescription res = this.getDescription0(name);
        if (res == null) {
            throw new ContainerInstantiationException("ContainerDescription named '" + name + "' not found");
        }
        return res;
    }

    public IContainer makeContainer(ContainerDescription desc, String[] argTypes, Object[] args) throws ContainerInstantiationException {
        ContainerFactory.trace("makeContainer(" + desc + "," + Trace.convertStringAToString(argTypes) + "," + Trace.convertObjectAToString(args) + ")");
        if (desc == null) {
            throw new ContainerInstantiationException("ContainerDescription cannot be null");
        }
        ContainerDescription cd = this.getDescription0(desc);
        if (cd == null) {
            throw new ContainerInstantiationException("ContainerDescription named '" + desc.getName() + "' not found");
        }
        Class[] clazzes = null;
        IContainerInstantiator instantiator = null;
        try {
            instantiator = cd.getInstantiator();
            clazzes = AbstractFactory.getClassesForTypes(argTypes, args, cd.getClassLoader());
        }
        catch (Exception e) {
            ContainerInstantiationException newexcept = new ContainerInstantiationException("makeContainer exception with description: " + desc + ": " + e.getClass().getName() + ": " + e.getMessage());
            newexcept.setStackTrace(e.getStackTrace());
            ContainerFactory.dumpStack("Exception in makeContainer", newexcept);
            throw newexcept;
        }
        if (instantiator == null) {
            throw new ContainerInstantiationException("Instantiator for ContainerDescription " + cd.getName() + " is null");
        }
        return instantiator.makeInstance(desc, clazzes, args);
    }

    public IContainer makeContainer(String descriptionName) throws ContainerInstantiationException {
        return this.makeContainer(this.getDescriptionByName(descriptionName), null, null);
    }

    public IContainer makeContainer(String descriptionName, Object[] args) throws ContainerInstantiationException {
        return this.makeContainer(this.getDescriptionByName(descriptionName), null, args);
    }

    public IContainer makeContainer(String descriptionName, String[] argsTypes, Object[] args) throws ContainerInstantiationException {
        return this.makeContainer(this.getDescriptionByName(descriptionName), argsTypes, args);
    }

    public ContainerDescription removeDescription(ContainerDescription scd) {
        ContainerFactory.trace("removeDescription(" + scd + ")");
        return this.removeDescription0(scd);
    }

    protected ContainerDescription removeDescription0(ContainerDescription n) {
        if (n == null) {
            return null;
        }
        return (ContainerDescription)containerdescriptions.remove(n.getName());
    }
}

