/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ecf.core.provider.IContainerInstantiator;

public class ContainerDescription {
    protected String name;
    protected String instantiatorClass;
    protected ClassLoader classLoader;
    protected IContainerInstantiator instantiator;
    protected String description;
    protected String[] argTypes;
    protected String[] argDefaults;
    protected String[] argNames;
    protected int hashCode = 0;
    protected static final String[] EMPTY = new String[0];
    protected Map properties;

    public ContainerDescription(ClassLoader loader, String name, String instantiatorClass, String desc) {
        this(loader, name, instantiatorClass, desc, EMPTY, EMPTY, EMPTY);
    }

    public ContainerDescription(String name, String instantiatorClass, String desc) {
        this(null, name, instantiatorClass, desc);
    }

    public ContainerDescription(ClassLoader loader, String name, String instantiatorClass, String desc, String[] argTypes, String[] argDefaults, String[] argNames) {
        this(loader, name, instantiatorClass, desc, argTypes, argDefaults, argNames, new Properties());
    }

    public ContainerDescription(ClassLoader loader, String name, String instantiatorClass, String desc, String[] argTypes, String[] argDefaults, String[] argNames, Map props) {
        this.classLoader = loader;
        if (name == null) {
            throw new RuntimeException(new InstantiationException("SharedObjectContainerDescription<init> name cannot be null"));
        }
        this.name = name;
        if (instantiatorClass == null) {
            throw new RuntimeException(new InstantiationException("SharedObjectContainerDescription<init> instantiatorClass cannot be null"));
        }
        this.instantiatorClass = instantiatorClass;
        this.hashCode = name.hashCode();
        this.description = desc;
        this.argTypes = argTypes;
        this.argDefaults = argDefaults;
        this.argNames = argNames;
        this.properties = props;
    }

    public ContainerDescription(String name, IContainerInstantiator inst, String desc, String[] argTypes, String[] argDefaults, String[] argNames) {
        this(name, inst, desc, argTypes, argDefaults, argNames, new Properties());
    }

    public ContainerDescription(String name, IContainerInstantiator inst, String desc, String[] argTypes, String[] argDefaults, String[] argNames, Map props) {
        if (name == null) {
            throw new RuntimeException(new InstantiationException("SharedObjectContainerDescription<init> name cannot be null"));
        }
        if (inst == null) {
            throw new RuntimeException(new InstantiationException("SharedObjectContainerDescription<init> instantiator instance cannot be null"));
        }
        this.instantiator = inst;
        this.name = name;
        this.classLoader = this.instantiator.getClass().getClassLoader();
        this.description = desc;
        this.argTypes = argTypes;
        this.argDefaults = argDefaults;
        this.argNames = argNames;
        this.properties = props;
    }

    public ContainerDescription(String name, IContainerInstantiator inst, String desc) {
        this(name, inst, desc, EMPTY, EMPTY, EMPTY);
    }

    public String getName() {
        return this.name;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ContainerDescription)) {
            return false;
        }
        ContainerDescription scd = (ContainerDescription)other;
        return scd.name.equals(this.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("SharedObjectContainerDescription[");
        b.append("name:").append(this.name).append(";");
        if (this.instantiator == null) {
            b.append("class:").append(this.instantiatorClass).append(";");
        } else {
            b.append("instantiator:").append(this.instantiator).append(";");
        }
        b.append("desc:").append(this.description).append(";");
        b.append("argtypes:").append(Arrays.asList(this.argTypes)).append(";");
        b.append("argdefaults:").append(Arrays.asList(this.argDefaults)).append(";");
        b.append("argnames:").append(Arrays.asList(this.argNames)).append("]");
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IContainerInstantiator getInstantiator() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ContainerDescription containerDescription = this;
        synchronized (containerDescription) {
            if (this.instantiator == null) {
                this.initializeInstantiator(this.classLoader);
            }
            return this.instantiator;
        }
    }

    private void initializeInstantiator(ClassLoader cl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        Class<?> clazz = Class.forName(this.instantiatorClass, true, cl);
        this.instantiator = (IContainerInstantiator)clazz.newInstance();
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getArgDefaults() {
        return this.argDefaults;
    }

    public String[] getArgTypes() {
        return this.argTypes;
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    public Map getProperties() {
        return this.properties;
    }
}

