/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.util.ComboWithEnableFix;
import edu.cmu.cs.hcii.cogtool.util.IStatusDisplayable;
import edu.cmu.cs.hcii.cogtool.util.IZoomable;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import edu.cmu.cs.hcii.cogtool.util.RcvrUIException;
import edu.cmu.cs.hcii.cogtool.view.Palette;
import edu.cmu.cs.hcii.cogtool.view.StatusBar;
import java.security.InvalidParameterException;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class StandardDrawingEditor
implements IStatusDisplayable {
    protected static final int MOUSE_DOWN = 0;
    protected static final int MOUSE_UP = 1;
    protected static final int MOUSE_DOUBLECLICK = 2;
    protected static final int MOUSE_MOVE = 3;
    protected static final int MOUSE_DRAG = 4;
    protected static final int MOUSE_EXIT = 5;
    protected static final int MOUSE_ENTER = 6;
    protected static final double MINIMUM_ZOOM = 0.1;
    protected static final double MAXIMUM_ZOOM = 5.0;
    protected static final Pattern ZOOM_VALUE_PATTERN = Pattern.compile(L10N.get("SDE.zoomValuePattern", "\\s*(\\d+\\.?\\d*)\\s*%?\\s*"));
    protected Composite bodyComposite;
    protected ScrolledComposite scrollComposite;
    protected Composite editorComposite;
    protected Composite zoomComposite;
    protected Combo zoomCombo;
    protected Composite propertiesComposite;
    protected Palette paletteComposite;
    protected Canvas canvas;
    protected boolean capturingEvents = false;
    protected CapturedEventForwarder eventForwarder = new CapturedEventForwarder();
    boolean resizingEditor = false;
    protected LightweightSystem lws;
    protected StatusBar statusBar;
    protected int propertiesSize;
    protected int propertiesPaneLocation;
    protected IZoomable zoomable;
    protected FormData scrollFormData;
    protected FormData zoomFormData;
    protected FormData propFormData;

    public StandardDrawingEditor(Composite window, int propertiesPaneSize, int paletteSize, IZoomable zoom) {
        this(window, propertiesPaneSize, 1024, paletteSize, zoom);
    }

    public StandardDrawingEditor(Composite window, int propertiesPaneSize, int propertiesPaneLocation, int paletteSize, IZoomable zoom) {
        this(window, propertiesPaneSize, propertiesPaneLocation, paletteSize, zoom, 0);
    }

    public StandardDrawingEditor(Composite window, int propertiesPaneSize, int propertiesPaneLocation, int paletteSize, IZoomable zoom, int offsetScrollAreaBottom) {
        switch (propertiesPaneLocation) {
            case 128: 
            case 1024: 
            case 16384: 
            case 131072: {
                break;
            }
            default: {
                throw new InvalidParameterException("PropertiesPaneLocation must be one of SWT.TOP, SWT.BOTTOM, SWT.LEFT, SWT.RIGHT");
            }
        }
        this.propertiesSize = propertiesPaneSize;
        this.propertiesPaneLocation = propertiesPaneLocation;
        this.bodyComposite = new Composite(window, 0);
        FormLayout propertiesLayout = new FormLayout();
        this.bodyComposite.setLayout((Layout)propertiesLayout);
        this.scrollComposite = new ScrolledComposite(this.bodyComposite, 2816);
        this.statusBar = new StatusBar(this.bodyComposite);
        this.scrollComposite.setAlwaysShowScrollBars(true);
        this.editorComposite = new Composite((Composite)this.scrollComposite, 0);
        this.editorComposite.setLayout((Layout)new FillLayout());
        this.scrollComposite.setContent((Control)this.editorComposite);
        this.propertiesComposite = new Composite(this.bodyComposite, 0);
        this.zoomComposite = new Composite(this.bodyComposite, 0);
        this.paletteComposite = new Palette(this.bodyComposite, 0);
        this.zoomable = zoom;
        Label label = new Label(this.zoomComposite, 131072);
        label.setText(L10N.get("SDE.ZOOM", "Zoom: "));
        this.zoomCombo = new ComboWithEnableFix(this.zoomComposite, 4);
        this.zoomCombo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent evt) {
                evt.doit = Character.getType(evt.character) == 15 || Character.getType(evt.character) == 9 || evt.keyCode == 46 || evt.keyCode == 16777262;
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.zoomCombo.setItems(new String[]{L10N.get("SDE.50%", "50 %"), L10N.get("SDE.100%", "100 %"), L10N.get("SDE.150%", "150 %"), L10N.get("SDE.200%", "200 %"), L10N.get("SDE.ZoomToFit", "Zoom to Fit")});
        this.zoomCombo.select(1);
        this.zoomCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                int index = ((Combo)arg0.widget).getSelectionIndex();
                switch (index) {
                    case 0: {
                        StandardDrawingEditor.this.zoomable.performZoom(0.5);
                        break;
                    }
                    case 1: {
                        StandardDrawingEditor.this.zoomable.performZoom(1.0);
                        break;
                    }
                    case 2: {
                        StandardDrawingEditor.this.zoomable.performZoom(1.5);
                        break;
                    }
                    case 3: {
                        StandardDrawingEditor.this.zoomable.performZoom(2.0);
                        break;
                    }
                    case 4: {
                        StandardDrawingEditor.this.zoomable.performZoom(StandardDrawingEditor.this.zoomable.computeZoomToFit());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                String input = ((Combo)evt.getSource()).getText();
                StandardDrawingEditor.this.setZoomFromUserInput(input);
            }
        });
        this.zoomCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                if (OSUtils.MACOSX && evt.keyCode == 0x1000050) {
                    String input = ((Combo)evt.getSource()).getText();
                    StandardDrawingEditor.this.setZoomFromUserInput(input);
                }
            }
        });
        this.zoomComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.statusBar.setLayoutData(formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, -5);
        this.zoomCombo.setLayoutData((Object)formData);
        formData = new FormData();
        formData.bottom = new FormAttachment((Control)this.zoomCombo, -5, 1024);
        formData.right = new FormAttachment((Control)this.zoomCombo, -5, 16384);
        label.setLayoutData((Object)formData);
        this.canvas = new Canvas(this.editorComposite, 0);
        this.lws = new LightweightSystem(this.canvas){

            public void paint(GC gc) {
                Rectangle bounds = StandardDrawingEditor.this.scrollComposite.getClientArea();
                Point origin = StandardDrawingEditor.this.scrollComposite.getOrigin();
                bounds.x += origin.x;
                bounds.y += origin.y;
                gc.setClipping(bounds);
                super.paint(gc);
            }
        };
        this.scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                Point p = StandardDrawingEditor.this.scrollComposite.getOrigin();
                StandardDrawingEditor.this.setMinVisibleArea(-1, -1, false);
                StandardDrawingEditor.this.scrollComposite.setOrigin(p);
                StandardDrawingEditor.this.setScrollIncrements();
            }
        });
        this.scrollFormData = new FormData();
        this.scrollFormData.top = new FormAttachment(0, 5);
        this.scrollFormData.left = new FormAttachment((Control)this.paletteComposite, 0, 131072);
        this.scrollFormData.right = new FormAttachment(100, 0);
        this.scrollFormData.bottom = new FormAttachment((Control)this.zoomComposite, 0);
        this.zoomFormData = new FormData();
        this.zoomFormData.left = new FormAttachment((Control)this.scrollComposite, 0, 16384);
        this.zoomFormData.right = new FormAttachment((Control)this.scrollComposite, 0, 131072);
        this.zoomFormData.bottom = new FormAttachment((Control)this.statusBar, -5);
        this.propFormData = new FormData();
        this.propFormData.left = new FormAttachment(0, 0);
        this.propFormData.right = new FormAttachment(100, 0);
        switch (this.propertiesPaneLocation) {
            case 1024: {
                this.zoomFormData.bottom = new FormAttachment((Control)this.propertiesComposite, -5);
                this.propFormData.left = new FormAttachment(0, 0);
                this.propFormData.right = new FormAttachment(100, 0);
                this.propFormData.bottom = new FormAttachment((Control)this.statusBar, -5);
                break;
            }
            case 128: {
                this.scrollFormData.top = new FormAttachment((Control)this.propertiesComposite, 5);
                this.propFormData.bottom = new FormAttachment(0, this.propertiesSize);
                break;
            }
            case 16384: {
                this.scrollFormData.left = new FormAttachment((Control)this.propertiesComposite, 5);
                this.propFormData.right = new FormAttachment(0, this.propertiesSize);
                this.propFormData.top = new FormAttachment(0, 5);
                this.propFormData.bottom = new FormAttachment((Control)this.statusBar, -5);
                break;
            }
            case 131072: {
                this.scrollFormData.right = new FormAttachment((Control)this.propertiesComposite, -5);
                this.propFormData.left = new FormAttachment(100, -1 * this.propertiesSize);
                this.propFormData.top = new FormAttachment(0, 5);
                this.propFormData.bottom = new FormAttachment((Control)this.statusBar, -5);
            }
        }
        this.scrollComposite.setLayoutData((Object)this.scrollFormData);
        this.propertiesComposite.setLayoutData((Object)this.propFormData);
        this.zoomComposite.setLayoutData((Object)this.zoomFormData);
        FormData paletteData = new FormData();
        paletteData.left = new FormAttachment(0, 2);
        paletteData.right = new FormAttachment(0, paletteSize);
        paletteData.top = new FormAttachment(0, 5);
        paletteData.bottom = new FormAttachment((Control)this.zoomComposite, -5);
        this.paletteComposite.setLayoutData(paletteData);
    }

    protected void setZoomFromUserInput(String userInput) {
        Matcher zoomMatcher = ZOOM_VALUE_PATTERN.matcher(userInput);
        if (zoomMatcher.matches()) {
            try {
                double newZoom = Double.parseDouble(zoomMatcher.group(1)) / 100.0;
                if (newZoom < 0.1) {
                    newZoom = 0.1;
                } else if (newZoom > 5.0) {
                    newZoom = 5.0;
                }
                this.zoomable.performZoom(newZoom);
            }
            catch (NumberFormatException e) {
                throw new RcvrUIException("Number format mismatch in zoom value.");
            }
        }
    }

    public abstract Rectangle getContentSize();

    protected void forwardCapturedEvent(int eventType, int button, int x, int y, int state) {
    }

    public void forwardCanvasEvents() {
        this.canvas.addMouseListener((MouseListener)this.eventForwarder);
        this.canvas.addMouseMoveListener((MouseMoveListener)this.eventForwarder);
    }

    public void stopForwardingCanvasEvents() {
        this.canvas.removeMouseListener((MouseListener)this.eventForwarder);
        this.canvas.removeMouseMoveListener((MouseMoveListener)this.eventForwarder);
    }

    public void setLayoutData(Object data) {
        this.bodyComposite.setLayoutData(data);
    }

    public void addScrollControlListener(ControlListener listener) {
        this.scrollComposite.addControlListener(listener);
    }

    public void addEditorControlListener(ControlListener listener) {
        this.editorComposite.addControlListener(listener);
    }

    public LightweightSystem getLWS() {
        return this.lws;
    }

    public Canvas getSWTEditorSubstrate() {
        return this.canvas;
    }

    public Composite getSWTBodyComposite() {
        return this.bodyComposite;
    }

    public Composite getSWTPropertiesComposite() {
        return this.propertiesComposite;
    }

    public Composite getSWTZoomComposite() {
        return this.zoomComposite;
    }

    public Composite getSWTPaletteComposite() {
        return this.paletteComposite;
    }

    public void setStatusMessage(String message) {
        this.statusBar.setStatusMessage(message);
    }

    public void setStatusMessage(String message, int duration) {
        this.statusBar.setStatusMessage(message, duration);
    }

    public void setMinVisibleArea(int width, int height, boolean growOnly) {
        if (this.resizingEditor) {
            return;
        }
        this.resizingEditor = true;
        Rectangle bounds = this.getContentSize();
        if (width < bounds.width) {
            width = bounds.width;
        }
        if (height < bounds.height) {
            height = bounds.height;
        }
        bounds = this.scrollComposite.getClientArea();
        if (width < bounds.width) {
            width = bounds.width;
        }
        if (height < bounds.height) {
            height = bounds.height;
        }
        if (growOnly) {
            bounds = this.editorComposite.getClientArea();
            if (width < bounds.width) {
                width = bounds.width;
            }
            if (height < bounds.height) {
                height = bounds.height;
            }
        }
        this.editorComposite.setSize(width, height);
        this.resizingEditor = false;
    }

    public Rectangle getVisibleBounds() {
        Point origin = this.scrollComposite.getOrigin();
        Point extent = this.scrollComposite.getSize();
        int verticalBarWidth = this.scrollComposite.getVerticalBar().getSize().x;
        int horizontalBarHeight = this.scrollComposite.getHorizontalBar().getSize().y;
        return new Rectangle(origin.x, origin.y, extent.x - verticalBarWidth, extent.y - horizontalBarHeight);
    }

    public void setScrollOrigin(int x, int y) {
        this.scrollComposite.setOrigin(x, y);
    }

    public void ensurePointIsVisible(int deltaX, int deltaY, int eventX, int eventY) {
        Point visibleOrigin = this.scrollComposite.getOrigin();
        this.setMinVisibleArea(eventX + deltaX, eventY + deltaY, true);
        this.scrollComposite.setOrigin(visibleOrigin.x + deltaX, visibleOrigin.y + deltaY);
    }

    public boolean movePointNearEdge(int eventX, int eventY, Point dragDelta) {
        Rectangle clientArea = this.scrollComposite.getClientArea();
        Point origin = this.scrollComposite.getOrigin();
        int relativeX = eventX - origin.x;
        int relativeY = eventY - origin.y;
        boolean xIsOutside = false;
        boolean yIsOutside = false;
        if (relativeX < 0) {
            dragDelta.x = 0;
            xIsOutside = true;
        } else if (relativeX < 5) {
            dragDelta.x = -10;
        } else if (relativeX < 10) {
            dragDelta.x = -5;
        } else if (relativeX > clientArea.width) {
            dragDelta.x = 0;
            xIsOutside = true;
        } else {
            dragDelta.x = relativeX > clientArea.width - 5 ? 10 : (relativeX > clientArea.width - 10 ? 5 : 0);
        }
        if (relativeY < 0) {
            dragDelta.y = 0;
            yIsOutside = true;
        } else if (relativeY < 5) {
            dragDelta.y = -10;
        } else if (relativeY < 10) {
            dragDelta.y = -5;
        } else if (relativeY > clientArea.height) {
            dragDelta.y = 0;
            yIsOutside = true;
        } else {
            dragDelta.y = relativeY > clientArea.height - 5 ? 10 : (relativeY > clientArea.height - 10 ? 5 : 0);
        }
        this.ensurePointIsVisible(dragDelta.x, dragDelta.y, eventX, eventY);
        return xIsOutside || yIsOutside;
    }

    public void captureMouseEvents(boolean capture) {
        if (this.capturingEvents != capture) {
            this.capturingEvents = capture;
            if (!capture) {
                this.stopForwardingCanvasEvents();
            }
        }
    }

    public void dispose() {
    }

    protected void setZoomSetting(double zoom) {
        this.zoomCombo.setText(NumberFormat.getInstance().format(zoom * 100.0) + " " + L10N.get("SDE.%", "%"));
    }

    protected void setScrollIncrements() {
        Point scrollSize = this.scrollComposite.getSize();
        Point editorSize = this.editorComposite.getSize();
        if (scrollSize.x != 0 && scrollSize.y != 0) {
            ScrollBar horizontal = this.scrollComposite.getHorizontalBar();
            ScrollBar vertical = this.scrollComposite.getVerticalBar();
            horizontal.setIncrement(editorSize.x * 10 / scrollSize.x);
            vertical.setIncrement(editorSize.y * 10 / scrollSize.y);
            horizontal.setPageIncrement(PrecisionUtilities.ceiling((double)scrollSize.x * 0.75));
            vertical.setPageIncrement(PrecisionUtilities.ceiling((double)scrollSize.y * 0.75));
        }
    }

    public FormData getPropFormData() {
        return this.propFormData;
    }

    public FormData getScrollFormData() {
        return this.scrollFormData;
    }

    public FormData getZoomFormData() {
        return this.zoomFormData;
    }

    protected class CapturedEventForwarder
    implements MouseListener,
    MouseMoveListener {
        protected boolean mouseIsDown = true;

        protected CapturedEventForwarder() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            StandardDrawingEditor.this.forwardCapturedEvent(2, e.button, e.x, e.y, e.stateMask);
        }

        public void mouseDown(MouseEvent e) {
            this.mouseIsDown = true;
            StandardDrawingEditor.this.forwardCapturedEvent(0, e.button, e.x, e.y, e.stateMask);
        }

        public void mouseUp(MouseEvent e) {
            this.mouseIsDown = false;
            StandardDrawingEditor.this.forwardCapturedEvent(1, e.button, e.x, e.y, e.stateMask);
        }

        public void mouseMove(MouseEvent e) {
            StandardDrawingEditor.this.forwardCapturedEvent(4, e.button, e.x, e.y, e.stateMask);
        }
    }
}

