/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import java.util.Iterator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ScalableGraphicalFigure
extends Figure {
    protected double scale = 1.0;

    public Rectangle getChildrenUtilizedAreaUnscaled() {
        Rectangle r = null;
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            IFigure fi = (IFigure)iter.next();
            if (r == null) {
                r = new Rectangle(fi.getBounds());
                continue;
            }
            r.union(fi.getBounds());
        }
        return r == null ? new Rectangle(0, 0, 0, 0) : r;
    }

    public Rectangle getChildrenUtilizedAreaScaled() {
        Rectangle r = this.getChildrenUtilizedAreaUnscaled();
        r.x = (int)((double)r.x * this.scale);
        r.y = (int)((double)r.y * this.scale);
        r.width = (int)((double)r.width * this.scale);
        r.height = (int)((double)r.height * this.scale);
        return r;
    }

    public Rectangle getClientArea(Rectangle rect) {
        super.getClientArea(rect);
        rect.width = (int)((double)rect.width / this.scale);
        rect.height = (int)((double)rect.height / this.scale);
        rect.x = (int)((double)rect.x / this.scale);
        rect.y = (int)((double)rect.y / this.scale);
        return rect;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint, hHint);
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale(this.scale).expand(w, h);
    }

    public double getScale() {
        return this.scale;
    }

    public boolean isCoordinateSystem() {
        return true;
    }

    public void setScale(double newZoom) {
        if (this.scale == newZoom) {
            return;
        }
        this.scale = newZoom;
        this.revalidate();
        this.repaint();
    }

    public void translateFromParent(Translatable t) {
        t.performScale(1.0 / this.scale);
    }

    public void translateToParent(Translatable t) {
        t.performScale(this.scale);
    }
}

