/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.view.AView;
import edu.cmu.cs.hcii.cogtool.view.IScalableInteractiveFigure;
import edu.cmu.cs.hcii.cogtool.view.ScalableGraphicalFigure;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class ScalableFrameFigure
extends ScalableGraphicalFigure
implements IScalableInteractiveFigure {
    protected IFigure tempFigure = new Figure();
    protected Color figureColor = new Color(null, GraphicsUtil.getRGBFromColor(GraphicsUtil.defaultWidgetColor));
    protected boolean outline;

    public ScalableFrameFigure(int color) {
        this.setWidgetColor(color);
    }

    public void setWidgetColor(int color) {
        this.figureColor.dispose();
        this.figureColor = new Color(null, GraphicsUtil.getRGBFromColor(color));
    }

    public void handleMouseMoved(MouseEvent evt) {
        this.getParent().handleMouseMoved(evt);
    }

    public void handleMousePressed(MouseEvent evt) {
        this.getParent().handleMousePressed(evt);
    }

    public void handleMouseReleased(MouseEvent evt) {
        this.getParent().handleMouseReleased(evt);
    }

    public void handleMouseEntered(MouseEvent evt) {
        this.getParent().handleMouseEntered(evt);
    }

    public void handleMouseDragged(MouseEvent evt) {
        this.getParent().handleMouseDragged(evt);
    }

    public void setTemporaryFigure(int x, int y, int width, int height) {
        this.setTemporaryFigure(new Rectangle(x, y, width, height));
    }

    public void setTemporaryFigure(Rectangle r) {
        if (r == null) {
            this.stopDrawingTemporaryFigure();
        }
        this.tempFigure.setBounds(r);
        this.repaint();
    }

    public void stopDrawingTemporaryFigure() {
        this.setTemporaryFigure(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTempFigure(Graphics graphics) {
        if (this.tempFigure.getBounds().width > 0 && this.tempFigure.getBounds().height > 0) {
            graphics.pushState();
            try {
                if (this.outline) {
                    graphics.setForegroundColor(this.figureColor);
                    graphics.setLineWidth(2);
                    graphics.drawRectangle(this.tempFigure.getBounds());
                } else {
                    graphics.setBackgroundColor(this.figureColor);
                    graphics.setAlpha(175);
                    graphics.fillRectangle(this.tempFigure.getBounds());
                }
            }
            finally {
                graphics.popState();
            }
        }
    }

    protected void paintClientArea(Graphics graphics) {
        if (AView.isDrawingOK()) {
            if (this.getScale() == 1.0) {
                super.paintClientArea(graphics);
                this.paintTempFigure(graphics);
            } else {
                ScaledGraphics g = new ScaledGraphics(graphics);
                if (this.getBorder() != null && !this.getBorder().isOpaque()) {
                    g.clipRect(this.getBounds().getCropped(this.getInsets()));
                }
                g.scale(this.getScale());
                g.pushState();
                this.paintChildren((Graphics)g);
                this.paintTempFigure((Graphics)g);
                g.dispose();
            }
        }
    }

    public void dispose() {
        this.figureColor.dispose();
    }

    public void setOutlineDrawing(boolean line) {
        this.outline = line;
    }

    protected boolean useLocalCoordinates() {
        return true;
    }
}

