/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.view.SWTList;
import java.security.InvalidParameterException;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SWTListMultiColumn
extends SWTList {
    protected int numCols;

    public SWTListMultiColumn(Table t, String[] colTitles, MultiColRowPropertyDisplay cb) {
        super(t, cb);
        this.table.setHeaderVisible(true);
        for (int i = 0; i < colTitles.length; ++i) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(colTitles[i]);
            column.pack();
        }
        this.numCols = colTitles.length;
    }

    protected void packCols() {
        for (int i = 0; i < this.numCols; ++i) {
            TableColumn column = this.table.getColumn(i);
            column.pack();
        }
    }

    protected void setRowContents(TableItem item, Object data) {
        String[] s = ((MultiColRowPropertyDisplay)this.callBack).getMultiColumnText(data);
        int slength = s.length;
        if (slength != this.numCols) {
            throw new InvalidParameterException("Trying to set wrong number of cell strings for columns");
        }
        for (int i = 0; i < s.length; ++i) {
            item.setText(i, s[i]);
        }
        item.setData(data);
        Color c = null;
        if (this.callBack != null) {
            c = ((MultiColRowPropertyDisplay)this.callBack).getRowColor(data);
        }
        if (c != null) {
            item.setBackground(c);
        } else {
            item.setBackground(null);
        }
    }

    public void setListContents(List items) {
        super.setListContents(items);
        this.packCols();
    }

    public void addListItem(Object data, int index) {
        super.addListItem(data, index);
        this.packCols();
    }

    public static interface MultiColRowPropertyDisplay
    extends SWTList.SingleColRowPropertyDisplay {
        public Color getRowColor(Object var1);

        public String[] getMultiColumnText(Object var1);
    }
}

