/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SWTList {
    protected Table table;
    protected HashMap itemMap;
    protected SingleColRowPropertyDisplay callBack;

    public SWTList(Table t, SingleColRowPropertyDisplay cb) {
        this.table = t;
        this.itemMap = new HashMap();
        this.callBack = cb;
    }

    protected void setRowContents(TableItem item, Object data) {
        item.setText(0, this.callBack.getColumnText(data));
        item.setData(data);
    }

    public void setListContents(List items) {
        this.itemMap.clear();
        Iterator iter = items.iterator();
        TableItem[] tableItems = this.table.getItems();
        int tableItemIndex = 0;
        while (iter.hasNext()) {
            Object data = iter.next();
            TableItem item = null;
            if (tableItemIndex < tableItems.length) {
                item = tableItems[tableItemIndex];
                this.setRowContents(item, data);
                ++tableItemIndex;
            } else {
                item = new TableItem(this.table, 0);
                this.setRowContents(item, data);
            }
            this.itemMap.put(data, item);
        }
        while (tableItemIndex < tableItems.length) {
            tableItems[tableItemIndex++].dispose();
        }
    }

    private void clearTable() {
        TableItem[] items = this.table.getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
    }

    public void clearListContents() {
        this.clearTable();
        this.itemMap.clear();
    }

    public void setListItemHighlighted(int listItemIndex) {
        TableItem item = this.table.getItem(listItemIndex);
        this.setTableItemSelected(item);
    }

    protected void setTableItemSelected(TableItem item) {
        if (item == null) {
            throw new NoSuchElementException("Desired Item does not exsist in the table");
        }
        TableItem[] itemArray = new TableItem[]{item};
        this.table.setSelection(itemArray);
    }

    public void setListItemHighlighted(Object selectItem) {
        TableItem item = (TableItem)this.itemMap.get(selectItem);
        this.setTableItemSelected(item);
    }

    public void deselectAll() {
        this.table.deselectAll();
    }

    public void setListItemsHighlighted(Object[] selectItems) {
        TableItem[] items = new TableItem[selectItems.length];
        for (int i = 0; i < selectItems.length; ++i) {
            TableItem item = (TableItem)this.itemMap.get(selectItems[i]);
            if (item == null) {
                throw new InvalidParameterException("Attempted to select an object which is not in the table.");
            }
            items[i] = item;
        }
        this.table.setSelection(items);
    }

    public void addListItem(Object newListItem, int index) {
        if (newListItem == null) {
            throw new InvalidParameterException("Can not add Null to the list");
        }
        TableItem item = new TableItem(this.table, 0, index);
        this.setRowContents(item, newListItem);
        this.itemMap.put(newListItem, item);
    }

    public void removeListItem(int removeItemIndex) {
        TableItem item = this.table.getItem(removeItemIndex);
        if (item == null) {
            throw new NoSuchElementException("No item with index " + removeItemIndex + " exsists in the table");
        }
        this.itemMap.remove(item.getData());
        item.dispose();
    }

    public void addListener(int eventType, Listener l) {
        this.table.addListener(eventType, l);
    }

    public void removeListener(int eventType, Listener l) {
        this.table.removeListener(eventType, l);
    }

    public void addSelectionListener(SelectionListener l) {
        this.table.addSelectionListener(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.table.removeSelectionListener(l);
    }

    public TableItem[] getSelectionObject() {
        return this.table.getSelection();
    }

    void dispose() {
        this.clearListContents();
    }

    public Map getItemList() {
        return this.itemMap;
    }

    public static interface SingleColRowPropertyDisplay {
        public String getColumnText(Object var1);
    }
}

