/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.view.AView;
import edu.cmu.cs.hcii.cogtool.view.IScriptView;
import edu.cmu.cs.hcii.cogtool.view.InteractionDrawingEditor;
import edu.cmu.cs.hcii.cogtool.view.MenuFactory;
import java.util.Arrays;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class SEDefaultView
extends AView
implements IScriptView {
    protected static final String checkboxLabel = L10N.get("SE.HandStartsOnKeyboard", "Hand starts on Keyboard");
    protected static final int touchKeyboardDeviceSet = DeviceType.buildDeviceSet(Arrays.asList(DeviceType.Touchscreen, DeviceType.Keyboard));
    protected static final int mouseKeyboardDeviceSet = DeviceType.buildDeviceSet(Arrays.asList(DeviceType.Mouse, DeviceType.Keyboard));
    protected static final int keyboardDeviceSet = DeviceType.buildDeviceSet(Arrays.asList(DeviceType.Keyboard));
    protected InteractionDrawingEditor editor;
    protected int designDeviceTypes;
    protected Button handOnKeyboardToStart = null;

    protected static Shell createShell(Rectangle loc) {
        return SEDefaultView.createShell(loc, 700, 600, (Layout)new FillLayout());
    }

    public SEDefaultView(int deviceTypes, ListenerIdentifierMap lIDMap, ListenerIdentifier.ILIDTransmuter transformer, MenuFactory.IWindowMenuData menuData, Rectangle loc) {
        super(SEDefaultView.createShell(loc), lIDMap, transformer, menuData);
        this.designDeviceTypes = deviceTypes;
    }

    protected void addHandOnKeyboardToStart(Composite container) {
        if (DeviceType.contains(this.designDeviceTypes, mouseKeyboardDeviceSet) || DeviceType.contains(this.designDeviceTypes, touchKeyboardDeviceSet)) {
            this.handOnKeyboardToStart = new Button(container, 32);
            this.handOnKeyboardToStart.setText(checkboxLabel);
        }
    }

    public InteractionDrawingEditor getEditor() {
        return this.editor;
    }

    public boolean getHandStartsOnMouse() {
        if (this.handOnKeyboardToStart != null) {
            return !this.handOnKeyboardToStart.getSelection();
        }
        return !DeviceType.intersects(this.designDeviceTypes, keyboardDeviceSet);
    }

    public void setHandStartsOnMouse(boolean handOnMouse) {
        if (this.handOnKeyboardToStart != null) {
            this.handOnKeyboardToStart.setSelection(!handOnMouse);
        }
    }

    public void dispose() {
        this.editor.dispose();
        super.dispose();
    }

    public void setStatusMessage(String message) {
        this.editor.setStatusMessage(message);
    }

    public void setStatusMessage(String message, int duration) {
        this.editor.setStatusMessage(message, duration);
    }
}

