/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class PersistenceView {
    static final String[] fileExts = new String[]{"*.cgt", "*.*"};
    static final String[] extNames = new String[]{"CogTool Projects (*.cgt)", "All Files (*.*)"};
    static String lastOpenPath;
    static String lastSavePath;
    protected FileDialog openDialog;
    protected FileDialog saveDialog;
    protected MessageBox mBox;
    protected MessageBox replaceBox;

    public PersistenceView(Shell shell) {
        this.openDialog = new FileDialog(shell, 69634);
        this.saveDialog = new FileDialog(shell, 40960);
        this.openDialog.setFilterExtensions(fileExts);
        this.openDialog.setFilterNames(extNames);
        this.saveDialog.setFilterExtensions(fileExts);
        this.saveDialog.setFilterNames(extNames);
        this.mBox = new MessageBox(shell, 32801);
        this.replaceBox = new MessageBox(shell, 33220);
        this.mBox.setText(L10N.get("PV.FileErrorTitle", "File Error"));
        this.replaceBox.setText(L10N.get("PV.ReplaceFile?", "Replace File?"));
    }

    public File[] selectFileSources() {
        File[] retval;
        String result;
        if (lastOpenPath != null) {
            this.openDialog.setFilterPath(lastOpenPath);
        }
        if ((result = this.openDialog.open()) == null) {
            retval = null;
        }
        String pathname = this.openDialog.getFilterPath();
        File path = new File(pathname);
        String[] sel = this.openDialog.getFileNames();
        ArrayList<File> files = new ArrayList<File>();
        lastOpenPath = pathname;
        String msg = L10N.get("PV.CannotReadFiles", "Cannot read file(s):");
        for (int i = 0; i < sel.length; ++i) {
            File file = new File(path, sel[i]);
            if (file.canRead()) {
                files.add(file);
                continue;
            }
            msg = msg + '\n' + file.getAbsolutePath();
        }
        if (msg.length() > 22) {
            this.warning(msg);
        }
        retval = files.toArray(new File[files.size()]);
        return retval;
    }

    public File selectFileDest(String fileName, String fileExtension) {
        if (lastSavePath != null) {
            this.saveDialog.setFilterPath(lastSavePath);
        } else if (lastOpenPath != null) {
            this.saveDialog.setFilterPath(lastOpenPath);
        }
        this.saveDialog.setFileName(fileName + fileExtension);
        String result = this.saveDialog.open();
        if (result == null) {
            return null;
        }
        String pathname = this.saveDialog.getFilterPath();
        File path = new File(pathname);
        String name = this.saveDialog.getFileName();
        File file = new File(path, name);
        lastSavePath = pathname;
        if (file.exists() && OSUtils.WINDOWS) {
            int choice = this.shouldReplaceFile(file);
            if (choice == 128) {
                return this.selectFileDest(fileName, fileExtension);
            }
            if (choice == 256) {
                return null;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.warning(L10N.get("PV.CannotCreateFile", "Cannot create file") + ":\n" + file.getAbsolutePath());
                return this.selectFileDest(fileName, fileExtension);
            }
        }
        if (!file.canWrite()) {
            this.warning(L10N.get("PV.CannotWriteFile", "Cannot write to file") + "\n" + file.getAbsolutePath());
            return this.selectFileDest(fileName, fileExtension);
        }
        return file;
    }

    protected void warning(String msg) {
        this.mBox.setMessage(msg);
        this.mBox.open();
    }

    protected int shouldReplaceFile(File file) {
        this.replaceBox.setMessage(L10N.get("PV.FileExistsReplace?", "File exists.  Replace file?") + "\n" + file.getAbsolutePath());
        return this.replaceBox.open();
    }
}

