/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class Palette
extends Composite {
    protected static final Color SELECTED_BKG = WindowUtil.globalDisplay.getSystemColor(2);
    protected static Color UNSELECTED_BKG = WindowUtil.globalDisplay.getSystemColor(29);

    public Palette(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
    }

    public Button createPaletteButton(Image img, Control lastButton, Composite parent, Object buttonData, ButtonListener buttonListener, String toolTipText) {
        buttonListener.setPalette(this);
        int style = OSUtils.MACOSX ? 0x800002 : 2;
        Composite buttonBackground = new Composite(parent, 0);
        buttonBackground.setLayout((Layout)new FormLayout());
        Button b = new Button(buttonBackground, style);
        buttonBackground.setData((Object)b);
        if (img != null) {
            b.setImage(img);
        }
        FormData data = new FormData();
        if (lastButton == null) {
            b.setSelection(true);
            buttonBackground.setBackground(SELECTED_BKG);
            data.top = new FormAttachment(0, 1);
            data.bottom = new FormAttachment(0, 26);
        } else {
            Composite lastButtonBkg = lastButton.getParent();
            data.top = new FormAttachment((Control)lastButtonBkg, 0, 1024);
            data.bottom = new FormAttachment((Control)lastButtonBkg, 25, 1024);
        }
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(0, 26);
        buttonBackground.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.bottom = new FormAttachment(100, -1);
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -1);
        b.setLayoutData((Object)data);
        b.setData(buttonData);
        b.addSelectionListener((SelectionListener)buttonListener);
        b.setToolTipText(toolTipText);
        return b;
    }

    public static class ButtonListener
    extends SelectionAdapter {
        protected Palette parent;

        public void widgetSelected(SelectionEvent evt) {
            Button selected = (Button)evt.getSource();
            if (selected.getSelection()) {
                Control[] children = this.parent.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (!(children[i] instanceof Composite)) continue;
                    Composite bkg = (Composite)children[i];
                    Button b = (Button)bkg.getData();
                    if (b != selected) {
                        b.setSelection(false);
                        bkg.setBackground(UNSELECTED_BKG);
                        continue;
                    }
                    bkg.setBackground(SELECTED_BKG);
                }
            } else {
                selected.setSelection(true);
            }
        }

        public void setPalette(Palette palette) {
            this.parent = palette;
        }
    }
}

