/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.util.Alerter;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.PERTPanel;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class PERTScrollBar
extends PERTPanel {
    protected static int SCROLLING_LEFT = 1;
    protected static int SCROLLING_RIGHT = 2;
    public static double SCROLL_INCREMENT = 0.2;
    public static int SCROLL_REPEAT_DELAY = 300;
    public static int SCROLL_REPEAT_INCREMENT = 100;
    protected Alerter alerter;
    protected double start = 0.0;
    protected double end;
    protected Button leftButton;
    protected Button rightButton;
    protected Runnable scrollTimer;
    protected int scrollDirection = SCROLLING_LEFT;
    protected Cursor openHandCursor;
    protected Cursor closedHandCursor;
    protected ScrollBox scrollBox = new ScrollBox(this);

    public PERTScrollBar(Composite parent, List steps, List resourceLabels) {
        super(parent, steps, resourceLabels, 10, 5, 5, 15, 15);
        this.end = this.totalTime / 2.0;
        this.alerter = new Alerter();
        Iterator conIterator = this.connections.iterator();
        while (conIterator.hasNext()) {
            PolylineConnection con = (PolylineConnection)conIterator.next();
            con.setTargetDecoration(null);
        }
        this.openHandCursor = WindowUtil.getOpenHandCursor();
        this.closedHandCursor = WindowUtil.getClosedHandCursor();
        final Runnable scrollTimer = new Runnable(){

            public void run() {
                if (PERTScrollBar.this.scrollDirection == SCROLLING_LEFT) {
                    PERTScrollBar.this.scrollLeft(SCROLL_INCREMENT / 5.0);
                    PERTScrollBar.this.getDisplay().timerExec(SCROLL_REPEAT_INCREMENT, (Runnable)this);
                } else {
                    PERTScrollBar.this.scrollRight(SCROLL_INCREMENT / 5.0);
                    PERTScrollBar.this.getDisplay().timerExec(SCROLL_REPEAT_INCREMENT, (Runnable)this);
                }
            }
        };
        this.setLayout((Layout)new FormLayout());
        this.leftButton = new Button((Composite)this, 16388);
        this.rightButton = new Button((Composite)this, 8519684);
        this.leftButton.setBackground(this.getDisplay().getSystemColor(1));
        this.rightButton.setBackground(this.getDisplay().getSystemColor(1));
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000003) {
                    PERTScrollBar.this.scrollLeft();
                    PERTScrollBar.this.scrollDirection = SCROLLING_LEFT;
                    PERTScrollBar.this.getDisplay().timerExec(SCROLL_REPEAT_DELAY, scrollTimer);
                } else if (e.keyCode == 0x1000004) {
                    PERTScrollBar.this.scrollRight();
                    PERTScrollBar.this.scrollDirection = SCROLLING_RIGHT;
                    PERTScrollBar.this.getDisplay().timerExec(SCROLL_REPEAT_DELAY, scrollTimer);
                }
            }

            public void keyReleased(KeyEvent e) {
                PERTScrollBar.this.getDisplay().timerExec(-1, scrollTimer);
            }
        });
        this.leftButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                PERTScrollBar.this.scrollLeft();
                PERTScrollBar.this.scrollDirection = SCROLLING_LEFT;
                PERTScrollBar.this.getDisplay().timerExec(SCROLL_REPEAT_DELAY, scrollTimer);
            }

            public void mouseUp(MouseEvent e) {
                PERTScrollBar.this.getDisplay().timerExec(-1, scrollTimer);
            }
        });
        this.rightButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                PERTScrollBar.this.scrollRight();
                PERTScrollBar.this.scrollDirection = SCROLLING_RIGHT;
                PERTScrollBar.this.getDisplay().timerExec(SCROLL_REPEAT_DELAY, scrollTimer);
            }

            public void mouseUp(MouseEvent e) {
                PERTScrollBar.this.getDisplay().timerExec(-1, scrollTimer);
            }
        });
        FormData leftButtonFD = new FormData();
        leftButtonFD.left = new FormAttachment(0, 0);
        leftButtonFD.right = new FormAttachment(0, 15);
        leftButtonFD.top = new FormAttachment(0, 0);
        leftButtonFD.bottom = new FormAttachment(100, 0);
        FormData rightButtonFD = new FormData();
        rightButtonFD.left = new FormAttachment(100, -15);
        rightButtonFD.right = new FormAttachment(100, 0);
        rightButtonFD.top = new FormAttachment(0, 0);
        rightButtonFD.bottom = new FormAttachment(100, 0);
        this.leftButton.setLayoutData((Object)leftButtonFD);
        this.rightButton.setLayoutData((Object)rightButtonFD);
        this.contents.add((IFigure)this.scrollBox);
    }

    public void scrollLeft() {
        this.scrollLeft(SCROLL_INCREMENT);
    }

    public void scrollLeft(double percent) {
        double delta = percent * (this.end - this.start);
        this.changeRegion(this.start - delta, this.end - delta);
    }

    public void scrollRight() {
        this.scrollRight(SCROLL_INCREMENT);
    }

    public void scrollRight(double percent) {
        double delta = percent * (this.end - this.start);
        this.changeRegion(this.start + delta, this.end + delta);
    }

    public void changeRegion(double newStart, double newEnd) {
        this.changeRegion(newStart, newEnd, true);
    }

    public void changeRegion(double newStart, double newEnd, boolean updateView) {
        double myStart = Math.min(newStart, newEnd);
        double myEnd = Math.max(newStart, newEnd);
        double distance = myEnd - myStart;
        if (distance > this.totalTime) {
            myStart = 0.0;
            myEnd = this.totalTime;
        } else if (myStart < 0.0) {
            myStart = 0.0;
            myEnd = distance;
        } else if (myEnd > this.totalTime) {
            myEnd = this.totalTime;
            myStart = this.totalTime - distance;
        }
        this.start = myStart;
        this.end = myEnd;
        this.scrollBox.setStartEnd(myStart, myEnd);
        this.lws.getUpdateManager().performUpdate();
        if (updateView) {
            this.alerter.raiseAlert(new ScrollEvent(this, this.start, this.end));
        }
    }

    public void resizeVisualization(Event e) {
        this.scrollBox.setBounds(this.contents.getBounds());
        this.scrollBox.setStartEnd(this.start, this.end);
        super.resizeVisualization(e);
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public void addHandler(Object observer, Class eventClass, IAlertHandler handler) {
        this.alerter.addHandler(observer, eventClass, handler);
    }

    public void dispose() {
        super.dispose();
        this.openHandCursor.dispose();
        this.closedHandCursor.dispose();
    }

    public Cursor getOpenHandCursor() {
        return this.openHandCursor;
    }

    public Cursor getClosedHandCursor() {
        return this.closedHandCursor;
    }

    public static class ScrollEvent
    extends EventObject {
        public double start;
        public double end;

        public ScrollEvent(PERTScrollBar source, double start, double end) {
            super(source);
            this.start = start;
            this.end = end;
        }
    }

    private static class ScrollBox
    extends Figure {
        private int boxStart;
        private int boxEnd;
        private int boxHeight;
        private PERTScrollBar parent;

        public ScrollBox(PERTScrollBar myParent) {
            this.parent = myParent;
        }

        public void setStartEnd(double timeStart, double timeEnd) {
            int visWidth = this.parent.getVisualizationWidth();
            this.boxStart = this.parent.marginLeft + (int)(timeStart / this.parent.totalTime * (double)visWidth);
            this.boxEnd = this.parent.marginLeft + (int)(timeEnd / this.parent.totalTime * (double)visWidth);
            this.boxHeight = this.parent.getClientArea().height - 1;
            this.setBounds(new Rectangle(this.boxStart, 0, this.boxEnd - this.boxStart + 1, this.boxHeight + 1));
        }

        public void paint(Graphics g) {
            g.pushState();
            g.setForegroundColor(ColorConstants.red);
            g.setBackgroundColor(ColorConstants.red);
            g.setAlpha(50);
            g.fillRectangle(this.boxStart, 0, this.boxEnd - this.boxStart, this.boxHeight);
            g.setAlpha(150);
            g.fillRectangle(this.boxStart, 0, 5, this.boxHeight);
            g.fillRectangle(this.boxEnd - 4, 0, 5, this.boxHeight);
            g.drawRectangle(this.boxStart, 0, this.boxEnd - this.boxStart, this.parent.getClientArea().height - 1);
            g.setForegroundColor(ColorConstants.white);
            g.setBackgroundColor(ColorConstants.white);
            int knurlingHeight = this.boxHeight / 3;
            g.drawLine(this.boxStart + 1, knurlingHeight, this.boxStart + 1, 2 * knurlingHeight);
            g.drawLine(this.boxStart + 3, knurlingHeight, this.boxStart + 3, 2 * knurlingHeight);
            g.drawLine(this.boxEnd - 1, knurlingHeight, this.boxEnd - 1, 2 * knurlingHeight);
            g.drawLine(this.boxEnd - 3, knurlingHeight, this.boxEnd - 3, 2 * knurlingHeight);
            g.popState();
        }
    }
}

