/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.model.ResultStep;
import edu.cmu.cs.hcii.cogtool.ui.PERTChartSelectionState;
import edu.cmu.cs.hcii.cogtool.uimodel.PERTChartOperatorBar;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.ITimeSliceDisplayable;
import edu.cmu.cs.hcii.cogtool.util.SWTContextMenuUtil;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PERTPanel
extends Canvas
implements ITimeSliceDisplayable {
    protected List bars;
    protected List connections;
    protected LightweightSystem lws;
    protected IFigure contents;
    protected IFigure background;
    protected List selectionBoxes = new ArrayList();
    protected int numRows;
    protected double totalTime;
    protected double displayStartTime = 0.0;
    protected double displayEndTime = 0.0;
    protected int marginTop;
    protected int marginBottom;
    protected int marginLeft;
    protected int marginRight;
    protected int barHeight;
    protected static final Map colorMap = PERTPanel.getColorMap();
    protected static TreeSearch barFilter = new TreeSearch(){

        public boolean accept(IFigure figure) {
            return figure instanceof PERTChartOperatorBar;
        }

        public boolean prune(IFigure figure) {
            return false;
        }
    };

    public PERTPanel(Composite parent, List steps, List resourceLabels, int bHeight) {
        this(parent, steps, resourceLabels, bHeight, 5, 5, 5, 5);
    }

    public PERTPanel(Composite parent, List steps, List resourceLabels, int bHeight, int marginT, int marginB, int marginL, int marginR) {
        super(parent, 0);
        PERTChartOperatorBar bar;
        ResultStep step;
        this.lws = new LightweightSystem((Canvas)this);
        this.contents = new RectangleFigure();
        this.contents.setBackgroundColor(ColorConstants.white);
        this.contents.setForegroundColor(ColorConstants.white);
        ((RectangleFigure)this.contents).setFill(true);
        this.lws.setContents(this.contents);
        this.marginTop = marginT;
        this.marginBottom = marginB;
        this.marginLeft = marginL;
        this.marginRight = marginR;
        this.barHeight = bHeight;
        this.numRows = resourceLabels.size();
        Iterator stepIterator = steps.iterator();
        this.bars = new ArrayList();
        this.connections = new ArrayList();
        this.totalTime = 0.0;
        HashMap<ResultStep, PERTChartOperatorBar> barMap = new HashMap<ResultStep, PERTChartOperatorBar>();
        ArrayList<PERTChartOperatorBar> operators = new ArrayList<PERTChartOperatorBar>();
        while (stepIterator.hasNext()) {
            step = (ResultStep)stepIterator.next();
            bar = new PERTChartOperatorBar(step, resourceLabels, this.barHeight);
            bar.setColorWithMap(colorMap);
            barMap.put(step, bar);
            this.bars.add(bar);
            if (bar.isCascade()) {
                this.contents.add((IFigure)bar);
            } else {
                operators.add(bar);
            }
            this.totalTime = Math.max(this.totalTime, step.startTime + step.duration);
        }
        Iterator opIter = operators.iterator();
        while (opIter.hasNext()) {
            this.contents.add((IFigure)((PERTChartOperatorBar)((Object)opIter.next())));
        }
        stepIterator = steps.iterator();
        while (stepIterator.hasNext()) {
            step = (ResultStep)stepIterator.next();
            bar = (PERTChartOperatorBar)((Object)barMap.get(step));
            Iterator depStepIter = step.getDependencies().iterator();
            while (depStepIter.hasNext()) {
                ResultStep.ResultStepDependency rStepDep = (ResultStep.ResultStepDependency)depStepIter.next();
                PERTChartOperatorBar otherBar = (PERTChartOperatorBar)((Object)barMap.get(rStepDep.dependency));
                PERTChartOperatorBar.PERTStepDependency dep = bar.addDependency(otherBar, rStepDep);
                this.contents.add((IFigure)dep);
                this.connections.add(dep);
            }
        }
        this.displayEndTime = this.totalTime;
        this.displayStartTime = 0.0;
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                PERTPanel.this.resizeVisualization(e);
            }
        });
    }

    public static Map getColorMap() {
        HashMap<String, Integer> colorMap = new HashMap<String, Integer>();
        colorMap.put(ResultStep.FRAME_RESOURCE, new Integer(0x999999));
        colorMap.put(ResultStep.PRODUCTIONS_RESOURCE, new Integer(0x999999));
        colorMap.put(ResultStep.VISION_RESOURCE, new Integer(10637303));
        colorMap.put(ResultStep.VISION_EXEC_RESOURCE, new Integer(4522633));
        colorMap.put(ResultStep.VISION_PREP_RESOURCE, new Integer(10637303));
        colorMap.put(ResultStep.VISION_ENC_RESOURCE, new Integer(14137846));
        colorMap.put(ResultStep.MOTOR_EXEC_RESOURCE, new Integer(0xFF3333));
        colorMap.put(ResultStep.MOTOR_INIT_RESOURCE, new Integer(0xFF6666));
        colorMap.put(ResultStep.MOTOR_PREP_RESOURCE, new Integer(0xFF9999));
        return colorMap;
    }

    public PERTChartOperatorBar findBarAt(int x, int y) {
        return (PERTChartOperatorBar)this.contents.findFigureAt(x, y, barFilter);
    }

    public int getVisualizationWidth() {
        return this.getBounds().width - (this.marginLeft + this.marginRight);
    }

    public int getVisualizationHeight() {
        return this.getBounds().height - (this.marginTop + this.marginBottom);
    }

    public int getTopMargin() {
        return this.marginTop;
    }

    public int getBottomMargin() {
        return this.marginBottom;
    }

    public int getLeftMargin() {
        return this.marginLeft;
    }

    public int getRightMargin() {
        return this.marginRight;
    }

    public void resizeVisualization(Event e) {
        int totalWidth = this.getVisualizationWidth();
        int totalHeight = this.getVisualizationHeight();
        int regionHeight = (totalHeight - 10) / this.numRows;
        Iterator barIterator = this.bars.iterator();
        double displayedDuration = this.displayEndTime - this.displayStartTime;
        if (this.totalTime > 0.0 && displayedDuration > 0.0) {
            while (barIterator.hasNext()) {
                int barH;
                int barY;
                PERTChartOperatorBar bar = (PERTChartOperatorBar)((Object)barIterator.next());
                int barW = (int)(bar.getDuration() / displayedDuration * (double)(totalWidth - 10));
                int barX = this.marginLeft + (int)((bar.getStartTime() - this.displayStartTime) / displayedDuration * (double)(totalWidth - 10));
                if (bar.isCascade()) {
                    int y1 = Math.min(bar.getRow(), bar.getEndRow());
                    int y2 = Math.max(bar.getRow(), bar.getEndRow());
                    barY = this.marginTop + y1 * regionHeight + (int)(0.5 * (double)this.barHeight);
                    barH = (y2 - y1) * regionHeight;
                    if (barW < 1) {
                        barW = 1;
                    }
                } else {
                    barY = this.marginTop + bar.getRow() * regionHeight;
                    barH = this.barHeight;
                    if (barW < 3) {
                        --barX;
                        barW = 3;
                    }
                }
                bar.setBounds(new Rectangle(barX, barY, barW, barH));
            }
        }
        this.lws.getUpdateManager().performUpdate();
    }

    public List getOperatorBarList() {
        return this.bars;
    }

    public double getTotalTime() {
        return this.totalTime;
    }

    public void addMouseHandler(SWTContextMenuUtil.MenuListener mouseState, MouseMoveListener moveListener) {
        if (mouseState != null) {
            this.addMouseListener(mouseState);
        }
        if (moveListener != null) {
            this.addMouseMoveListener(moveListener);
        }
    }

    public void observeSelectionState(PERTChartSelectionState selectionState) {
        IAlertHandler handler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                List selectedSteps = ((PERTChartSelectionState.SelectionChange)alert).selectedSteps;
                Iterator haloIterator = PERTPanel.this.selectionBoxes.iterator();
                SelectionHalo deadHalo = null;
                while (haloIterator.hasNext()) {
                    deadHalo = (SelectionHalo)((Object)haloIterator.next());
                    PERTPanel.this.contents.remove((IFigure)deadHalo);
                    deadHalo.dispose();
                }
                PERTPanel.this.selectionBoxes.clear();
                Iterator barIterator = PERTPanel.this.bars.iterator();
                while (barIterator.hasNext()) {
                    PERTChartOperatorBar bar = (PERTChartOperatorBar)((Object)barIterator.next());
                    if (selectedSteps.contains(bar.getStep())) {
                        bar.setSelected(true);
                        SelectionHalo halo = new SelectionHalo();
                        halo.setTarget(bar);
                        PERTPanel.this.contents.add((IFigure)halo);
                        PERTPanel.this.selectionBoxes.add(halo);
                        continue;
                    }
                    bar.setSelected(false);
                }
                PERTPanel.this.contents.repaint();
            }
        };
        selectionState.addHandler(this, PERTChartSelectionState.SelectionChange.class, handler);
    }

    public void dispose() {
        Iterator pIterator = this.bars.iterator();
        while (pIterator.hasNext()) {
            ((PERTChartOperatorBar)((Object)pIterator.next())).dispose();
        }
        Iterator haloIter = this.selectionBoxes.iterator();
        while (haloIter.hasNext()) {
            ((SelectionHalo)((Object)haloIter.next())).dispose();
        }
        super.dispose();
    }

    public void figureMoved(IFigure arg0) {
    }

    public void displayTimeSlice(double start, double end) {
        this.displayStartTime = start;
        this.displayEndTime = end;
        this.resizeVisualization(null);
    }

    public class SelectionHalo
    extends RectangleFigure {
        public PERTChartOperatorBar target = null;
        public FigureListener targetListener = null;
        public int offset = 0;
        public Color color = new Color(null, GraphicsUtil.getRGBFromColor(52479));

        public SelectionHalo() {
            this.setToolTip((IFigure)new Label(""));
            this.setVisible(true);
            this.targetListener = new FigureListener(this){
                private final /* synthetic */ SelectionHalo this$1;
                {
                    this.this$1 = this$1;
                }

                public void figureMoved(IFigure source) {
                    SelectionHalo.access$000(this.this$1, source);
                }
            };
        }

        private void setBoundsFromFigure(IFigure figure) {
            Rectangle tBounds = figure.getBounds();
            this.offset = 5;
            this.setBounds(new Rectangle(tBounds.x - this.offset, tBounds.y - this.offset, tBounds.width + 2 * this.offset, tBounds.height + 2 * this.offset));
        }

        public PERTChartOperatorBar getTarget() {
            return this.target;
        }

        public void dispose() {
            this.color.dispose();
        }

        public void setTarget(PERTChartOperatorBar bar) {
            if (this.target != null) {
                this.target.removeFigureListener(this.targetListener);
            }
            this.target = bar;
            if (this.target != null) {
                this.setBoundsFromFigure((IFigure)this.target);
                String toolTipText = "Selected Operation";
                try {
                    toolTipText = this.target.getStep().toString();
                }
                catch (Exception ex) {
                    Label targetToolTip = (Label)this.target.getToolTip();
                    toolTipText = targetToolTip != null ? targetToolTip.getText() : "Selected Operation";
                }
                this.setToolTip((IFigure)new Label(toolTipText));
                this.target.addFigureListener(this.targetListener);
            } else {
                this.offset = 0;
                this.setBounds(new Rectangle(0, 0, 0, 0));
            }
        }

        public void paint(Graphics g) {
            if (this.target != null) {
                g.pushState();
                g.setBackgroundColor(this.color);
                g.setAlpha(50);
                g.fillRoundRectangle(this.bounds, 2 * this.offset, 2 * this.offset);
                g.popState();
            }
        }

        static /* synthetic */ void access$000(SelectionHalo x0, IFigure x1) {
            x0.setBoundsFromFigure(x1);
        }
    }
}

