/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.view.PERTPanel;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class PERTInteractivePanel
extends PERTPanel {
    protected double dispTimeInterval = 1.0;
    protected double dispTimeIntervalWidth = 5.0;
    protected TimeLine timeLine = new TimeLine();

    public PERTInteractivePanel(Composite parent, List steps, List resourceLabels) {
        super(parent, steps, resourceLabels, 25, 55, 10, 10, 10);
        this.contents.add((IFigure)this.timeLine);
    }

    public void resizeVisualization(Event e) {
        int regionWidth = this.getClientArea().width - (this.marginLeft + this.marginRight);
        if (regionWidth > 0) {
            double displayedTime = this.displayEndTime - this.displayStartTime;
            this.dispTimeInterval = 1.0;
            int x = 1;
            while ((double)regionWidth * (this.dispTimeInterval / displayedTime) < 4.0) {
                this.dispTimeInterval = Math.pow(10.0, x);
                ++x;
            }
            this.dispTimeIntervalWidth = (double)regionWidth * (this.dispTimeInterval / displayedTime);
            int timeLineX = this.marginLeft - (int)(this.displayStartTime / displayedTime * (double)regionWidth);
            int hiddenWidth = (int)((double)regionWidth * (this.totalTime / displayedTime));
            this.timeLine.setBounds(new Rectangle(timeLineX, 0, hiddenWidth, this.marginTop));
        }
        super.resizeVisualization(e);
    }

    public class TimeLine
    extends Figure {
        public void paint(Graphics g) {
            g.pushState();
            g.setForegroundColor(ColorConstants.black);
            g.setBackgroundColor(ColorConstants.white);
            double tLineX = this.getBounds().x;
            int x = 0;
            while ((double)x <= PERTInteractivePanel.this.totalTime) {
                int lineBottom;
                int lineTop;
                if ((double)x % (10.0 * PERTInteractivePanel.this.dispTimeInterval) == 0.0) {
                    lineTop = 10;
                    lineBottom = 30;
                    String numLabel = Double.toString((double)x / 1000.0);
                    int numLabelWidth = FigureUtilities.getTextWidth((String)numLabel, (Font)g.getFont());
                    g.drawText(numLabel, (int)(tLineX - ((double)x == 0.0 ? 0.0 : (double)numLabelWidth * 0.5)), 32);
                } else {
                    lineTop = 15;
                    lineBottom = 25;
                }
                g.drawLine((int)tLineX, lineTop, (int)tLineX, lineBottom);
                tLineX += PERTInteractivePanel.this.dispTimeIntervalWidth;
                x = (int)((double)x + PERTInteractivePanel.this.dispTimeInterval);
            }
            g.popState();
        }
    }
}

