/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.ResultStep;
import edu.cmu.cs.hcii.cogtool.model.StandaloneAlgo;
import edu.cmu.cs.hcii.cogtool.ui.PERTChartSelectionState;
import edu.cmu.cs.hcii.cogtool.uimodel.PERTChartUIModel;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.StringUtil;
import edu.cmu.cs.hcii.cogtool.view.AView;
import edu.cmu.cs.hcii.cogtool.view.MenuFactory;
import edu.cmu.cs.hcii.cogtool.view.PERTInteractivePanel;
import edu.cmu.cs.hcii.cogtool.view.PERTLabelPanel;
import edu.cmu.cs.hcii.cogtool.view.PERTScrollBar;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PERTChartView
extends AView {
    protected PERTInteractivePanel visPanel;
    protected PERTScrollBar scrollBar;
    protected PERTLabelPanel labelPanel;
    protected TabFolder infoTabFolder;
    protected TabItem traceTabItem;
    protected TabItem operatorTabItem;
    protected StyledText traceText;
    protected Text operatorInfoText;
    protected Sash sash;
    protected StandaloneAlgo.StandaloneResult result;
    protected IScript script;
    protected double totalTime;
    protected List resourceLabels;
    protected static Color selectionColor = new Color(null, GraphicsUtil.getRGBFromColor(54783));
    protected static String NO_OPERATOR_SELECTED = L10N.get("PCV.NO_OPERATOR", "No Operator Selected");

    public PERTChartView(StandaloneAlgo.StandaloneResult result, IScript scpt, ListenerIdentifierMap lIDMap, ListenerIdentifier.ILIDTransmuter transformer, MenuFactory.IWindowMenuData menuData, PERTChartUIModel uiModel, Rectangle loc) {
        super(PERTChartView.createShell(loc, 800, 600, (Layout)new FormLayout()), lIDMap, transformer, menuData);
        this.shell.setMinimumSize(450, 450);
        this.result = result;
        this.script = scpt;
        this.resourceLabels = new ArrayList();
        List steps = this.result.getModelSteps();
        if (steps.size() > 0) {
            Iterator stepIterator = steps.iterator();
            this.totalTime = 0.0;
            while (stepIterator.hasNext()) {
                ResultStep thisStep = (ResultStep)stepIterator.next();
                if (!this.resourceLabels.contains(thisStep.resource)) {
                    this.resourceLabels.add(thisStep.resource);
                }
                this.totalTime = Math.max(this.totalTime, thisStep.startTime + thisStep.duration);
            }
            this.resourceLabels = uiModel.orderResourceLabels(this.resourceLabels);
        } else {
            this.totalTime = 0.0;
        }
        this.visPanel = new PERTInteractivePanel((Composite)this.shell, steps, this.resourceLabels);
        this.labelPanel = new PERTLabelPanel((Composite)this.shell, this.resourceLabels, 55, 10);
        this.scrollBar = new PERTScrollBar((Composite)this.shell, steps, this.resourceLabels);
        this.scrollBar.setSize(100, 100);
        this.sash = new Sash((Composite)this.shell, 512);
        this.sash.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                int offsetWidth = PERTChartView.this.shell.getBounds().width - se.x;
                int minOffset = 250;
                int maxOffset = PERTChartView.this.shell.getBounds().width - 200;
                if (offsetWidth > maxOffset) {
                    se.doit = false;
                    offsetWidth = maxOffset;
                }
                if (offsetWidth < minOffset) {
                    se.doit = false;
                    offsetWidth = minOffset;
                }
                if (se.doit) {
                    ((FormData)PERTChartView.this.sash.getLayoutData()).right = new FormAttachment(100, -1 * offsetWidth);
                    PERTChartView.this.shell.layout();
                }
            }
        });
        this.scrollBar.addHandler(this, PERTScrollBar.ScrollEvent.class, new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                PERTScrollBar.ScrollEvent sEvent = (PERTScrollBar.ScrollEvent)alert;
                PERTChartView.this.visPanel.displayTimeSlice(sEvent.start, sEvent.end);
            }
        });
        this.infoTabFolder = new TabFolder((Composite)this.shell, 0);
        this.traceText = new StyledText((Composite)this.infoTabFolder, 778);
        this.traceText.setSelectionBackground(selectionColor);
        Iterator traceIt = this.result.getTraceLines().iterator();
        while (traceIt.hasNext()) {
            this.traceText.append((String)traceIt.next() + "\n");
        }
        this.traceText.setSelection(0);
        this.traceText.showSelection();
        this.operatorInfoText = new Text((Composite)this.infoTabFolder, 10);
        this.operatorInfoText.setText(NO_OPERATOR_SELECTED);
        this.operatorTabItem = new TabItem(this.infoTabFolder, 0);
        this.operatorTabItem.setText("Operator Info");
        this.operatorTabItem.setControl((Control)this.operatorInfoText);
        this.traceTabItem = new TabItem(this.infoTabFolder, 0);
        this.traceTabItem.setText("Model Trace");
        this.traceTabItem.setControl((Control)this.traceText);
        FormData sashFormData = new FormData();
        sashFormData.top = new FormAttachment(0, 5);
        sashFormData.right = new FormAttachment(100, -260);
        sashFormData.bottom = new FormAttachment(100, -5);
        FormData tabFormData = new FormData();
        tabFormData.top = new FormAttachment(0, 5);
        tabFormData.left = new FormAttachment((Control)this.sash, 2);
        tabFormData.right = new FormAttachment(100, -5);
        tabFormData.bottom = new FormAttachment(100, -5);
        FormData labelFormData = new FormData();
        labelFormData.top = new FormAttachment(0, 5);
        labelFormData.left = new FormAttachment(0, 5);
        labelFormData.right = new FormAttachment(0, 135);
        labelFormData.bottom = new FormAttachment((Control)this.scrollBar, 0);
        FormData visFormData = new FormData();
        visFormData.top = new FormAttachment(0, 5);
        visFormData.left = new FormAttachment((Control)this.labelPanel, 0);
        visFormData.right = new FormAttachment((Control)this.sash, -2);
        visFormData.bottom = new FormAttachment(100, -110);
        FormData scrollBarFormData = new FormData();
        scrollBarFormData.top = new FormAttachment((Control)this.visPanel, 0);
        scrollBarFormData.left = new FormAttachment(0, 5);
        scrollBarFormData.right = new FormAttachment((Control)this.sash, -2);
        scrollBarFormData.bottom = new FormAttachment(100, -5);
        this.visPanel.setLayoutData(visFormData);
        this.scrollBar.setLayoutData(scrollBarFormData);
        this.infoTabFolder.setLayoutData((Object)tabFormData);
        this.labelPanel.setLayoutData(labelFormData);
        this.sash.setLayoutData((Object)sashFormData);
        this.scrollBar.changeRegion(0.0, this.totalTime / 4.0);
    }

    protected MenuFactory.MenuType[] neededMenus() {
        return new MenuFactory.MenuType[]{MenuFactory.MenuType.FileMenu, MenuFactory.MenuType.EditMenu, MenuFactory.MenuType.WindowMenu, MenuFactory.MenuType.HelpMenu};
    }

    public void setStatusMessage(String message) {
    }

    public void setStatusMessage(String message, int duration) {
    }

    public PERTInteractivePanel getVisScrollPanel() {
        return this.visPanel;
    }

    public PERTInteractivePanel getVisPanel() {
        return this.visPanel;
    }

    public PERTScrollBar getVisScrollBar() {
        return this.scrollBar;
    }

    public StyledText getTextCtrl() {
        return this.traceText;
    }

    public void observeSelectionState(PERTChartSelectionState selection) {
        this.visPanel.observeSelectionState(selection);
        this.scrollBar.observeSelectionState(selection);
        IAlertHandler handler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                List selectedStepList = ((PERTChartSelectionState.SelectionChange)alert).selectedSteps;
                String trace = PERTChartView.this.traceText.getText();
                int startPos = -1;
                int endPos = -1;
                PERTChartView.this.operatorInfoText.setText("");
                Iterator stepIt = selectedStepList.iterator();
                while (stepIt.hasNext()) {
                    ResultStep step = (ResultStep)stepIt.next();
                    System.out.println(step.toString());
                    PERTChartView.this.operatorInfoText.append(step.toString() + "\n\n\n\n");
                    startPos = startPos < 0 ? Math.max(0, StringUtil.getCharPosFromLineNum(trace, step.traceStart)) : Math.min(startPos, StringUtil.getCharPosFromLineNum(trace, step.traceStart));
                    endPos = Math.max(endPos, StringUtil.getCharPosFromLineNum(trace, step.traceEnd));
                }
                if (selectedStepList.size() == 0) {
                    PERTChartView.this.operatorInfoText.setText(NO_OPERATOR_SELECTED);
                }
                if (startPos > -1 && endPos > -1) {
                    PERTChartView.this.traceText.setSelection(startPos, endPos);
                    PERTChartView.this.traceText.showSelection();
                }
            }
        };
        selection.addHandler(this, PERTChartSelectionState.SelectionChange.class, handler);
    }
}

