/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.MenuUtil;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.RcvrUIException;
import edu.cmu.cs.hcii.cogtool.view.IDesignEditorView;
import edu.cmu.cs.hcii.cogtool.view.IFrameEditorView;
import edu.cmu.cs.hcii.cogtool.view.IProjectView;
import edu.cmu.cs.hcii.cogtool.view.IScriptView;
import edu.cmu.cs.hcii.cogtool.view.IView;
import edu.cmu.cs.hcii.cogtool.view.PERTChartView;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class MenuFactory {
    protected static List windowMenus = new ArrayList();
    protected static final int control = MenuUtil.platformControlKey();
    public static final MenuUtil.SimpleMenuItemDefinition NEW_PROJECT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.NewProject", "&New Project"), (ListenerIdentifier)CogToolLID.NewProject, control | 0x6E);
    public static final MenuUtil.SimpleMenuItemDefinition OPEN = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.Open", "&Open..."), (ListenerIdentifier)CogToolLID.OpenProject, control | 0x6F);
    public static final MenuUtil.SimpleMenuItemDefinition CLOSE = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.Close", "&Close"), (ListenerIdentifier)CogToolLID.CloseWindow, control | 0x77);
    public static final MenuUtil.SimpleMenuItemDefinition CLOSE_PROJECT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.CloseProject", "Close P&roject"), CogToolLID.CloseProject);
    public static final MenuUtil.SimpleMenuItemDefinition SAVE = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.Save", "&Save"), (ListenerIdentifier)CogToolLID.SaveProject, control | 0x73);
    public static final MenuUtil.SimpleMenuItemDefinition SAVE_AS = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.SaveAs", "Save &as..."), (ListenerIdentifier)CogToolLID.SaveProjectAs, control | 0x20000 | 0x73);
    public static final MenuUtil.SimpleMenuItemDefinition EXPORT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.Export", "&Export..."), (ListenerIdentifier)CogToolLID.ExportProject, control | 0x20000 | 0x65);
    public static final MenuUtil.SimpleMenuItemDefinition EXPORT_DESIGN_TO_HTML = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.ExportDesignToHTML", "Export Design To HTML"), CogToolLID.ExportDesignToHTML);
    public static final MenuUtil.SimpleMenuItemDefinition IMPORT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.Import", "&Import..."), CogToolLID.ImportXML);
    public static final MenuUtil.SimpleMenuItemDefinition CAPTURE = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.Capture", "Capture Behavior..."), CogToolLID.CaptureBehavior);
    public static final MenuUtil.SimpleMenuItemDefinition EXPORT_SCRIPT_TO_CSV = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.ExportScriptToCSV", "Export Script To CSV"), CogToolLID.ExportScriptToCSV);
    public static final MenuUtil.SimpleMenuItemDefinition PRINT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.Print", "&Print..."), (ListenerIdentifier)CogToolLID.PrintProject, control | 0x70);
    public static final MenuUtil.SimpleMenuItemDefinition PRINT_PREVIEW = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.PrintPreview", "Print Pre&view..."), CogToolLID.PrintPreviewProject);
    public static final MenuUtil.SimpleMenuItemDefinition PAGE_SETUP = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.PageSetup", "Page Set&up..."), (ListenerIdentifier)CogToolLID.PageSetupProject, control | 0x20000 | 0x70);
    public static final MenuUtil.SimpleMenuItemDefinition PROPERTIES = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Properties", "Propert&ies"), CogToolLID.Properties);
    public static final MenuUtil.SimpleMenuItemDefinition EXIT = new MenuUtil.SimpleMenuItemDefinition(OSUtils.WINDOWS ? L10N.get("MI.PM.Exit", "E&xit") : L10N.get("MI.PM.Quit", "Quit"), (ListenerIdentifier)CogToolLID.ExitApplication, control | 0x71);
    public static final MenuUtil.SimpleMenuItemDefinition NEW_WIDGET = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.NewWidget", "New &Widget..."), (ListenerIdentifier)CogToolLID.NewWidget, control | 0x20000 | 0x69);
    public static final MenuUtil.SimpleMenuItemDefinition NEW_FRAME = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.DE.NewFrame", "New Fra&me..."), (ListenerIdentifier)CogToolLID.NewFrame, control | 0x20000 | 0x66);
    public static final MenuUtil.SimpleMenuItemDefinition NEW_DESIGN = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.NewDesign", "New &Design..."), (ListenerIdentifier)CogToolLID.NewDesign, control | 0x20000 | 0x64);
    public static final MenuUtil.SimpleMenuItemDefinition NEW_TASK = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.NewTask", "New &Task..."), (ListenerIdentifier)CogToolLID.NewTask, control | 0x20000 | 0x74);
    public static final MenuUtil.SimpleMenuItemDefinition NEW_TASK_GROUP = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.NewTaskGroup", "New Task &Group"), (ListenerIdentifier)CogToolLID.NewTaskGroup, control | 0x20000 | 0x67);
    public static final MenuUtil.SimpleMenuItemDefinition IMPORT_BACKGROUND_IMAGES = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.DE.ImportBackgroundImages", "Import Frame Background Images"), CogToolLID.ImportImageDirectory);
    public static final MenuUtil.SimpleMenuItemDefinition SET_BACKGROUND_IMAGE = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.SetBackgroundImage", "Set Frame Back&ground Image"), (ListenerIdentifier)CogToolLID.SetBackgroundImage, control | 0x62);
    public static final MenuUtil.SimpleMenuItemDefinition REMOVE_BACKGROUND_IMAGE = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.RemoveBackgroundImage", "Remove Frame Background Image"), (ListenerIdentifier)CogToolLID.RemoveBackgroundImage, control | 0x20000 | 0x62);
    public static final MenuUtil.SimpleMenuItemDefinition BRING_TO_FRONT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.BringToFront", "Bring To Front"), (ListenerIdentifier)CogToolLID.BringToFront, control | 0x20000 | 0x5D);
    public static final MenuUtil.SimpleMenuItemDefinition BRING_FORWARD = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.BringForward", "Bring Forward"), (ListenerIdentifier)CogToolLID.BringForward, control | 0x5D);
    public static final MenuUtil.SimpleMenuItemDefinition SEND_BACKWARD = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.SendBackward", "Send Backward"), (ListenerIdentifier)CogToolLID.SendBackward, control | 0x5B);
    public static final MenuUtil.SimpleMenuItemDefinition SEND_TO_BACK = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.SendToBack", "Send To Back"), (ListenerIdentifier)CogToolLID.SendToBack, control | 0x20000 | 0x5B);
    public static final MenuUtil.MenuItemDefinition[] LAYERING_ITEMS = new MenuUtil.MenuItemDefinition[]{BRING_TO_FRONT, BRING_FORWARD, SEND_BACKWARD, SEND_TO_BACK};
    public static final MenuUtil.MenuItemDefinition LAYERING_CASCADE = new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.FE.LayeringCascade", "Layering"), LAYERING_ITEMS);
    public static final MenuUtil.SimpleMenuItemDefinition ALIGN_TOP = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.AlignTop", "Align Top"), CogToolLID.AlignTop);
    public static final MenuUtil.SimpleMenuItemDefinition ALIGN_BOTTOM = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.AlignBottom", "Align Bottom"), CogToolLID.AlignBottom);
    public static final MenuUtil.SimpleMenuItemDefinition ALIGN_LEFT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.AlignLeft", "Align Left"), CogToolLID.AlignLeft);
    public static final MenuUtil.SimpleMenuItemDefinition ALIGN_RIGHT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.AlignRight", "Align Right"), CogToolLID.AlignRight);
    public static final MenuUtil.SimpleMenuItemDefinition SPACE_VERTICALLY = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.SpaceVertically", "Space Vertically"), CogToolLID.SpaceVertically);
    public static final MenuUtil.SimpleMenuItemDefinition SPACE_HORIZONTALLY = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.SpaceHorizontally", "Space Horizontally"), CogToolLID.SpaceHorizontally);
    public static final MenuUtil.MenuItemDefinition[] ALIGNMENT_ITEMS = new MenuUtil.MenuItemDefinition[]{ALIGN_TOP, ALIGN_BOTTOM, ALIGN_LEFT, ALIGN_RIGHT, MenuUtil.SEPARATOR, SPACE_VERTICALLY, SPACE_HORIZONTALLY};
    public static final MenuUtil.MenuItemDefinition ALIGNMENT_CASCADE = new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.FE.AlignmentCascade", "Alignment"), ALIGNMENT_ITEMS);
    public static final MenuUtil.SimpleMenuItemDefinition NUDGE_UP = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.NudgeUp", "Nudge &Up"), (ListenerIdentifier)CogToolLID.NudgeUp, control | 0x1000001);
    public static final MenuUtil.SimpleMenuItemDefinition NUDGE_DOWN = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.NudgeDown", "Nudge &Down"), (ListenerIdentifier)CogToolLID.NudgeDown, control | 0x1000002);
    public static final MenuUtil.SimpleMenuItemDefinition NUDGE_LEFT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.NudgeLeft", "Nudge &Left"), (ListenerIdentifier)CogToolLID.NudgeLeft, control | 0x1000003);
    public static final MenuUtil.SimpleMenuItemDefinition NUDGE_RIGHT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.NudgeRight", "Nudge &Right"), (ListenerIdentifier)CogToolLID.NudgeRight, control | 0x1000004);
    public static final MenuUtil.MenuItemDefinition[] NUDGE_ITEMS = new MenuUtil.MenuItemDefinition[]{NUDGE_UP, NUDGE_DOWN, NUDGE_LEFT, NUDGE_RIGHT};
    public static final MenuUtil.MenuItemDefinition NUDGE_CASCADE = new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.NudgeCascade", "Nudge"), NUDGE_ITEMS);
    public static final MenuUtil.SimpleMenuItemDefinition CUT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Cut", "Cu&t"), (ListenerIdentifier)CogToolLID.Cut, control | 0x78);
    public static final MenuUtil.SimpleMenuItemDefinition COPY = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Copy", "&Copy"), (ListenerIdentifier)CogToolLID.Copy, control | 0x63);
    public static final MenuUtil.SimpleMenuItemDefinition PASTE = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Paste", "&Paste"), (ListenerIdentifier)CogToolLID.Paste, control | 0x76);
    public static final MenuUtil.SimpleMenuItemDefinition SELECT_ALL = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.SelectAll", "Select &all"), (ListenerIdentifier)CogToolLID.SelectAll, control | 0x61);
    public static final MenuUtil.SimpleMenuItemDefinition UNDO = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Undo", "&Undo"), (ListenerIdentifier)CogToolLID.Undo, control | 0x7A);
    public static final MenuUtil.SimpleMenuItemDefinition REDO = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Redo", "&Redo"), (ListenerIdentifier)CogToolLID.Redo, control | 0x79);
    public static final MenuUtil.SimpleMenuItemDefinition EDIT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Edit", "&Edit"), (ListenerIdentifier)CogToolLID.Edit, control | 0x65);
    public static final MenuUtil.SimpleMenuItemDefinition RENAME = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Rename", "Re&name"), (ListenerIdentifier)CogToolLID.Rename, control | 0x72);
    public static final MenuUtil.SimpleMenuItemDefinition DELETE = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Delete", "&Delete"), (ListenerIdentifier)CogToolLID.Delete, control | (OSUtils.MACOSX ? 8 : 127));
    public static final MenuUtil.SimpleMenuItemDefinition DUPLICATE = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Duplicate", "Dupl&icate"), (ListenerIdentifier)CogToolLID.Duplicate, control | 0x64);
    public static final MenuUtil.SimpleMenuItemDefinition ZOOM_IN = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.ZoomIn", "Zoo&m In"), (ListenerIdentifier)CogToolLID.ZoomIn, control | 0x2B);
    public static final MenuUtil.SimpleMenuItemDefinition ZOOM_OUT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.ZoomOut", "Zoom &Out"), (ListenerIdentifier)CogToolLID.ZoomOut, control | 0x2D);
    public static final MenuUtil.SimpleMenuItemDefinition ZOOM_NORMAL = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.NormalZoom", "&Normal Zoom"), (ListenerIdentifier)CogToolLID.ZoomNormal, control | 0x3D);
    public static final MenuUtil.SimpleMenuItemDefinition ZOOM_FIT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.ZoomToFit", "Zoom to &Fit"), (ListenerIdentifier)CogToolLID.ZoomToFit, control | 0x2F);
    public static final MenuUtil.SimpleMenuItemDefinition RECOMPUTE_SCRIPT = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.RecomputeScript(s)", "Recompute Script(s)"), CogToolLID.RecomputeScript);
    public static final MenuUtil.SimpleMenuItemDefinition NO_SKIN = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.SK.NoSkin", "No Skin"), CogToolLID.SkinNone, 0, 16, false, true);
    public static final MenuUtil.SimpleMenuItemDefinition WIRE_SKIN = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.SK.WireFrame", "Wire Frame"), (ListenerIdentifier)CogToolLID.SkinWireFrame, 0, 16);
    public static final MenuUtil.SimpleMenuItemDefinition MACX_SKIN = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.SK.MacOSX", "MacOSX"), (ListenerIdentifier)CogToolLID.SkinMacOSX, 0, 16);
    public static final MenuUtil.SimpleMenuItemDefinition WINXP_SKIN = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.SK.WinXPSkin", "Windows XP"), (ListenerIdentifier)CogToolLID.SkinWinXP, 0, 16);
    public static final MenuUtil.SimpleMenuItemDefinition PALM_SKIN = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.SK.PalmSkin", "Palm"), (ListenerIdentifier)CogToolLID.SkinPalm, 0, 16);
    public static final MenuUtil.MenuItemDefinition[] SKIN_ITEMS = new MenuUtil.MenuItemDefinition[]{NO_SKIN, WIRE_SKIN, MACX_SKIN, WINXP_SKIN, PALM_SKIN};
    public static final MenuUtil.MenuItemDefinition SKIN_CASCADE = new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.FE.SetSkin", "Set Skin"), SKIN_ITEMS);
    public static final MenuUtil.SimpleMenuItemDefinition RECOMPUTE = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.SE.Recompute", "Recompute"), CogToolLID.RecomputeScript);
    public static final MenuUtil.SimpleMenuItemDefinition CHANGE_THINK_DURATION = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.SE.ChangeThinkDuration", "Change Think Duration"), CogToolLID.ChangeThinkDuration);
    public static final MenuUtil.SimpleMenuItemDefinition CHANGE_WAIT_DURATION = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.SE.ChangeWaitDuration", "Change Wait Duration"), CogToolLID.ChangeWaitDuration);
    protected static final ListenerIdentifier NO_WINDOWS_SENTINEL = new ListenerIdentifier();
    public static final MenuUtil.SimpleMenuItemDefinition NO_WINDOWS = new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.NONE", "NONE"), NO_WINDOWS_SENTINEL);
    public static final MenuUtil.CascadingMenuItemDefinition[] menuDefns = new MenuUtil.CascadingMenuItemDefinition[]{new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.File", "&File"), MenuFactory.createFileMenuDefn()), new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.Edit", "&Edit"), MenuFactory.createEditMenuDefn()), new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.Create", "&Create"), MenuFactory.createCreateMenuDefn()), new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.ProjectModify", "&Modify"), MenuFactory.createProjectModifyMenuDefn()), new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.CanvasModify", "&Modify"), MenuFactory.createCanvasModifyMenuDefn()), new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.ZoomModify", "&Modify"), MenuFactory.createZoomModifyMenuDefn()), new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.ScriptModify", "&Modify"), MenuFactory.createScriptModifyMenuDefn()), new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.Script", "&Script"), MenuFactory.createScriptMenuDefn()), new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.Window", "&Window"), null), new MenuUtil.CascadingMenuItemDefinition(L10N.get("MI.Help", "&Help"), MenuFactory.createHelpMenuDefn())};
    protected static Listener windowItemSelectionListener = new Listener(){

        public void handleEvent(Event evt) {
            WindowListenerID id = (WindowListenerID)evt.widget.getData();
            id.getView().takeFocus();
        }
    };
    protected static final int IN_PROJECT_ZONE = 0;
    protected static final int IN_DESIGN_ZONE = 1;
    protected static final int IN_FRAME_ZONE = 2;
    protected static final int IN_SCRIPT_ZONE = 3;
    protected static final int IN_VISUALIZATION_ZONE = 4;
    protected static final int IN_RBAUDITOR_ZONE = 5;
    protected static final int LAST_ZONE = 5;
    protected static Class[] zoneClasses = new Class[]{IProjectView.class, IDesignEditorView.class, IFrameEditorView.class, IScriptView.class, PERTChartView.class};

    protected static MenuUtil.MenuItemDefinition[] createFileMenuDefn() {
        if (OSUtils.MACOSX) {
            return new MenuUtil.SimpleMenuItemDefinition[]{NEW_PROJECT, OPEN, MenuUtil.SEPARATOR, CLOSE, CLOSE_PROJECT, SAVE, SAVE_AS, MenuUtil.SEPARATOR, EXPORT_DESIGN_TO_HTML, IMPORT, EXPORT_SCRIPT_TO_CSV, MenuUtil.SEPARATOR, PROPERTIES};
        }
        return new MenuUtil.SimpleMenuItemDefinition[]{NEW_PROJECT, OPEN, MenuUtil.SEPARATOR, CLOSE, CLOSE_PROJECT, SAVE, SAVE_AS, MenuUtil.SEPARATOR, EXPORT_DESIGN_TO_HTML, IMPORT, EXPORT_SCRIPT_TO_CSV, MenuUtil.SEPARATOR, PROPERTIES, MenuUtil.SEPARATOR, EXIT};
    }

    protected static MenuUtil.MenuItemDefinition[] createEditMenuDefn() {
        return new MenuUtil.SimpleMenuItemDefinition[]{UNDO, REDO, MenuUtil.SEPARATOR, CUT, COPY, PASTE, DELETE, SELECT_ALL, MenuUtil.SEPARATOR, EDIT, RENAME, DUPLICATE};
    }

    protected static MenuUtil.MenuItemDefinition[] createCreateMenuDefn() {
        return new MenuUtil.SimpleMenuItemDefinition[]{NEW_TASK, NEW_TASK_GROUP, MenuUtil.SEPARATOR, NEW_DESIGN, NEW_FRAME, NEW_WIDGET};
    }

    protected static MenuUtil.MenuItemDefinition[] createScriptMenuDefn() {
        return new MenuUtil.SimpleMenuItemDefinition[0];
    }

    protected static MenuUtil.MenuItemDefinition[] createProjectModifyMenuDefn() {
        return new MenuUtil.SimpleMenuItemDefinition[]{RECOMPUTE_SCRIPT, MenuUtil.SEPARATOR, new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.ShowSum", "Show &Sum"), CogToolLID.ShowSum, 0, 16, false, true), new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.ShowMean", "Show &Mean"), (ListenerIdentifier)CogToolLID.ShowMean, 0, 16), new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.ShowMin", "Show Mi&nimum"), (ListenerIdentifier)CogToolLID.ShowMin, 0, 16), new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.PM.ShowMax", "Show Ma&ximum"), (ListenerIdentifier)CogToolLID.ShowMax, 0, 16)};
    }

    protected static MenuUtil.MenuItemDefinition[] createCanvasModifyMenuDefn() {
        return new MenuUtil.MenuItemDefinition[]{SET_BACKGROUND_IMAGE, REMOVE_BACKGROUND_IMAGE, IMPORT_BACKGROUND_IMAGES, MenuUtil.SEPARATOR, new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.FE.SetWidgetColor", "Set Widget Layer Color"), (ListenerIdentifier)CogToolLID.SetWidgetColor, control | 0x20000 | 0x63), SKIN_CASCADE, MenuUtil.SEPARATOR, NUDGE_CASCADE, LAYERING_CASCADE, ALIGNMENT_CASCADE, MenuUtil.SEPARATOR, ZOOM_IN, ZOOM_OUT, ZOOM_NORMAL, ZOOM_FIT};
    }

    protected static MenuUtil.MenuItemDefinition[] createZoomModifyMenuDefn() {
        return new MenuUtil.MenuItemDefinition[]{ZOOM_IN, ZOOM_OUT, ZOOM_NORMAL, ZOOM_FIT};
    }

    protected static MenuUtil.MenuItemDefinition[] createScriptModifyMenuDefn() {
        return new MenuUtil.MenuItemDefinition[]{RECOMPUTE, MenuUtil.SEPARATOR, CHANGE_THINK_DURATION, CHANGE_WAIT_DURATION, MenuUtil.SEPARATOR, ZOOM_IN, ZOOM_OUT, ZOOM_NORMAL, ZOOM_FIT};
    }

    protected static MenuUtil.MenuItemDefinition[] createHelpMenuDefn() {
        int control = MenuUtil.platformControlKey();
        if (OSUtils.MACOSX) {
            return new MenuUtil.SimpleMenuItemDefinition[]{new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Help", "&Help"), (ListenerIdentifier)CogToolLID.Help, control | 0x3F)};
        }
        return new MenuUtil.SimpleMenuItemDefinition[]{new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.Help", "&Help"), (ListenerIdentifier)CogToolLID.Help, 0x100000A), new MenuUtil.SimpleMenuItemDefinition(L10N.get("MI.About", "&About CogTool"), CogToolLID.About)};
    }

    protected static int findNexusCascade(MenuItem[] nexusItems, Object nexusData, ILeadItemUpdater leadItemUpdater) {
        int i;
        for (i = 0; i < nexusItems.length && nexusData != nexusItems[i].getData(); ++i) {
            if (leadItemUpdater == null) continue;
            leadItemUpdater.updateLeadItem(nexusItems[i], i);
        }
        if (i == nexusItems.length) {
            throw new RcvrUIException("Cannot find nexus window cascade");
        }
        return i;
    }

    protected static void updateNexusCascadeItem(Menu inNexusMenu, IWindowMenuData menuData) {
        ListenerIdentifier itemLID = menuData.getLID();
        MenuItem[] windowMenuItems = inNexusMenu.getItems();
        int originalItemCount = windowMenuItems.length;
        for (int i = 0; i < originalItemCount; ++i) {
            if (windowMenuItems[i].getData() != itemLID) continue;
            windowMenuItems[i].setText(menuData.getEntryLabel());
            return;
        }
        throw new RcvrUIException("Cannot find window item");
    }

    protected static void updateMenuLabels(Menu inWindowMenu, IWindowMenuData menuData, ILeadItemUpdater leadItemUpdater) {
        MenuItem[] nexusItems = inWindowMenu.getItems();
        int i = MenuFactory.findNexusCascade(nexusItems, menuData.getNexusData(), leadItemUpdater);
        nexusItems[i].setText(menuData.getNexusLabel());
        MenuFactory.updateNexusCascadeItem(nexusItems[i].getMenu(), menuData);
    }

    public static void updateMenuLabels(IWindowMenuData menuData, ILeadItemUpdater leadItemUpdater) {
        Iterator menus = windowMenus.iterator();
        while (menus.hasNext()) {
            Menu windowMenu = (Menu)menus.next();
            MenuFactory.updateMenuLabels(windowMenu, menuData, leadItemUpdater);
        }
    }

    protected static boolean removeNexusCascadeItem(Menu fromNexusMenu, IWindowMenuData menuData) {
        int i;
        ListenerIdentifier itemLID = menuData.getLID();
        boolean precedingWasSeparator = false;
        MenuItem[] windowMenuItems = fromNexusMenu.getItems();
        int originalItemCount = windowMenuItems.length;
        for (i = 0; i < originalItemCount; ++i) {
            MenuItem windowItem = windowMenuItems[i];
            Object itemData = windowItem.getData();
            if (itemData == null) {
                precedingWasSeparator = true;
                continue;
            }
            if (itemData == itemLID) {
                windowItem.dispose();
                break;
            }
            precedingWasSeparator = false;
        }
        if (i == originalItemCount) {
            throw new RcvrUIException("Cannot find window item");
        }
        if (i == 0) {
            if (originalItemCount > 1 && windowMenuItems[1].getData() == null) {
                windowMenuItems[1].dispose();
            }
        } else if (precedingWasSeparator && (i + 1 == originalItemCount || windowMenuItems[i + 1].getData() == null)) {
            windowMenuItems[i - 1].dispose();
        }
        return fromNexusMenu.getItems().length == 0;
    }

    protected static void removeWindowMenuItem(Menu fromWindowMenu, IWindowMenuData menuData) {
        int i;
        MenuItem[] nexusItems = fromWindowMenu.getItems();
        if (MenuFactory.removeNexusCascadeItem(nexusItems[i = MenuFactory.findNexusCascade(nexusItems, menuData.getNexusData(), null)].getMenu(), menuData)) {
            nexusItems[i].dispose();
            if (fromWindowMenu.getItems().length == 0) {
                MenuItem noWindowsItem = new MenuItem(fromWindowMenu, 8);
                noWindowsItem.setText(MenuFactory.NO_WINDOWS.name);
                noWindowsItem.setData((Object)NO_WINDOWS_SENTINEL);
                noWindowsItem.setEnabled(false);
            }
        }
    }

    protected static void removeWindowMenu(Menu windowMenuToRemove) {
        windowMenus.remove(windowMenuToRemove);
        IWindowMenuData menuData = (IWindowMenuData)windowMenuToRemove.getData();
        if (windowMenus.size() > 0) {
            Iterator menus = windowMenus.iterator();
            while (menus.hasNext()) {
                Menu windowMenu = (Menu)menus.next();
                MenuFactory.removeWindowMenuItem(windowMenu, menuData);
            }
        }
    }

    protected static void copyExistingNexusWindows(MenuItem existingNexusItem, Menu newWindowMenu) {
        MenuItem newNexusItem = new MenuItem(newWindowMenu, 64);
        newNexusItem.setText(existingNexusItem.getText());
        newNexusItem.setImage(existingNexusItem.getImage());
        newNexusItem.setData(existingNexusItem.getData());
        Menu newNexusMenu = new Menu((Decorations)newWindowMenu.getShell(), 4);
        newNexusItem.setMenu(newNexusMenu);
        MenuItem[] nestedNexusItems = existingNexusItem.getMenu().getItems();
        for (int i = 0; i < nestedNexusItems.length; ++i) {
            MenuItem nestedNexusItem = nestedNexusItems[i];
            MenuItem newNestedItem = new MenuItem(newNexusMenu, nestedNexusItem.getStyle());
            newNestedItem.setText(nestedNexusItem.getText());
            newNestedItem.setImage(nestedNexusItem.getImage());
            Object windowLID = nestedNexusItem.getData();
            if (windowLID == null) continue;
            newNestedItem.setData(windowLID);
            newNestedItem.addListener(13, windowItemSelectionListener);
        }
    }

    protected static void copyExistingNexusCascades(MenuItem[] existingItems, int itemIndex, Menu newWindowMenu, Class nexusType) {
        MenuItem existingItem;
        if (itemIndex >= 0 && (existingItem = existingItems[itemIndex]).getStyle() == 64 && nexusType.isInstance(existingItem.getData())) {
            MenuFactory.copyExistingNexusCascades(existingItems, itemIndex - 1, newWindowMenu, nexusType);
            MenuFactory.copyExistingNexusWindows(existingItem, newWindowMenu);
        }
    }

    protected static void copyExistingWindows(Menu existingWindowMenu, Menu newWindowMenu, Class nexusType) {
        MenuItem[] existingItems = existingWindowMenu.getItems();
        MenuFactory.copyExistingNexusCascades(existingItems, existingItems.length - 1, newWindowMenu, nexusType);
    }

    protected static Menu createNexusCascade(Menu windowMenu, int index, IWindowMenuData menuData) {
        MenuItem newNexusItem = index != -1 ? new MenuItem(windowMenu, 64, index) : new MenuItem(windowMenu, 64);
        Menu cascadeParent = new Menu((Decorations)windowMenu.getShell(), 4);
        newNexusItem.setMenu(cascadeParent);
        newNexusItem.setText(menuData.getNexusLabel());
        newNexusItem.setData(menuData.getNexusData());
        return cascadeParent;
    }

    protected static Menu ensureNexusCascade(Menu windowMenu, MenuItem[] windowMenuItems, IWindowMenuData menuData) {
        MenuItem windowItem;
        int i;
        String nexusLabel = menuData.getNexusLabel();
        Class nexusType = menuData.getNexusType();
        Object nexusData = menuData.getNexusData();
        for (i = windowMenuItems.length; i > 0 && (windowItem = windowMenuItems[i - 1]).getStyle() == 64 && nexusType.isInstance(windowItem.getData()); --i) {
            if (windowItem.getData() == nexusData) {
                return windowItem.getMenu();
            }
            if (windowItem.getText().compareToIgnoreCase(nexusLabel) < 0) break;
        }
        return MenuFactory.createNexusCascade(windowMenu, i, menuData);
    }

    protected static int determineZone(Class viewClass) {
        for (int zone = 0; zone <= 5; ++zone) {
            if (!zoneClasses[zone].isAssignableFrom(viewClass)) continue;
            return zone;
        }
        throw new RcvrUIException("Unknown zone class");
    }

    protected static void addToCascade(Menu nexusCascade, IWindowMenuData menuData) {
        int i;
        boolean needSeparator = true;
        String newLabel = menuData.getEntryLabel();
        int desiredZone = MenuFactory.determineZone(menuData.getViewType());
        int currentZone = 0;
        MenuItem[] nexusItems = nexusCascade.getItems();
        for (i = 0; i < nexusItems.length; ++i) {
            MenuItem nexusItem = nexusItems[i];
            Object viewLID = nexusItem.getData();
            if (viewLID != null) {
                currentZone = MenuFactory.determineZone(((WindowListenerID)viewLID).getView().getClass());
                if (desiredZone == currentZone) {
                    needSeparator = false;
                    if (nexusItem.getText().compareToIgnoreCase(newLabel) <= 0) continue;
                    break;
                }
                if (needSeparator && desiredZone >= currentZone) continue;
                break;
            }
            if (!needSeparator) break;
        }
        if (needSeparator && i == nexusItems.length) {
            if (i > 0) {
                MenuItem ignore = new MenuItem(nexusCascade, 2, i++);
            }
            needSeparator = false;
        }
        MenuItem newItem = new MenuItem(nexusCascade, 8, i);
        newItem.setText(newLabel);
        newItem.setData((Object)menuData.getLID());
        newItem.addListener(13, windowItemSelectionListener);
        if (needSeparator) {
            MenuItem ignore = new MenuItem(nexusCascade, 2, i + 1);
        }
    }

    protected static void addWindowMenu(Menu newWindowMenu, IWindowMenuData menuData) {
        if (windowMenus.size() > 0) {
            MenuFactory.copyExistingWindows((Menu)windowMenus.get(0), newWindowMenu, menuData.getNexusType());
        }
        windowMenus.add(newWindowMenu);
        newWindowMenu.setData((Object)menuData);
        if (menuData.getNexusData() != null) {
            Iterator menus = windowMenus.iterator();
            while (menus.hasNext()) {
                MenuItem lastItem;
                Menu windowMenu = (Menu)menus.next();
                Menu nexusCascade = null;
                MenuItem[] nexusItems = windowMenu.getItems();
                if (nexusItems.length > 0 && (lastItem = nexusItems[nexusItems.length - 1]).getData() == NO_WINDOWS_SENTINEL) {
                    lastItem.dispose();
                    nexusCascade = MenuFactory.createNexusCascade(windowMenu, -1, menuData);
                }
                if (nexusCascade == null) {
                    nexusCascade = MenuFactory.ensureNexusCascade(windowMenu, nexusItems, menuData);
                }
                MenuFactory.addToCascade(nexusCascade, menuData);
            }
            newWindowMenu.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MenuFactory.removeWindowMenu((Menu)e.getSource());
                }
            });
        } else {
            newWindowMenu.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    windowMenus.remove((Menu)e.getSource());
                }
            });
        }
    }

    public static Menu buildMenu(MenuType[] neededMenus, Shell viewShell, Listener selectionListener, ListenerIdentifierMap lIDMap, IWindowMenuData menuData) {
        int windowMenuIndex = -1;
        MenuUtil.MenuItemDefinition[] defn = new MenuUtil.CascadingMenuItemDefinition[neededMenus.length];
        for (int i = 0; i < neededMenus.length; ++i) {
            defn[i] = menuDefns[neededMenus[i].getOrdering()];
            if (neededMenus[i] != MenuType.WindowMenu) continue;
            windowMenuIndex = i;
            ((MenuUtil.CascadingMenuItemDefinition)defn[i]).menuItems = menuData.getWindowMenuLeadItems();
        }
        Menu newMenuBar = MenuUtil.createMenu(viewShell, 0x2000002, defn, ListenerIdentifierMap.NORMAL, selectionListener, lIDMap);
        if (windowMenuIndex != -1) {
            ((MenuUtil.CascadingMenuItemDefinition)defn[windowMenuIndex]).menuItems = null;
            MenuFactory.addWindowMenu(newMenuBar.getItem(windowMenuIndex).getMenu(), menuData);
        }
        return newMenuBar;
    }

    public static interface ILeadItemUpdater {
        public void updateLeadItem(MenuItem var1, int var2);
    }

    public static class MenuType
    implements Comparable {
        protected static int nextOrdering = 0;
        private final transient String label;
        private final transient int ordering;
        private final int persistenceValue;
        public static final MenuType FileMenu = new MenuType("File", 0);
        public static final MenuType EditMenu = new MenuType("Edit", 1);
        public static final MenuType CreateMenu = new MenuType("Create", 2);
        public static final MenuType ProjectModifyMenu = new MenuType("ProjectModify", 3);
        public static final MenuType CanvasModifyMenu = new MenuType("CanvasModify", 4);
        public static final MenuType ZoomModifyMenu = new MenuType("ZoomModify", 5);
        public static final MenuType ScriptModifyMenu = new MenuType("ScriptModifyMenu", 6);
        public static final MenuType ScriptMenu = new MenuType("Script", 7);
        public static final MenuType WindowMenu = new MenuType("Window", 8);
        public static final MenuType HelpMenu = new MenuType("Help", 9);
        protected static final MenuType[] PERSISTENCE_ORDERING = new MenuType[]{FileMenu, EditMenu, ProjectModifyMenu, CanvasModifyMenu, ZoomModifyMenu, ScriptModifyMenu, CreateMenu, ScriptMenu, WindowMenu, HelpMenu};
        public static final MenuType[] VALUES = new MenuType[]{FileMenu, EditMenu, ProjectModifyMenu, CanvasModifyMenu, ZoomModifyMenu, ScriptModifyMenu, CreateMenu, ScriptMenu, WindowMenu, HelpMenu};

        protected MenuType(String newLabel, int newPersistenceValue) {
            this.label = newLabel;
            this.persistenceValue = newPersistenceValue;
            this.ordering = nextOrdering++;
        }

        public String toString() {
            return this.label;
        }

        public int compareTo(Object other) {
            return this.ordering - ((MenuType)other).ordering;
        }

        public boolean equals(Object other) {
            return this.ordering == ((MenuType)other).ordering;
        }

        public int getOrdering() {
            return this.ordering;
        }

        private Object readResolve() throws ObjectStreamException {
            return PERSISTENCE_ORDERING[this.persistenceValue];
        }
    }

    public static class WindowListenerID
    extends ListenerIdentifier {
        protected IView view;

        public WindowListenerID(IView v) {
            this.view = v;
        }

        public IView getView() {
            return this.view;
        }
    }

    public static interface IWindowMenuData {
        public void setView(IView var1);

        public MenuUtil.MenuItemDefinition[] getWindowMenuLeadItems();

        public String getNexusLabel();

        public Object getNexusData();

        public Class getNexusType();

        public String getEntryLabel();

        public Class getViewType();

        public ListenerIdentifier getLID();

        public void setNexusLabel(String var1);

        public void setEntryLabel(String var1);
    }
}

