/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.graphics.Cursor;

public class InteractionFigure
extends Clickable {
    protected IEnterExitListener enterExitListener;
    protected MouseMotionListener motionListener;
    protected MouseListener clickListener;

    public InteractionFigure(IEnterExitListener enterExitL, MouseMotionListener motionL, MouseListener clickL, Cursor figureCursor) {
        this.enterExitListener = enterExitL;
        this.motionListener = motionL;
        this.clickListener = clickL;
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.setCursor(figureCursor);
    }

    public MouseMotionListener getMouseMotionListener() {
        return this.motionListener;
    }

    public MouseListener getClickListener() {
        return this.clickListener;
    }

    public void setMouseMotionListener(MouseMotionListener motionL) {
        if (this.motionListener != motionL) {
            this.motionListener = motionL;
        }
    }

    public void setClickListener(MouseListener clickL) {
        if (this.clickListener != clickL) {
            this.clickListener = clickL;
        }
    }

    public void handleMouseMoved(MouseEvent evt) {
        if (this.motionListener != null) {
            this.motionListener.mouseMoved(evt);
        }
    }

    public void handleMousePressed(MouseEvent evt) {
        if (this.clickListener != null) {
            this.clickListener.mousePressed(evt);
        }
    }

    public void handleMouseDoubleClicked(MouseEvent evt) {
        if (this.clickListener != null) {
            this.clickListener.mouseDoubleClicked(evt);
        }
    }

    public void handleMouseReleased(MouseEvent evt) {
        if (this.clickListener != null) {
            this.clickListener.mouseReleased(evt);
        }
    }

    public void handleMouseEntered(MouseEvent evt) {
        this.enterExitListener.observeEnter();
        if (this.motionListener != null) {
            this.motionListener.mouseEntered(evt);
        }
    }

    public void handleMouseExited(MouseEvent evt) {
        this.enterExitListener.observeExit();
        if (this.motionListener != null) {
            this.motionListener.mouseExited(evt);
        }
    }

    public void handleMouseHover(MouseEvent evt) {
        if (this.motionListener != null) {
            this.motionListener.mouseHover(evt);
        }
    }

    public void handleMouseDragged(MouseEvent evt) {
        if (this.motionListener != null) {
            this.motionListener.mouseDragged(evt);
        }
    }

    public static interface IEnterExitListener {
        public void observeEnter();

        public void observeExit();
    }
}

