/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.util.IFlatDraw2DMouseListener;
import edu.cmu.cs.hcii.cogtool.util.IFlatDraw2DMouseMotionListener;
import edu.cmu.cs.hcii.cogtool.util.IZoomable;
import edu.cmu.cs.hcii.cogtool.view.IScalableFigure;
import edu.cmu.cs.hcii.cogtool.view.InteractionFigure;
import edu.cmu.cs.hcii.cogtool.view.StandardDrawingEditor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class InteractionDrawingEditor
extends StandardDrawingEditor
implements InteractionFigure.IEnterExitListener {
    protected IScalableFigure contents;
    protected InteractionFigure interactionLayer;
    protected RectangleFigure backgroundColorFigure;
    protected Color backgroundColor;
    protected IFlatDraw2DMouseListener mouseClickState;
    protected IFlatDraw2DMouseMotionListener mouseMotionState;

    public InteractionDrawingEditor(IScalableFigure child, IFlatDraw2DMouseMotionListener motionL, IFlatDraw2DMouseListener clickL, Composite window, IZoomable zoom, int propertiesPaneSize, int propertiesPaneLocation, int paletteSize, Cursor editorCursor) {
        this(child, motionL, clickL, zoom, window, propertiesPaneSize, propertiesPaneLocation, paletteSize, editorCursor, null);
    }

    public InteractionDrawingEditor(IScalableFigure child, IFlatDraw2DMouseMotionListener motionL, IFlatDraw2DMouseListener clickL, IZoomable zoom, Composite window, int propertiesPaneSize, int propertiesPaneLocation, int paletteSize, Cursor editorCursor, Color bgColor) {
        super(window, propertiesPaneSize, propertiesPaneLocation, paletteSize, zoom, 0);
        this.interactionLayer = new InteractionFigure(this, motionL, clickL, editorCursor);
        this.backgroundColor = bgColor;
        this.backgroundColorFigure = new RectangleFigure();
        this.backgroundColorFigure.setBackgroundColor(this.backgroundColor);
        this.mouseClickState = clickL;
        this.mouseMotionState = motionL;
        this.contents = child;
        this.editorComposite.setBounds(this.getContentSize());
        this.getLWS().setContents((IFigure)this.interactionLayer);
        this.setContents(this.contents);
        super.addEditorControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = InteractionDrawingEditor.this.editorComposite.getClientArea();
                InteractionDrawingEditor.this.resizeContents(r.width, r.height, true);
                InteractionDrawingEditor.this.setScrollIncrements();
            }
        });
    }

    public void observeEnter() {
        if (this.capturingEvents) {
            this.stopForwardingCanvasEvents();
        }
    }

    public void observeExit() {
        if (this.capturingEvents) {
            this.forwardCanvasEvents();
        }
    }

    protected void forwardCapturedEvent(int eventType, int button, int x, int y, int state) {
        switch (eventType) {
            case 0: {
                this.mouseClickState.mousePressed((IFigure)this.interactionLayer, button, x, y, state);
                break;
            }
            case 1: {
                this.mouseClickState.mouseReleased((IFigure)this.interactionLayer, button, x, y, state);
                break;
            }
            case 3: {
                this.mouseMotionState.mouseMoved((IFigure)this.interactionLayer, x, y, state);
                break;
            }
            case 4: {
                this.mouseMotionState.mouseDragged((IFigure)this.interactionLayer, button, x, y, state);
                break;
            }
            case 2: {
                this.mouseClickState.mouseDoubleClicked((IFigure)this.interactionLayer, button, x, y, state);
            }
        }
    }

    public InteractionFigure getInteractionFigure() {
        return this.interactionLayer;
    }

    public IScalableFigure getContents() {
        return this.contents;
    }

    public Figure getBackgroundColorFigure() {
        return this.backgroundColorFigure;
    }

    public Rectangle getContentSize() {
        org.eclipse.draw2d.geometry.Rectangle viewSize = this.contents.getChildrenUtilizedAreaScaled();
        viewSize.width += viewSize.x;
        viewSize.height += viewSize.y;
        return new Rectangle(0, 0, viewSize.width, viewSize.height);
    }

    public void resizeContents(int width, int height, boolean resizeMin) {
        org.eclipse.draw2d.geometry.Rectangle viewSize = this.contents.getChildrenUtilizedAreaScaled();
        int viewUIWidth = viewSize.width + viewSize.x;
        int viewUIHeight = viewSize.height + viewSize.y;
        if (viewUIWidth > width) {
            width = viewUIWidth;
        }
        if (viewUIHeight > height) {
            height = viewUIHeight;
        }
        Dimension prefSize = new Dimension(width, height);
        this.contents.setPreferredSize(prefSize);
        this.contents.setSize(width, height);
        this.interactionLayer.setPreferredSize(prefSize);
        this.interactionLayer.setSize(width, height);
        this.backgroundColorFigure.setPreferredSize(prefSize);
        this.backgroundColorFigure.setSize(width, height);
        if (resizeMin) {
            this.setMinVisibleArea(width, height, false);
            int editorWidth = this.editorComposite.getSize().x;
            int editorHeight = this.editorComposite.getSize().y;
            if (editorWidth > width) {
                width = editorWidth;
            }
            if (editorHeight > height) {
                height = editorHeight;
            }
            this.contents.setSize(width, height);
            this.interactionLayer.setSize(width, height);
            this.backgroundColorFigure.setSize(width, height);
        }
    }

    public void setContents(IScalableFigure figure) {
        double zoom = this.getZoomSetting();
        this.contents = figure;
        this.contents.setLocation(new Point(0, 0));
        this.interactionLayer.removeAll();
        this.interactionLayer.add((IFigure)this.backgroundColorFigure);
        this.interactionLayer.add((IFigure)this.contents);
        this.setZoomSetting(zoom);
        this.resizeScrollArea();
    }

    public double computeZoomToFit() {
        this.scrollComposite.setOrigin(0, 0);
        Rectangle visibleBounds = this.getVisibleBounds();
        org.eclipse.draw2d.geometry.Rectangle neededBounds = this.contents.getChildrenUtilizedAreaUnscaled();
        double scalingToFit = 1.0;
        scalingToFit = (double)visibleBounds.width / (double)neededBounds.width * (double)neededBounds.height < (double)visibleBounds.height ? (double)visibleBounds.width / (double)neededBounds.width : (double)visibleBounds.height / (double)neededBounds.height;
        return scalingToFit;
    }

    public double getZoomSetting() {
        if (this.contents != null) {
            return this.contents.getScale();
        }
        return 1.0;
    }

    public void setZoomSetting(double zoom) {
        super.setZoomSetting(zoom);
        if (this.contents.getScale() != zoom) {
            this.contents.setScale(zoom);
            this.resizeScrollArea();
        }
    }

    public void resizeScrollArea() {
        if (this.contents != null) {
            this.resizeContents(0, 0, true);
        }
    }

    public void addInteractionFigure(IFigure figure) {
        this.interactionLayer.add(figure);
    }

    public void removeInteractionFigure(IFigure figure) {
        this.interactionLayer.remove(figure);
    }

    public void repaint() {
        this.interactionLayer.repaint();
    }

    public void dispose() {
        super.dispose();
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
    }
}

