/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.ShapeType;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorLID;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.IFlatDraw2DMouseListener;
import edu.cmu.cs.hcii.cogtool.util.IFlatDraw2DMouseMotionListener;
import edu.cmu.cs.hcii.cogtool.util.IZoomable;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.MenuUtil;
import edu.cmu.cs.hcii.cogtool.util.TextWithEnableFix;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.AView;
import edu.cmu.cs.hcii.cogtool.view.IFrameEditorView;
import edu.cmu.cs.hcii.cogtool.view.IScalableFigure;
import edu.cmu.cs.hcii.cogtool.view.InteractionDrawingEditor;
import edu.cmu.cs.hcii.cogtool.view.MenuFactory;
import edu.cmu.cs.hcii.cogtool.view.Palette;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.EventObject;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FrameEditorView
extends AView
implements IFrameEditorView {
    protected InteractionDrawingEditor editor;
    protected static final int PROPERTIES_PANE_WIDTH = 200;
    protected static final int PALETTE_WIDTH = 30;
    public static final String BUTTON_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/Button.gif";
    public static final String CHECKBOX_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/CheckBox.gif";
    public static final String LISTBOXITEM_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/ListBoxItem.gif";
    public static final String MENU_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/MenuHeader.gif";
    public static final String MENUITEM_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/MenuItem.gif";
    public static final String NONINTERACTIVE_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/NonInteractive.gif";
    public static final String PULLDOWN_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/PullDownMenu.gif";
    public static final String PULLDOWNITEM_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/PullDownMenuItem.gif";
    public static final String RADIO_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/RadioButton.gif";
    public static final String STATICTEXT_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/StaticText.gif";
    public static final String SUBMENU_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/SubMenu.gif";
    public static final String TEXTBOX_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/TextBox.gif";
    public static final String GRAFFITI_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/Graffiti.gif";
    protected Label widgetName;
    protected Text widgetNameText;
    protected Label widgetTitle;
    protected Text widgetTitleText;
    protected Label widgetType;
    protected Label widgetTypeLabel;
    protected Button widgetSetImage;
    protected Button widgetRemoveImage;
    protected Button widgetCaptureImage;
    protected WidgetType currentNewWidgetType = WidgetType.Noninteractive;
    protected Palette.ButtonListener setCurrentNewWidgetType = new Palette.ButtonListener(){

        public void widgetSelected(SelectionEvent evt) {
            super.widgetSelected(evt);
            Control button = (Control)evt.getSource();
            FrameEditorView.this.currentNewWidgetType = (WidgetType)button.getData();
            FrameEditorView.this.setStatusMessage(button.getToolTipText());
        }
    };
    protected IFrameEditorSelectionState selection;
    protected boolean isBackgroundAvailable;
    public static final int BLANK_SPACE_MENU = 0;
    public static final int SELECTION_MENU = 1;
    public static final MenuUtil.MenuItemDefinition[] FRAME_ITEMS = new MenuUtil.MenuItemDefinition[]{MenuFactory.PASTE, MenuFactory.SELECT_ALL, MenuUtil.SEPARATOR, MenuFactory.NEW_WIDGET, MenuUtil.SEPARATOR, MenuFactory.SKIN_CASCADE, MenuFactory.SET_BACKGROUND_IMAGE, MenuFactory.REMOVE_BACKGROUND_IMAGE, MenuUtil.SEPARATOR, MenuFactory.ZOOM_IN, MenuFactory.ZOOM_OUT, MenuFactory.ZOOM_NORMAL, MenuFactory.ZOOM_FIT};
    public static final MenuUtil.MenuItemDefinition[][] CONTEXT_DEFS = new MenuUtil.MenuItemDefinition[][]{FRAME_ITEMS, {MenuFactory.CUT, MenuFactory.COPY, MenuFactory.DELETE, MenuUtil.SEPARATOR, MenuFactory.SKIN_CASCADE, MenuUtil.SEPARATOR, MenuFactory.NUDGE_CASCADE, MenuFactory.LAYERING_CASCADE, MenuFactory.ALIGNMENT_CASCADE}};

    public FrameEditorView(int deviceTypes, ListenerIdentifierMap lIDMap, ListenerIdentifier.ILIDTransmuter transformer, MenuFactory.IWindowMenuData menuData, IScalableFigure contents, IFlatDraw2DMouseMotionListener motionL, IFlatDraw2DMouseListener clickL, IFrameEditorSelectionState seln, IZoomable zoomer, Rectangle loc) {
        super(FrameEditorView.createShell(loc), lIDMap, transformer, menuData);
        this.selection = seln;
        int mouseTouchDeviceSet = DeviceType.buildDeviceSet(Arrays.asList(DeviceType.Touchscreen, DeviceType.Mouse));
        this.editor = new InteractionDrawingEditor(contents, motionL, clickL, (Composite)this.getShell(), zoomer, 200, 131072, 30, new Cursor((Device)WindowUtil.globalDisplay, 2));
        this.layOutPropertiesPane(deviceTypes, this.editor.propertiesComposite);
        this.layOutPalette(deviceTypes, this.editor.paletteComposite);
        if (DeviceType.intersects(deviceTypes, mouseTouchDeviceSet)) {
            this.currentNewWidgetType = WidgetType.Button;
        }
        this.setStatusMessage(L10N.get("Create", "Create") + " " + this.currentNewWidgetType.toString());
        this.isBackgroundAvailable = false;
        this.widgetTypeLabel.setText("");
        this.useParameters(0);
        this.shell.setMinimumSize(400, 300);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                ((Shell)arg0.widget).setFocus();
                super.shellClosed(arg0);
            }
        });
    }

    protected void layOutPalette(int deviceTypes, Palette parent) {
        Button lastButton = null;
        for (int i = 0; i < WidgetType.DISPLAY.length; ++i) {
            WidgetType widgetTypeOpt = WidgetType.DISPLAY[i];
            if (!widgetTypeOpt.worksOn(deviceTypes)) continue;
            String resource = null;
            if (widgetTypeOpt.equals(WidgetType.Button)) {
                resource = BUTTON_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.Check)) {
                resource = CHECKBOX_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.Graffiti)) {
                resource = GRAFFITI_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.ListBoxItem)) {
                resource = LISTBOXITEM_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.Menu)) {
                resource = MENU_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.MenuItem)) {
                resource = MENUITEM_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.Noninteractive)) {
                resource = NONINTERACTIVE_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.PullDownList)) {
                resource = PULLDOWN_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.PullDownItem)) {
                resource = PULLDOWNITEM_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.Submenu)) {
                resource = SUBMENU_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.Radio)) {
                resource = RADIO_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.Text)) {
                resource = STATICTEXT_ICON_RESOURCE;
            } else if (widgetTypeOpt.equals(WidgetType.TextBox)) {
                resource = TEXTBOX_ICON_RESOURCE;
            }
            String widgetTypeName = widgetTypeOpt.toString();
            Image icon = resource != null ? GraphicsUtil.getImageFromResource(resource) : null;
            lastButton = parent.createPaletteButton(icon, (Control)lastButton, parent, widgetTypeOpt, this.setCurrentNewWidgetType, L10N.get("Create", "Create") + " " + widgetTypeName);
        }
    }

    protected static Shell createShell(Rectangle loc) {
        return FrameEditorView.createShell(loc, 700, 600, (Layout)new FillLayout());
    }

    protected MenuFactory.MenuType[] neededMenus() {
        return new MenuFactory.MenuType[]{MenuFactory.MenuType.FileMenu, MenuFactory.MenuType.EditMenu, MenuFactory.MenuType.CreateMenu, MenuFactory.MenuType.CanvasModifyMenu, MenuFactory.MenuType.WindowMenu, MenuFactory.MenuType.HelpMenu};
    }

    public InteractionDrawingEditor getEditor() {
        return this.editor;
    }

    protected void layOutPropertiesPane(int deviceTypes, Composite parent) {
        Label propLabel = new Label(parent, 0x1000000);
        propLabel.setText("Widget Properties");
        Font labelFont = propLabel.getFont();
        FontData[] fData = labelFont.getFontData();
        String fontName = fData[0].getName();
        int fontSize = fData[0].getHeight();
        FontData font = new FontData(fontName, fontSize, 1);
        propLabel.setFont(new Font(null, font));
        FormData data = new FormData();
        data.right = new FormAttachment(100, -5);
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 5);
        propLabel.setLayoutData((Object)data);
        this.widgetName = new Label(parent, 0);
        this.widgetName.setText(L10N.get("FE.WidgetNameCaption", "Widget Name") + ":");
        this.widgetNameText = new TextWithEnableFix(parent, 2052);
        this.setWidgetName(null);
        WidgetTextChangeHandler handler = new WidgetTextChangeHandler(FrameEditorLID.ChangeNameProperty);
        this.widgetNameText.addSelectionListener((SelectionListener)handler);
        this.widgetNameText.addFocusListener((FocusListener)handler);
        this.widgetTitle = new Label(parent, 0);
        this.widgetTitle.setText(L10N.get("FE.WidgetLabelCaption", "Displayed Label") + ":");
        this.widgetTitleText = new TextWithEnableFix(parent, 2052);
        this.setWidgetTitle(null);
        handler = new WidgetTextChangeHandler(FrameEditorLID.ChangeTitleProperty);
        this.widgetTitleText.addSelectionListener((SelectionListener)handler);
        this.widgetTitleText.addFocusListener((FocusListener)handler);
        this.widgetType = new Label(parent, 0);
        this.widgetType.setText(L10N.get("FE.WidgetTypeCaption", "Type") + ":");
        this.widgetTypeLabel = new Label(parent, 0);
        this.widgetSetImage = new Button(parent, 8);
        this.widgetSetImage.setText(L10N.get("FE.WidgetImageSetCaption", "Set Widget Image"));
        this.widgetSetImage.addSelectionListener((SelectionListener)new AView.SWTWidgetChangeHandler(FrameEditorLID.SetImageProperty));
        this.widgetRemoveImage = new Button(parent, 8);
        this.widgetRemoveImage.setText(L10N.get("FE.WidgetImageRemoveCaption", "Remove Widget Image"));
        this.widgetRemoveImage.addSelectionListener((SelectionListener)new AView.SWTWidgetChangeHandler(FrameEditorLID.RemoveImageProperty));
        this.widgetCaptureImage = new Button(parent, 8);
        this.widgetCaptureImage.setText(L10N.get("FE.WidgetImageCaptureCaption", "Capture Background"));
        this.widgetCaptureImage.addSelectionListener((SelectionListener)new AView.SWTWidgetChangeHandler(FrameEditorLID.CaptureImageProperty));
        parent.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment((Control)propLabel, 10, 1024);
        this.widgetName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.widgetName, 5);
        data.left = new FormAttachment((Control)this.widgetName, 0, 16384);
        data.right = new FormAttachment(100, -10);
        this.widgetNameText.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.widgetNameText, 5);
        data.left = new FormAttachment((Control)this.widgetName, 0, 16384);
        this.widgetTitle.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.widgetTitle, 5);
        data.left = new FormAttachment((Control)this.widgetName, 0, 16384);
        data.right = new FormAttachment(100, -10);
        this.widgetTitleText.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.widgetTypeLabel, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.widgetName, 0, 16384);
        this.widgetType.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.widgetTitleText, 5);
        data.left = new FormAttachment((Control)this.widgetType, 15);
        data.right = new FormAttachment(100, -10);
        this.widgetTypeLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.widgetTypeLabel, 5);
        data.left = new FormAttachment((Control)this.widgetName, 0, 16384);
        this.widgetSetImage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.widgetSetImage, 5);
        data.left = new FormAttachment((Control)this.widgetName, 0, 16384);
        data.right = new FormAttachment((Control)this.widgetRemoveImage, 0, 131072);
        this.widgetRemoveImage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.widgetRemoveImage, 5);
        data.left = new FormAttachment((Control)this.widgetName, 0, 16384);
        data.right = new FormAttachment((Control)this.widgetRemoveImage, 0, 131072);
        this.widgetCaptureImage.setLayoutData((Object)data);
    }

    public void useParameters(int mode) {
        switch (mode) {
            case 1: {
                this.widgetName.setEnabled(true);
                this.widgetNameText.setEnabled(true);
                this.widgetTitle.setEnabled(true);
                this.widgetTitleText.setEnabled(true);
                this.widgetType.setEnabled(true);
                this.widgetTypeLabel.setEnabled(true);
                this.widgetSetImage.setEnabled(true);
                this.widgetCaptureImage.setEnabled(this.isBackgroundAvailable);
                break;
            }
            case 2: {
                this.widgetName.setEnabled(false);
                this.widgetNameText.setEnabled(false);
                this.setWidgetName(null);
                this.widgetTitle.setEnabled(false);
                this.widgetTitleText.setEnabled(false);
                this.setWidgetTitle(null);
                this.widgetType.setEnabled(false);
                this.widgetTypeLabel.setEnabled(false);
                this.setWidgetType(null);
                this.widgetSetImage.setEnabled(true);
                this.widgetCaptureImage.setEnabled(this.isBackgroundAvailable);
                break;
            }
            default: {
                this.widgetName.setEnabled(false);
                this.widgetNameText.setEnabled(false);
                this.setWidgetName(null);
                this.widgetTitle.setEnabled(false);
                this.widgetTitleText.setEnabled(false);
                this.setWidgetTitle(null);
                this.widgetType.setEnabled(false);
                this.widgetTypeLabel.setEnabled(false);
                this.setWidgetType(null);
                this.widgetRemoveImage.setEnabled(false);
                this.widgetSetImage.setEnabled(false);
                this.widgetCaptureImage.setEnabled(false);
            }
        }
    }

    public String getWidgetName() {
        return this.widgetNameText.getText();
    }

    public void setWidgetName(String name) {
        if (name == null) {
            this.widgetNameText.setText(L10N.get("FE.NA", "n/a"));
        } else {
            this.widgetNameText.setText(name);
        }
    }

    public void requestRename() {
        if (this.widgetNameText.isEnabled()) {
            this.widgetNameText.setFocus();
            this.widgetNameText.setSelection(0, this.widgetNameText.getCharCount());
        }
    }

    public String getWidgetTitle() {
        return this.widgetTitleText.getText();
    }

    public void setWidgetTitle(String title) {
        if (title == null) {
            this.widgetTitleText.setText(L10N.get("FE.NA", "n/a"));
        } else {
            this.widgetTitleText.setText(title);
        }
    }

    public WidgetType getWidgetType() {
        return this.currentNewWidgetType;
    }

    public void setWidgetType(WidgetType widget) {
        if (widget != null) {
            this.widgetTypeLabel.setText(widget.toString());
        } else {
            this.widgetTypeLabel.setText("n/a");
        }
    }

    public ShapeType getWidgetShape() {
        return ShapeType.Rectangle;
    }

    public void setWidgetShape(ShapeType shape) {
    }

    public void setWidgetImage(byte[] image) {
        if (image == null) {
            this.widgetRemoveImage.setEnabled(false);
        } else {
            this.widgetRemoveImage.setEnabled(image.length > 0);
        }
    }

    public MenuUtil.MenuItemDefinition[][] getContextMenuDefinitions() {
        return CONTEXT_DEFS;
    }

    public void showBlankSpaceMenu() {
        this.contextMenus.setContextSelection(false);
        this.contextMenus.getMenu(0).setVisible(true);
    }

    public void showSelectionMenu(boolean context) {
        this.contextMenus.setContextSelection(context);
        this.contextMenus.getMenu(1).setVisible(true);
    }

    public void setIsBackgroundAvailable(boolean capture) {
        this.isBackgroundAvailable = capture;
    }

    public void setStatusMessage(String message) {
        this.editor.setStatusMessage(message);
    }

    public void setStatusMessage(String message, int duration) {
        this.editor.setStatusMessage(message, duration);
    }

    protected class WidgetTextChangeHandler
    extends SelectionAdapter
    implements FocusListener {
        protected CogToolLID lid;
        protected boolean notActive = true;

        public WidgetTextChangeHandler(CogToolLID setLid) {
            if (setLid == null) {
                throw new InvalidParameterException("Cannot create a widgetTextChangeHandler with a null lid");
            }
            this.lid = setLid;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleEvent((EventObject)e);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.handleEvent((EventObject)e);
        }

        protected void handleEvent(EventObject e) {
            if (FrameEditorView.this.isPerformingAction() || FrameEditorView.this.selection.getWidgetSelectionCount() == 0) {
                return;
            }
            if (this.notActive) {
                this.notActive = false;
                FrameEditorView.this.performAction(this.lid);
                this.notActive = true;
            }
        }
    }
}

