/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.IFlatDraw2DMouseListener;
import edu.cmu.cs.hcii.cogtool.util.IFlatDraw2DMouseMotionListener;
import edu.cmu.cs.hcii.cogtool.util.IZoomable;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.MenuUtil;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.AView;
import edu.cmu.cs.hcii.cogtool.view.ActionPropertySet;
import edu.cmu.cs.hcii.cogtool.view.IActionPropertySet;
import edu.cmu.cs.hcii.cogtool.view.IDesignEditorView;
import edu.cmu.cs.hcii.cogtool.view.IScalableFigure;
import edu.cmu.cs.hcii.cogtool.view.InteractionDrawingEditor;
import edu.cmu.cs.hcii.cogtool.view.MenuFactory;
import edu.cmu.cs.hcii.cogtool.view.Palette;
import java.util.Arrays;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DesignEditorView
extends AView
implements IDesignEditorView {
    protected static final int PROPERTIES_PANE_WIDTH = OSUtils.MACOSX ? 230 : 220;
    protected static final int PALETTE_WIDTH = 30;
    public static final String KEYBOARD_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/Keyboard.gif";
    public static final String MOUSE_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/Mouse.gif";
    public static final String TOUCHSCREEN_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/Graffiti.gif";
    public static final String DEFAULT_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/Default.gif";
    public static final String VOICE_ICON_RESOURCE = "edu/cmu/cs/hcii/cogtool/resources/toolbar/Voice.gif";
    protected InteractionDrawingEditor editor;
    protected IDesignEditorUI.ActionProperties properties;
    protected ActionPropertySet propSet;
    protected Palette.ButtonListener setCurrentNewDeviceType = new Palette.ButtonListener(){

        public void widgetSelected(SelectionEvent evt) {
            super.widgetSelected(evt);
            Button pushedBtn = (Button)evt.getSource();
            DesignEditorView.this.propSet.setCurrentDeviceType((DeviceType)pushedBtn.getData());
            DesignEditorView.this.setStatusMessage(pushedBtn.getToolTipText());
        }
    };
    static final int mouseDeviceSet = DeviceType.buildDeviceSet(Arrays.asList(DeviceType.Mouse));
    static final int keyboardDeviceSet = DeviceType.buildDeviceSet(Arrays.asList(DeviceType.Keyboard));
    static final int voiceDeviceSet = DeviceType.buildDeviceSet(Arrays.asList(DeviceType.Voice));
    static final int graffitiDeviceSet = DeviceType.buildDeviceSet(Arrays.asList(DeviceType.Touchscreen));
    protected static final int STANDARD_MENU = 0;
    protected static final int FRAME_MENU = 1;
    protected static final int TRANSITION_MENU = 2;
    protected static final MenuUtil.MenuItemDefinition[] STANDARD_ITEMS = new MenuUtil.MenuItemDefinition[]{MenuFactory.PASTE, MenuFactory.SELECT_ALL, MenuUtil.SEPARATOR, MenuFactory.NEW_FRAME, MenuUtil.SEPARATOR, MenuFactory.SKIN_CASCADE, MenuUtil.SEPARATOR, MenuFactory.ZOOM_IN, MenuFactory.ZOOM_OUT, MenuFactory.ZOOM_NORMAL, MenuFactory.ZOOM_FIT};
    protected static final MenuUtil.MenuItemDefinition[] FRAME_ITEMS = new MenuUtil.MenuItemDefinition[]{MenuFactory.CUT, MenuFactory.COPY, MenuFactory.DELETE, MenuUtil.SEPARATOR, MenuFactory.EDIT, MenuFactory.RENAME, MenuUtil.SEPARATOR, MenuFactory.SKIN_CASCADE, MenuFactory.SET_BACKGROUND_IMAGE, MenuFactory.REMOVE_BACKGROUND_IMAGE, MenuUtil.SEPARATOR, MenuFactory.NUDGE_CASCADE};
    protected static final MenuUtil.MenuItemDefinition[] TRANSITION_ITEMS = new MenuUtil.MenuItemDefinition[]{MenuFactory.CUT, MenuFactory.COPY, MenuFactory.DELETE, MenuUtil.SEPARATOR, MenuFactory.EDIT};

    public DesignEditorView(int deviceTypes, ListenerIdentifierMap lIDMap, ListenerIdentifier.ILIDTransmuter transformer, MenuFactory.IWindowMenuData menuData, IScalableFigure contents, IFlatDraw2DMouseMotionListener motionL, IFlatDraw2DMouseListener clickL, IZoomable zoomer, Rectangle loc) {
        super(DesignEditorView.createShell(loc), lIDMap, transformer, menuData);
        this.editor = new InteractionDrawingEditor(contents, motionL, clickL, zoomer, (Composite)this.getShell(), PROPERTIES_PANE_WIDTH, 131072, 30, new Cursor((Device)WindowUtil.globalDisplay, 0), new Color(null, 255, 255, 204));
        this.layOutPalette(deviceTypes, this.editor.paletteComposite);
        int actionPropertiesUseWhich = -1;
        if (DeviceType.intersects(deviceTypes, mouseDeviceSet)) {
            actionPropertiesUseWhich = 0;
        } else if (DeviceType.intersects(deviceTypes, keyboardDeviceSet)) {
            actionPropertiesUseWhich = 2;
        } else if (DeviceType.intersects(deviceTypes, voiceDeviceSet)) {
            actionPropertiesUseWhich = 1;
        } else if (DeviceType.intersects(deviceTypes, graffitiDeviceSet)) {
            actionPropertiesUseWhich = 3;
        }
        this.properties = new IDesignEditorUI.ActionProperties(actionPropertiesUseWhich);
        this.propSet = new ActionPropertySet(deviceTypes, this.editor.propertiesComposite, true, this);
        this.propSet.layOutPropertiesPane();
        this.propSet.setProperties(this.properties, 5);
        this.shell.setMinimumSize(350, 320);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent evt) {
                ((Shell)evt.widget).setFocus();
                super.shellClosed(evt);
            }
        });
    }

    protected void layOutPalette(int deviceTypes, Palette parent) {
        String defaultActionToolTip = L10N.get("DEV.UseDefaultTransitionType", "Use default transition type");
        Image icon = GraphicsUtil.getImageFromResource(DEFAULT_ICON_RESOURCE);
        Button lastButton = parent.createPaletteButton(icon, null, parent, IDesignEditorUI.BASE_ACTION_ON_SOURCE, this.setCurrentNewDeviceType, defaultActionToolTip);
        if (DeviceType.Mouse.isMember(deviceTypes)) {
            icon = GraphicsUtil.getImageFromResource(MOUSE_ICON_RESOURCE);
            lastButton = parent.createPaletteButton(icon, (Control)lastButton, parent, DeviceType.Mouse, this.setCurrentNewDeviceType, L10N.get("DEV.UseMouseTransitionType", "Use mouse transition"));
        }
        if (DeviceType.Keyboard.isMember(deviceTypes)) {
            icon = GraphicsUtil.getImageFromResource(KEYBOARD_ICON_RESOURCE);
            lastButton = parent.createPaletteButton(icon, (Control)lastButton, parent, DeviceType.Keyboard, this.setCurrentNewDeviceType, L10N.get("DEV.UseKeyboardTransitionType", "Use keyboard transition"));
        }
        if (DeviceType.Touchscreen.isMember(deviceTypes)) {
            icon = GraphicsUtil.getImageFromResource(TOUCHSCREEN_ICON_RESOURCE);
            lastButton = parent.createPaletteButton(icon, (Control)lastButton, parent, DeviceType.Touchscreen, this.setCurrentNewDeviceType, L10N.get("DEV.UseTouchscreenTransitionType", "Use touchscreen transition"));
        }
        if (DeviceType.Voice.isMember(deviceTypes)) {
            icon = GraphicsUtil.getImageFromResource(VOICE_ICON_RESOURCE);
            lastButton = parent.createPaletteButton(icon, (Control)lastButton, parent, DeviceType.Voice, this.setCurrentNewDeviceType, L10N.get("DEV.UseVoiceTransitionType", "Use voice transition"));
        }
        this.setStatusMessage(defaultActionToolTip);
    }

    protected static Shell createShell(Rectangle loc) {
        return DesignEditorView.createShell(loc, 720, 600, (Layout)new FillLayout());
    }

    protected MenuFactory.MenuType[] neededMenus() {
        return new MenuFactory.MenuType[]{MenuFactory.MenuType.FileMenu, MenuFactory.MenuType.EditMenu, MenuFactory.MenuType.CreateMenu, MenuFactory.MenuType.CanvasModifyMenu, MenuFactory.MenuType.WindowMenu, MenuFactory.MenuType.HelpMenu};
    }

    public InteractionDrawingEditor getEditor() {
        return this.editor;
    }

    public DeviceType getDeviceType() {
        return this.propSet.getCurrentDeviceType();
    }

    public MenuUtil.MenuItemDefinition[][] getContextMenuDefinitions() {
        return new MenuUtil.MenuItemDefinition[][]{STANDARD_ITEMS, FRAME_ITEMS, TRANSITION_ITEMS};
    }

    public void showStandardMenu() {
        this.contextMenus.setContextSelection(false);
        this.contextMenus.getMenu(0).setVisible(true);
    }

    public void showFrameMenu(boolean context) {
        this.contextMenus.setContextSelection(context);
        this.contextMenus.getMenu(1).setVisible(true);
    }

    public void showTransitionMenu(boolean context) {
        this.contextMenus.setContextSelection(context);
        this.contextMenus.getMenu(2).setVisible(true);
    }

    public IActionPropertySet getActionPropertySet() {
        return this.propSet;
    }

    public IDesignEditorUI.ActionProperties getActionProperties() {
        this.propSet.getProperties(this.properties);
        return this.properties;
    }

    public void setStatusMessage(String message) {
        this.editor.setStatusMessage(message);
    }

    public void setStatusMessage(String message, int duration) {
        this.editor.setStatusMessage(message, duration);
    }

    public void getDefaultProperties(IDesignEditorUI.ActionProperties p) {
        p.copyValues(this.propSet.getDefaultProperties());
    }
}

