/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.MenuUtil;
import edu.cmu.cs.hcii.cogtool.util.RcvrUIException;
import java.util.List;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class ContextMenuManager
extends MenuAdapter
implements Listener {
    protected boolean contextSelection = false;
    protected Menu[] menus;
    protected ListenerIdentifierMap lidMap;
    protected ListenerIdentifier.ILIDTransmuter transmuter;
    protected Menu dynamicMenu = null;
    protected Shell shell;

    public ContextMenuManager(Shell inShell, ListenerIdentifierMap lid, ListenerIdentifier.ILIDTransmuter muter, MenuUtil.MenuItemDefinition[][] items) {
        this.lidMap = lid;
        this.transmuter = muter;
        this.shell = inShell;
        this.menus = this.buildMenuList(items);
    }

    protected Menu[] buildMenuList(MenuUtil.MenuItemDefinition[][] items) {
        Menu[] menusList = new Menu[items.length];
        for (int i = 0; i < menusList.length; ++i) {
            menusList[i] = MenuUtil.createMenu(this.shell, 8, items[i], ListenerIdentifierMap.CONTEXT, this, this.lidMap);
            menusList[i].addMenuListener((MenuListener)this);
        }
        return menusList;
    }

    public Menu createDynamicMenu(List items) {
        if (this.dynamicMenu != null) {
            this.dynamicMenu.removeMenuListener((MenuListener)this);
            this.dynamicMenu.dispose();
            this.dynamicMenu = null;
        }
        MenuUtil.MenuItemDefinition[] menuItems = items.toArray(new MenuUtil.MenuItemDefinition[0]);
        this.dynamicMenu = MenuUtil.createMenu(this.shell, 8, menuItems, ListenerIdentifierMap.CONTEXT, this, this.lidMap);
        this.dynamicMenu.addMenuListener((MenuListener)this);
        return this.dynamicMenu;
    }

    public void setContextSelection(boolean isContext) {
        this.contextSelection = isContext;
    }

    public Menu getMenu(int index) {
        try {
            return this.menus[index];
        }
        catch (Exception e) {
            throw new RcvrUIException("Tried to show nonexistent menu", e);
        }
    }

    public void handleEvent(Event e) {
        this.transmuter.performAction((ListenerIdentifier)e.widget.getData(), this.contextSelection);
    }

    public void menuHidden(MenuEvent evt) {
        this.transmuter.cleanup(false, true);
    }

    public void dispose() {
    }
}

