/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.KeyPressType;
import edu.cmu.cs.hcii.cogtool.model.MouseButtonState;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.TapPressType;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI;
import edu.cmu.cs.hcii.cogtool.uimodel.KeyDisplayUtil;
import edu.cmu.cs.hcii.cogtool.util.ComboWithEnableFix;
import edu.cmu.cs.hcii.cogtool.util.FontUtils;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.TextWithEnableFix;
import edu.cmu.cs.hcii.cogtool.view.IActionSet;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class ActionSet
implements IActionSet {
    protected Composite actionSettings;
    protected StackLayout actionSettingsLayout = new StackLayout();
    protected Composite mouseParms = null;
    protected Composite touchParms = null;
    protected Composite graffitiParms = null;
    protected Composite keyboardParms = null;
    protected Composite voiceParms = null;
    protected Combo mouseButtonCombo = null;
    protected Combo mouseActionCombo = null;
    protected Combo touchActionCombo = null;
    protected int mouseOverIndex = MousePressType.DISPLAY.length;
    protected int touchOverIndex = TapPressType.DISPLAY.length;
    protected ActionModifierSet buttonModifierSet = null;
    protected Text graffitiText = null;
    protected Button graffitiIsCmd = null;
    protected Text keyboardText = null;
    protected Button keyboardIsCmd = null;
    protected Combo keyboardActionCombo = null;
    protected KeyboardSpecialChars keyboardSpecials = null;
    protected Text voiceText = null;
    protected Button voiceIsCmd = null;
    protected Label mouseButtonLabel = null;
    protected Label mouseActionLabel = null;
    protected Label touchActionLabel = null;
    protected Label graffitiTextLabel = null;
    protected Label voiceTextLabel = null;
    protected Label keyboardAcceptableKeyLabel = null;
    protected Label keyboardTextLabel = null;
    protected Label keyboardActionLabel = null;
    protected Label propLabel = null;
    protected boolean vertical;
    protected int deviceTypes;
    protected Composite parent;
    protected FormAttachment leftAttachment = new FormAttachment(0, 5);
    protected static final String SHIFT_LABEL = L10N.get("DE.SHIFT", "Shift");
    protected static final String CTRL_LABEL = L10N.get("DE.CTRL", "Ctrl");
    protected static final String ALT_LABEL = L10N.get("DE.ALT", "Alt");
    protected static final String COMMAND_LABEL = L10N.get("DE.COMMAND", "Cmd");
    protected static final String FUNCTION_LABEL = L10N.get("DE.FUNCTION", "Fn");
    protected static final String RETURN_LABEL = L10N.get("DE.RETURN", "Enter");
    protected static final String ESCAPE_LABEL = L10N.get("DE.ESCAPE", "Esc");
    protected static final String TAB_LABEL = L10N.get("DE.TAB", "Tab");
    protected static final String BACKSPACE_LABEL = L10N.get("DE.BACKSPACE", "BS");
    protected static final String DELETE_LABEL = L10N.get("DE.DELETE", "DEL");
    protected static final String CAPSLOCK_LABEL = L10N.get("DE.CAPSLOCK", "CapsLk");
    protected static final String MODIFIERS_LABEL = L10N.get("DE.ButtonModifiersCaption", "Modifiers");
    protected SelectionListener deviceActionChange = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent evt) {
            Control source = (Control)evt.getSource();
            source.forceFocus();
            if (source.isEnabled()) {
                ActionSet.this.performChangeDeviceAction();
            }
        }
    };
    protected SelectionListener widgetActionChange = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent evt) {
            Control source = (Control)evt.getSource();
            source.forceFocus();
            if (source.isEnabled()) {
                ActionSet.this.performChangeWidgetAction();
            }
            if (ActionSet.this.mouseButtonCombo != null) {
                if (ActionSet.this.getMousePressType() == MousePressType.Hover) {
                    ActionSet.this.mouseButtonCombo.setEnabled(false);
                    ActionSet.this.mouseButtonCombo.select(0);
                } else {
                    ActionSet.this.mouseButtonCombo.setEnabled(true);
                }
            }
        }
    };

    public ActionSet(int devTypes, Composite parentSpace, boolean vert) {
        this.deviceTypes = devTypes;
        this.parent = parentSpace;
        this.vertical = vert;
    }

    protected boolean performChangeWidgetAction() {
        return false;
    }

    protected boolean performChangeDeviceAction() {
        return false;
    }

    public void layOutPropertiesPane() {
        this.parent.setLayout((Layout)new FormLayout());
        this.layoutHelper();
        if (DeviceType.Mouse.isMember(this.deviceTypes)) {
            this.mouseParms = this.createMouseComposite();
            this.layOutMouseComposite();
        }
        if (DeviceType.Touchscreen.isMember(this.deviceTypes)) {
            this.touchParms = this.createTouchComposite();
            this.layOutTouchComposite();
            this.graffitiParms = this.createGraffitiComposite();
            this.layOutGraffitiComposite();
        }
        if (DeviceType.Keyboard.isMember(this.deviceTypes)) {
            this.keyboardParms = this.createKeyComposite();
            this.layOutKeyboardComposite();
        }
        if (DeviceType.Voice.isMember(this.deviceTypes)) {
            this.voiceParms = this.createVoiceComposite();
            this.layOutVoiceComposite();
        }
    }

    protected Composite createMouseComposite() {
        int i;
        Composite mouseComp = new Composite(this.actionSettings, 0);
        mouseComp.setLayout((Layout)new FormLayout());
        this.mouseButtonLabel = new Label(mouseComp, 0);
        this.mouseButtonLabel.setText(L10N.get("DE.MouseButtonCaption", "Mouse Button") + ":");
        this.mouseButtonCombo = new ComboWithEnableFix(mouseComp, 12);
        for (i = 0; i < MouseButtonState.DISPLAY.length; ++i) {
            this.mouseButtonCombo.add(MouseButtonState.DISPLAY[i].toString());
        }
        this.mouseButtonCombo.select(0);
        this.mouseButtonCombo.addSelectionListener(this.widgetActionChange);
        this.mouseActionLabel = new Label(mouseComp, 0);
        this.mouseActionLabel.setText(L10N.get("DE.ButtonActionCaption", "Action") + ":");
        this.mouseActionCombo = new ComboWithEnableFix(mouseComp, 12);
        for (i = 0; i < MousePressType.DISPLAY.length; ++i) {
            this.mouseActionCombo.add(MousePressType.DISPLAY[i].toString());
        }
        this.mouseActionCombo.select(0);
        this.mouseActionCombo.addSelectionListener(this.widgetActionChange);
        if (DeviceType.Keyboard.isMember(this.deviceTypes)) {
            this.buttonModifierSet = new ActionModifierSet((Control)this.mouseActionCombo, this.widgetActionChange, this.vertical);
        }
        return mouseComp;
    }

    protected Composite createTouchComposite() {
        Composite touchComp = new Composite(this.actionSettings, 0);
        touchComp.setLayout((Layout)new FormLayout());
        this.touchActionLabel = new Label(touchComp, 0);
        this.touchActionLabel.setText(L10N.get("DE.ButtonActionCaption", "Action") + ":");
        this.touchActionCombo = new ComboWithEnableFix(touchComp, 12);
        for (int i = 0; i < TapPressType.DISPLAY.length; ++i) {
            this.touchActionCombo.add(TapPressType.DISPLAY[i].toString());
        }
        this.touchActionCombo.select(0);
        this.touchActionCombo.addSelectionListener(this.widgetActionChange);
        return touchComp;
    }

    protected Composite createKeyComposite() {
        Composite keyComp = new Composite(this.actionSettings, 0);
        keyComp.setLayout((Layout)new FormLayout());
        this.keyboardAcceptableKeyLabel = new Label(keyComp, 64);
        this.keyboardAcceptableKeyLabel.setText(IDesignEditorInteraction.LEGAL_KEYS_1 + IDesignEditorInteraction.LEGAL_KEYS_2);
        this.keyboardTextLabel = new Label(keyComp, 0);
        this.keyboardTextLabel.setText(L10N.get("DE.KeyboardTextCaption", "Text") + ":");
        this.keyboardText = new TextWithEnableFix(keyComp, 2052);
        this.keyboardText.setFont(FontUtils.SYMBOL_FONT);
        this.keyboardText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ActionSet.this.handleModifiedText();
            }
        });
        this.keyboardIsCmd = new Button(keyComp, 32);
        this.keyboardIsCmd.setText(L10N.get("DE.IsCommand", "Is Command"));
        this.keyboardIsCmd.addSelectionListener(this.deviceActionChange);
        SelectionListener insertSpecial = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Control source = (Control)e.getSource();
                ActionSet.this.keyboardText.insert((String)source.getData());
                ActionSet.this.keyboardText.setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        Object alignTo = this.vertical ? this.keyboardIsCmd : this.keyboardText;
        this.keyboardSpecials = new KeyboardSpecialChars((Control)alignTo, insertSpecial, this.vertical);
        return keyComp;
    }

    protected void handleModifiedText() {
        if (this.keyboardActionCombo != null) {
            int textLength = this.keyboardText.getText().length();
            if (textLength > 1) {
                this.keyboardActionCombo.select(0);
            }
            this.keyboardActionCombo.setEnabled(textLength == 1);
        }
    }

    protected Composite createGraffitiComposite() {
        Composite graffitiComp = new Composite(this.actionSettings, 0);
        graffitiComp.setLayout((Layout)new FormLayout());
        this.graffitiTextLabel = new Label(graffitiComp, 0);
        this.graffitiTextLabel.setText(L10N.get("DE.GraffitiTextCaption", "Graffiti\u00ae Gestures") + ":");
        this.graffitiText = new TextWithEnableFix(graffitiComp, 2052);
        this.graffitiIsCmd = new Button(graffitiComp, 32);
        this.graffitiIsCmd.setText(L10N.get("DE.IsCommand", "Is Command"));
        this.graffitiIsCmd.addSelectionListener(this.widgetActionChange);
        return graffitiComp;
    }

    protected Composite createVoiceComposite() {
        Composite voiceComp = new Composite(this.actionSettings, 0);
        voiceComp.setLayout((Layout)new FormLayout());
        this.voiceTextLabel = new Label(voiceComp, 0);
        this.voiceTextLabel.setText(L10N.get("DE.VoiceTextCaption", "Spoken Input") + ":");
        this.voiceText = new TextWithEnableFix(voiceComp, 2052);
        this.voiceIsCmd = new Button(voiceComp, 32);
        this.voiceIsCmd.setText(L10N.get("DE.IsCommand", "Is Command"));
        this.voiceIsCmd.addSelectionListener(this.deviceActionChange);
        return voiceComp;
    }

    protected abstract void layOutVoiceComposite();

    protected abstract void layOutKeyboardComposite();

    protected abstract void layOutGraffitiComposite();

    protected abstract void layOutTouchComposite();

    protected abstract void layOutMouseComposite();

    protected abstract void layoutHelper();

    public void getProperties(IDesignEditorUI.ActionProperties props) {
        if (this.isMouseSelected()) {
            props.useWhichParts = 0;
            props.mouseButton = this.getMouseButton();
            props.buttonAction = this.getMousePressType();
            if (props.buttonAction == MousePressType.Hover) {
                props.mouseButton = null;
            }
            if (this.buttonModifierSet != null) {
                props.buttonState = this.getMouseModifiers();
            }
        }
        if (this.isTouchSelected()) {
            props.useWhichParts = 4;
            props.tapAction = this.getTapPressType();
            if (this.buttonModifierSet != null) {
                props.buttonState = this.getMouseModifiers();
            }
        }
        if (this.isGraffitiSelected()) {
            props.useWhichParts = 3;
            props.graffitiString = this.getGraffitiString();
            props.graffitiIsCmd = this.isGraffitiCmd();
        }
        if (this.isKeyboardSelected()) {
            props.useWhichParts = 2;
            props.keyboardString = this.getKeyboardString();
            props.keyboardIsCmd = this.isKeyboardCmd();
            props.keyboardAction = this.getKeyboardPressType();
        }
        if (this.isVoiceSelected()) {
            props.useWhichParts = 1;
            props.voiceString = this.getVoiceString();
            props.voiceIsCmd = this.isVoiceCmd();
            if (this.buttonModifierSet != null) {
                props.buttonState = this.getMouseModifiers();
            }
        }
    }

    protected void setVoice(IDesignEditorUI.ActionProperties props) {
        if (props != null) {
            this.setVoiceString(props.voiceString);
            this.setVoiceIsCmd(props.voiceIsCmd);
        }
    }

    protected void setKeyboard(IDesignEditorUI.ActionProperties props) {
        if (props != null) {
            this.setKeyboardString(props.keyboardString);
            this.setKeyboardIsCmd(props.keyboardIsCmd);
            if (this.keyboardActionCombo != null) {
                if (props.keyboardString.length() > 1) {
                    this.keyboardActionCombo.select(0);
                    this.keyboardActionCombo.setEnabled(false);
                } else {
                    this.keyboardActionCombo.setEnabled(true);
                    this.setKeyboardPressType(props.keyboardAction);
                }
            }
        }
    }

    protected void setGraffiti(IDesignEditorUI.ActionProperties props) {
        if (props != null) {
            this.setGraffitiString(props.graffitiString);
            this.setGraffitiIsCmd(props.graffitiIsCmd);
        }
    }

    protected void setTap(IDesignEditorUI.ActionProperties props) {
        if (props != null && props.tapAction != null) {
            this.setTapPressType(props.tapAction);
        }
    }

    protected void enableTouchParameters(boolean enable) {
        if (this.touchActionCombo != null) {
            this.touchActionCombo.setEnabled(enable);
        }
    }

    protected String getGraffitiString() {
        return this.graffitiText.getText();
    }

    protected void setGraffitiString(String str) {
        if (this.graffitiText != null) {
            this.graffitiText.setText(str);
        }
    }

    protected String getKeyboardString() {
        return KeyDisplayUtil.convertDisplayToAction(this.keyboardText.getText());
    }

    protected void setKeyboardString(String s) {
        if (this.keyboardText != null) {
            Point selectedText = this.keyboardText.getSelection();
            this.keyboardText.setText(KeyDisplayUtil.convertActionToDisplay(s));
            this.keyboardText.setSelection(selectedText);
        }
    }

    protected String getVoiceString() {
        return this.voiceText.getText();
    }

    protected void setVoiceString(String str) {
        if (this.voiceText != null) {
            this.voiceText.setText(str);
        }
    }

    protected void enableMouseParameters(boolean enable) {
        if (this.mouseButtonCombo != null) {
            this.mouseButtonCombo.setEnabled(enable);
        }
        if (this.mouseActionCombo != null) {
            this.mouseActionCombo.setEnabled(enable);
        }
        if (this.buttonModifierSet != null) {
            this.buttonModifierSet.setEnabled(enable);
        }
    }

    protected boolean areMouseParametersEnabled() {
        return this.mouseActionCombo.getEnabled();
    }

    protected MouseButtonState getMouseButton() {
        return MouseButtonState.DISPLAY[this.mouseButtonCombo.getSelectionIndex()];
    }

    protected void setMouseButton(MouseButtonState button) {
        if (this.mouseButtonCombo != null && button != null) {
            for (int i = 0; i < MouseButtonState.DISPLAY.length; ++i) {
                if (!MouseButtonState.DISPLAY[i].equals(button)) continue;
                this.mouseButtonCombo.select(i);
                return;
            }
        }
    }

    protected MousePressType getMousePressType() {
        int selectedIndex = this.mouseActionCombo.getSelectionIndex();
        return MousePressType.DISPLAY[selectedIndex];
    }

    protected void setMousePressType(MousePressType action) {
        if (this.mouseActionCombo != null && action != null) {
            for (int i = 0; i < MousePressType.DISPLAY.length; ++i) {
                if (!MousePressType.DISPLAY[i].equals(action)) continue;
                this.mouseActionCombo.select(i);
                return;
            }
        }
    }

    protected TapPressType getTapPressType() {
        int selectedIndex = this.touchActionCombo.getSelectionIndex();
        return TapPressType.DISPLAY[selectedIndex];
    }

    protected void setTapPressType(TapPressType action) {
        if (this.touchActionCombo != null && action != null) {
            for (int i = 0; i < TapPressType.DISPLAY.length; ++i) {
                if (!TapPressType.DISPLAY[i].equals(action)) continue;
                this.touchActionCombo.select(i);
                return;
            }
        }
    }

    protected int getMouseModifiers() {
        if (this.buttonModifierSet != null) {
            return this.buttonModifierSet.getModifiers();
        }
        return 0;
    }

    protected void setMouseModifiers(int state) {
        if (this.buttonModifierSet != null) {
            this.buttonModifierSet.setModifiers(state);
        }
    }

    protected void enableGraffitiParameters(boolean enable) {
        if (this.graffitiText != null) {
            this.graffitiText.setEnabled(enable);
            this.graffitiIsCmd.setEnabled(enable);
        }
    }

    protected boolean areGraffitiParametersEnabled() {
        return this.graffitiText.getEnabled();
    }

    protected boolean isGraffitiCmd() {
        return this.graffitiIsCmd.getSelection();
    }

    protected void setGraffitiIsCmd(boolean isCmd) {
        if (this.graffitiIsCmd != null) {
            this.graffitiIsCmd.setSelection(isCmd);
        }
    }

    protected void enableKeyboardParameters(boolean enable) {
        if (this.keyboardText != null) {
            this.keyboardText.setEnabled(enable);
            this.keyboardIsCmd.setEnabled(enable);
            if (this.keyboardActionCombo != null) {
                if (this.keyboardText.getText().length() > 1) {
                    this.keyboardActionCombo.setEnabled(false);
                } else {
                    this.keyboardActionCombo.setEnabled(enable);
                }
            }
            this.keyboardSpecials.setEnabled(enable);
        }
    }

    protected boolean areKeyboardParametersEnabled() {
        return this.keyboardText.getEnabled();
    }

    protected boolean isKeyboardCmd() {
        return this.keyboardIsCmd.getSelection();
    }

    protected void setKeyboardIsCmd(boolean isCmd) {
        if (this.keyboardIsCmd != null) {
            this.keyboardIsCmd.setSelection(isCmd);
        }
    }

    protected KeyPressType getKeyboardPressType() {
        if (this.keyboardActionCombo == null) {
            return KeyPressType.Stroke;
        }
        return KeyPressType.DISPLAY[this.keyboardActionCombo.getSelectionIndex()];
    }

    protected void setKeyboardPressType(KeyPressType action) {
        if (this.keyboardActionCombo != null && action != null) {
            for (int i = 0; i < KeyPressType.DISPLAY.length; ++i) {
                if (!KeyPressType.DISPLAY[i].equals(action)) continue;
                this.keyboardActionCombo.select(i);
                return;
            }
        }
    }

    protected void enableVoiceParameters(boolean enable) {
        if (this.voiceText != null) {
            this.voiceText.setEnabled(enable);
            this.voiceIsCmd.setEnabled(enable);
        }
    }

    protected boolean areVoiceParametersEnabled() {
        return this.voiceText.getEnabled();
    }

    protected boolean isVoiceCmd() {
        return this.voiceIsCmd.getSelection();
    }

    protected void setVoiceIsCmd(boolean isCmd) {
        if (this.voiceIsCmd != null) {
            this.voiceIsCmd.setSelection(isCmd);
        }
    }

    protected void setMouse(IDesignEditorUI.ActionProperties props) {
        if (props != null && props.buttonAction != null) {
            this.setMouseButton(props.mouseButton);
            this.setMousePressType(props.buttonAction);
            this.setMouseModifiers(props.buttonState);
            if (props.buttonAction == MousePressType.Hover) {
                this.mouseButtonCombo.setEnabled(false);
                this.mouseButtonCombo.select(0);
            }
        }
    }

    public void setComposite(int device) {
        switch (device) {
            case 0: {
                this.actionSettingsLayout.topControl = this.mouseParms;
                break;
            }
            case 4: {
                this.actionSettingsLayout.topControl = this.touchParms;
                break;
            }
            case 3: {
                this.actionSettingsLayout.topControl = this.graffitiParms;
                break;
            }
            case 2: {
                this.actionSettingsLayout.topControl = this.keyboardParms;
                break;
            }
            case 1: {
                this.actionSettingsLayout.topControl = this.voiceParms;
            }
        }
    }

    public boolean isMouseSelected() {
        return this.actionSettingsLayout.topControl.equals(this.mouseParms);
    }

    public boolean isTouchSelected() {
        return this.actionSettingsLayout.topControl.equals(this.touchParms);
    }

    public boolean isKeyboardSelected() {
        return this.actionSettingsLayout.topControl.equals(this.keyboardParms);
    }

    public boolean isGraffitiSelected() {
        return this.actionSettingsLayout.topControl.equals(this.graffitiParms);
    }

    public boolean isVoiceSelected() {
        return this.actionSettingsLayout.topControl.equals(this.voiceParms);
    }

    public void setProperties(IDesignEditorUI.ActionProperties props, int mode) {
    }

    protected static class KeyboardSpecialChars {
        protected Button SHIFT;
        protected Button CTRL;
        protected Button ALT;
        protected Button COMMAND;
        protected Button FUNCTION;
        protected Button RETURN;
        protected Button ESCAPE;
        protected Button TAB;
        protected Button BACKSPACE;
        protected Button DELETE;
        protected Button CAPSLOCK;

        protected Button createButton(String label, String specialChar, Composite parent, Font labelFont, SelectionListener changeListener) {
            Button b = new Button(parent, 8);
            b.setText(label);
            b.setFont(labelFont);
            b.addSelectionListener(changeListener);
            b.setData((Object)specialChar);
            return b;
        }

        public KeyboardSpecialChars(Control alignTo, SelectionListener changeListener, boolean vertical) {
            FormData data;
            Composite parent = alignTo.getParent();
            this.SHIFT = this.createButton(SHIFT_LABEL + " (" + IActionSet.SHIFT_SYMBOL + ")", IActionSet.SHIFT_SYMBOL, parent, FontUtils.SYMBOL_FONT, changeListener);
            this.CTRL = this.createButton(CTRL_LABEL + " (" + IActionSet.CTRL_SYMBOL + ")", IActionSet.CTRL_SYMBOL, parent, FontUtils.SYMBOL_FONT, changeListener);
            this.ALT = this.createButton(ALT_LABEL + " (" + IActionSet.ALT_SYMBOL + ")", IActionSet.ALT_SYMBOL, parent, FontUtils.SYMBOL_FONT, changeListener);
            this.COMMAND = this.createButton(COMMAND_LABEL + " (" + IActionSet.COMMAND_SYMBOL + ")", IActionSet.COMMAND_SYMBOL, parent, FontUtils.SYMBOL_FONT, changeListener);
            this.FUNCTION = this.createButton(FUNCTION_LABEL + " (" + IActionSet.FUNCTION_SYMBOL + ")", IActionSet.FUNCTION_SYMBOL, parent, FontUtils.SYMBOL_FONT, changeListener);
            this.RETURN = this.createButton(RETURN_LABEL + " (" + IActionSet.RETURN_SYMBOL + ")", IActionSet.RETURN_SYMBOL, parent, FontUtils.SYMBOL_FONT, changeListener);
            this.ESCAPE = this.createButton(ESCAPE_LABEL + " (" + IActionSet.ESCAPE_SYMBOL + ")", IActionSet.ESCAPE_SYMBOL, parent, FontUtils.SYMBOL_FONT, changeListener);
            this.TAB = this.createButton(TAB_LABEL + " (" + IActionSet.TAB_SYMBOL + ")", IActionSet.TAB_SYMBOL, parent, FontUtils.SYMBOL_FONT, changeListener);
            this.BACKSPACE = this.createButton(BACKSPACE_LABEL + " (" + IActionSet.BACKSPACE_SYMBOL + ")", IActionSet.BACKSPACE_SYMBOL, parent, FontUtils.SYMBOL_FONT, changeListener);
            this.DELETE = this.createButton(DELETE_LABEL + " (" + IActionSet.DELETE_SYMBOL + ")", IActionSet.DELETE_SYMBOL, parent, FontUtils.SYMBOL_FONT, changeListener);
            this.CAPSLOCK = this.createButton(CAPSLOCK_LABEL + " (" + IActionSet.CAPSLOCK_SYMBOL + ")", IActionSet.CAPSLOCK_SYMBOL, parent, FontUtils.SYMBOL_FONT, changeListener);
            if (!vertical) {
                Label keybdModifiersLabel = new Label(parent, 0);
                keybdModifiersLabel.setText(MODIFIERS_LABEL + ":");
                data = new FormData();
                data.top = new FormAttachment((Control)this.SHIFT, 0, 0x1000000);
                data.left = new FormAttachment(0, 5);
                keybdModifiersLabel.setLayoutData((Object)data);
                Label keybdSpecialsLabel = new Label(parent, 0);
                keybdSpecialsLabel.setText(L10N.get("DE.SPECIALS", "Specials") + ':');
                data = new FormData();
                data.top = new FormAttachment((Control)this.RETURN, 0, 0x1000000);
                data.left = new FormAttachment(0, 5);
                keybdSpecialsLabel.setLayoutData((Object)data);
            }
            data = new FormData();
            data.top = new FormAttachment(alignTo, 5, 1024);
            data.left = new FormAttachment(alignTo, 5, 16384);
            if (vertical) {
                data.right = new FormAttachment(50, -5);
            }
            this.SHIFT.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.SHIFT, 5, 1024);
                data.left = new FormAttachment(alignTo, 0, 16384);
                data.right = new FormAttachment(50, -5);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 0, 0x1000000);
                data.left = new FormAttachment((Control)this.SHIFT, 5, 131072);
            }
            this.CTRL.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.CTRL, 5, 1024);
                data.left = new FormAttachment(alignTo, 0, 16384);
                data.right = new FormAttachment(50, -5);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 0, 0x1000000);
                data.left = new FormAttachment((Control)this.CTRL, 5, 131072);
            }
            this.ALT.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.ALT, 5, 1024);
                data.left = new FormAttachment(alignTo, 0, 16384);
                data.right = new FormAttachment(50, -5);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 0, 0x1000000);
                data.left = new FormAttachment((Control)this.ALT, 5, 131072);
            }
            this.COMMAND.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.COMMAND, 5, 1024);
                data.left = new FormAttachment(alignTo, 0, 16384);
                data.right = new FormAttachment(50, -5);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 0, 0x1000000);
                data.left = new FormAttachment((Control)this.COMMAND, 5, 131072);
            }
            this.FUNCTION.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment(alignTo, 5, 1024);
                data.left = new FormAttachment(50, 0);
                data.right = new FormAttachment(100, -5);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 5, 1024);
                data.left = new FormAttachment(alignTo, 5, 16384);
            }
            this.RETURN.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.RETURN, 5, 1024);
                data.left = new FormAttachment(50, 0);
                data.right = new FormAttachment(100, -5);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 5, 1024);
                data.left = new FormAttachment((Control)this.RETURN, 5, 131072);
            }
            this.ESCAPE.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.ESCAPE, 5, 1024);
                data.left = new FormAttachment(50, 0);
                data.right = new FormAttachment(100, -5);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 5, 1024);
                data.left = new FormAttachment((Control)this.ESCAPE, 5, 131072);
            }
            this.TAB.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.TAB, 5, 1024);
                data.left = new FormAttachment(50, 0);
                data.right = new FormAttachment(100, -5);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 5, 1024);
                data.left = new FormAttachment((Control)this.TAB, 5, 131072);
            }
            this.BACKSPACE.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.BACKSPACE, 5, 1024);
                data.left = new FormAttachment(50, 0);
                data.right = new FormAttachment(100, -5);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 5, 1024);
                data.left = new FormAttachment((Control)this.BACKSPACE, 5, 131072);
            }
            this.DELETE.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.DELETE, 5, 1024);
                data.left = new FormAttachment(50, 0);
                data.right = new FormAttachment(100, -5);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 5, 1024);
                data.left = new FormAttachment((Control)this.DELETE, 5, 131072);
            }
            this.CAPSLOCK.setLayoutData((Object)data);
        }

        public void setEnabled(boolean enable) {
            this.SHIFT.setEnabled(enable);
            this.CTRL.setEnabled(enable);
            this.ALT.setEnabled(enable);
            this.COMMAND.setEnabled(enable);
            this.FUNCTION.setEnabled(enable);
            this.RETURN.setEnabled(enable);
            this.ESCAPE.setEnabled(enable);
            this.TAB.setEnabled(enable);
            this.BACKSPACE.setEnabled(enable);
            this.DELETE.setEnabled(enable);
            this.CAPSLOCK.setEnabled(enable);
        }
    }

    protected static class ActionModifierSet {
        protected Button SHIFT;
        protected Button CTRL;
        protected Button ALT;
        protected Button COMMAND;
        protected Button FUNCTION;

        protected Button createButton(String label, Composite parent, SelectionListener changeListener) {
            Button b = new Button(parent, 32);
            b.setText(label);
            b.addSelectionListener(changeListener);
            return b;
        }

        public ActionModifierSet(Control alignTo, SelectionListener changeListener, boolean vertical) {
            Composite parent = alignTo.getParent();
            this.SHIFT = this.createButton(SHIFT_LABEL, parent, changeListener);
            this.CTRL = this.createButton(CTRL_LABEL, parent, changeListener);
            this.ALT = this.createButton(ALT_LABEL, parent, changeListener);
            this.COMMAND = this.createButton(COMMAND_LABEL, parent, changeListener);
            this.FUNCTION = this.createButton(FUNCTION_LABEL, parent, changeListener);
            Label buttonStateLabel = new Label(parent, 0);
            buttonStateLabel.setText(MODIFIERS_LABEL + ":");
            FormData data = new FormData();
            data.top = vertical ? new FormAttachment(alignTo, 5, 1024) : new FormAttachment((Control)this.SHIFT, 0, 0x1000000);
            data.left = new FormAttachment(0, 5);
            buttonStateLabel.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)buttonStateLabel, 0, 0x1000000);
                data.left = new FormAttachment((Control)buttonStateLabel, 5, 131072);
            } else {
                data.top = new FormAttachment(alignTo, 7, 1024);
                data.left = new FormAttachment(alignTo, 0, 16384);
            }
            this.SHIFT.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.SHIFT, 5, 1024);
                data.left = new FormAttachment((Control)this.SHIFT, 0, 16384);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 0, 0x1000000);
                data.left = new FormAttachment((Control)this.SHIFT, 5, 131072);
            }
            this.CTRL.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.CTRL, 5, 1024);
                data.left = new FormAttachment((Control)this.SHIFT, 0, 16384);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 0, 0x1000000);
                data.left = new FormAttachment((Control)this.CTRL, 5, 131072);
            }
            this.ALT.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.ALT, 5, 1024);
                data.left = new FormAttachment((Control)this.SHIFT, 0, 16384);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 0, 0x1000000);
                data.left = new FormAttachment((Control)this.ALT, 5, 131072);
            }
            this.COMMAND.setLayoutData((Object)data);
            data = new FormData();
            if (vertical) {
                data.top = new FormAttachment((Control)this.COMMAND, 5, 1024);
                data.left = new FormAttachment((Control)this.SHIFT, 0, 16384);
            } else {
                data.top = new FormAttachment((Control)this.SHIFT, 0, 0x1000000);
                data.left = new FormAttachment((Control)this.COMMAND, 5, 131072);
            }
            this.FUNCTION.setLayoutData((Object)data);
        }

        public void setEnabled(boolean enable) {
            this.SHIFT.setEnabled(enable);
            this.CTRL.setEnabled(enable);
            this.ALT.setEnabled(enable);
            this.COMMAND.setEnabled(enable);
            this.FUNCTION.setEnabled(enable);
        }

        public void setModifiers(int state) {
            this.SHIFT.setSelection((state & 1) != 0);
            this.CTRL.setSelection((state & 2) != 0);
            this.ALT.setSelection((state & 4) != 0);
            this.COMMAND.setSelection((state & 8) != 0);
            this.FUNCTION.setSelection((state & 0x10) != 0);
        }

        public int getModifiers() {
            int state = 0;
            if (this.SHIFT.getSelection()) {
                state |= 1;
            }
            if (this.CTRL.getSelection()) {
                state |= 2;
            }
            if (this.ALT.getSelection()) {
                state |= 4;
            }
            if (this.COMMAND.getSelection()) {
                state |= 8;
            }
            if (this.FUNCTION.getSelection()) {
                state |= 0x10;
            }
            return state;
        }
    }
}

