/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.KeyPressType;
import edu.cmu.cs.hcii.cogtool.model.MouseButtonState;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.TapPressType;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorLID;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI;
import edu.cmu.cs.hcii.cogtool.ui.SingleFrameSelection;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.TextWithEnableFix;
import edu.cmu.cs.hcii.cogtool.view.AView;
import edu.cmu.cs.hcii.cogtool.view.ActionSet;
import edu.cmu.cs.hcii.cogtool.view.IActionPropertySet;
import java.util.EventObject;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ActionPropertySet
extends ActionSet
implements IActionPropertySet {
    protected static final String nameLabel = L10N.get("APS.NameLabel", "Name") + ":";
    protected static final String setBackgroundImageLabel = L10N.get("APS.SetBackgroundImage", "Set Background Image");
    protected static final String removeBackgroundImageLabel = L10N.get("APS.RemoveBackgroundImage", "Remove Background Image");
    protected static final String setWidgetColorLabel = L10N.get("APS.SetWidgetColor", "Set Widget Layer Color");
    protected static final String setAsDefaultLabel = L10N.get("APS.SetAsDefault", "Set As Default");
    protected static final String restoreDefaultsLabel = L10N.get("APS.RestoreDefaults", "Restore Defaults");
    protected static final String editLabel = L10N.get("APS.Edit", "Edit");
    protected static final String transitionPropertiesLabel = L10N.get("APS.TransitionProperties", "Transition Properties");
    protected static final String framePropertiesLabel = L10N.get("APS.FrameProperties", "Frame Properties");
    protected static final String propertiesLabel = L10N.get("APS.Properties", "Properties");
    protected static final String nothingSelectedText = L10N.get("APS.NothingSelected", "Nothing selected.");
    protected static final String noActionAvailableText = L10N.get("APS.NoActionAvailable", "No action available when multiple transitions are selected.");
    protected static final String notApplicable = L10N.get("APS.NotApplicable", "n/a");
    protected Composite emptyParms;
    protected Composite frameParms;
    protected Composite multTransParms;
    protected Button setAsDefaultMouse;
    protected Button setAsDefaultTouch;
    protected Button setAsDefaultVoice;
    protected Button setAsDefaultKeyboard;
    protected Button setAsDefaultGraffiti;
    protected Button restoreDefaultsMouse;
    protected Button restoreDefaultsTouch;
    protected Button restoreDefaultsVoice;
    protected Button restoreDefaultsKeyboard;
    protected Button restoreDefaultsGraffiti;
    protected Button editMouse;
    protected Button editTouch;
    protected Button editVoice;
    protected Button editKeyboard;
    protected Button editGraffiti;
    protected Label frameNameLabel;
    protected Text frameName;
    protected Button setFrameImage;
    protected Button removeFrameImage;
    protected Button setFrameWidgetColor;
    protected AView view;
    protected DeviceType currentDeviceType = IDesignEditorUI.BASE_ACTION_ON_SOURCE;
    protected IDesignEditorUI.ActionProperties defaultProperties = new IDesignEditorUI.ActionProperties(0);
    public static IDesignEditorUI.ActionProperties originalProperties = new IDesignEditorUI.ActionProperties(0);

    public ActionPropertySet(int devTypes, Composite parentSpace, boolean vert, AView v) {
        super(devTypes, parentSpace, vert);
        this.view = v;
    }

    protected void resetVoice() {
        this.setVoiceIsCmd(ActionPropertySet.originalProperties.voiceIsCmd);
        this.setVoiceString(ActionPropertySet.originalProperties.voiceString);
    }

    protected void resetGraffiti() {
        this.setGraffitiIsCmd(ActionPropertySet.originalProperties.graffitiIsCmd);
        this.setGraffitiString(ActionPropertySet.originalProperties.graffitiString);
    }

    protected void resetKeyboard() {
        this.setKeyboardIsCmd(ActionPropertySet.originalProperties.keyboardIsCmd);
        this.setKeyboardString(ActionPropertySet.originalProperties.keyboardString);
        this.setKeyboardPressType(ActionPropertySet.originalProperties.keyboardAction);
    }

    protected void resetTouch() {
        this.setTapPressType(ActionPropertySet.originalProperties.tapAction);
    }

    protected void resetMouse() {
        this.setMouseButton(ActionPropertySet.originalProperties.mouseButton);
        this.setMouseModifiers(ActionPropertySet.originalProperties.buttonState);
        this.setMousePressType(ActionPropertySet.originalProperties.buttonAction);
        this.mouseButtonCombo.setEnabled(true);
    }

    protected void enableSetDefaultButtons() {
        if (this.isMouseSelected()) {
            this.setAsDefaultMouse.setEnabled(this.isMouseChanged(this.defaultProperties));
        } else if (this.isTouchSelected()) {
            this.setAsDefaultTouch.setEnabled(this.isTouchChanged(this.defaultProperties));
        } else if (this.isKeyboardSelected()) {
            this.setAsDefaultKeyboard.setEnabled(this.isKeyboardChanged(this.defaultProperties));
        } else if (this.isGraffitiSelected()) {
            this.setAsDefaultGraffiti.setEnabled(this.isGraffitiChanged(this.defaultProperties));
        } else if (this.isVoiceSelected()) {
            this.setAsDefaultVoice.setEnabled(this.isVoiceChanged(this.defaultProperties));
        }
    }

    protected boolean performChangeWidgetAction() {
        boolean b = this.view.performAction(DesignEditorLID.ChangeWidgetAction);
        this.enableSetDefaultButtons();
        return b;
    }

    protected boolean performChangeDeviceAction() {
        boolean b = this.view.performAction(DesignEditorLID.ChangeDeviceAction);
        this.enableSetDefaultButtons();
        return b;
    }

    protected Composite createFrameComposite() {
        Composite frameComp = new Composite(this.actionSettings, 0);
        frameComp.setLayout((Layout)new FormLayout());
        this.frameNameLabel = new Label(frameComp, 0);
        this.frameNameLabel.setText(nameLabel);
        FrameNameStringChangeHandler handler = new FrameNameStringChangeHandler();
        this.frameName = new TextWithEnableFix(frameComp, 2052);
        this.frameName.addSelectionListener((SelectionListener)handler);
        this.frameName.addFocusListener((FocusListener)handler);
        this.setFrameImage = new Button(frameComp, 8);
        this.setFrameImage.setText(setBackgroundImageLabel);
        this.setFrameImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ActionPropertySet.this.performSetFrameImageAction();
            }
        });
        this.removeFrameImage = new Button(frameComp, 8);
        this.removeFrameImage.setText(removeBackgroundImageLabel);
        this.removeFrameImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ActionPropertySet.this.performRemoveFrameImageAction();
            }
        });
        this.enableRemoveImage(false);
        this.setFrameWidgetColor = new Button(frameComp, 8);
        this.setFrameWidgetColor.setText(setWidgetColorLabel);
        this.setFrameWidgetColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ActionPropertySet.this.performSetWidgetColorAction();
            }
        });
        return frameComp;
    }

    protected void performSetFrameImageAction() {
        if (this.view.performAction(DesignEditorLID.SetBackgroundImage)) {
            this.enableRemoveImage(true);
        }
    }

    protected void performRemoveFrameImageAction() {
        this.view.performAction(DesignEditorLID.RemoveBackgroundImage);
        this.enableRemoveImage(false);
    }

    protected void performSetWidgetColorAction() {
        this.view.performAction(DesignEditorLID.SetWidgetColor);
    }

    protected void performRenameFrameAction() {
        IFrame frame = (IFrame)this.frameName.getData();
        IDesignEditorUI.FrameRenameEvent evt = new IDesignEditorUI.FrameRenameEvent(frame, this.frameName.getText(), new SingleFrameSelection(frame));
        this.view.performAction(DesignEditorLID.RenameFrame, evt, true);
    }

    protected void layOutMouseComposite() {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = this.leftAttachment;
        this.mouseButtonLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.mouseButtonLabel, 5);
        data.left = this.leftAttachment;
        data.right = new FormAttachment(100, -5);
        this.mouseButtonCombo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.mouseButtonCombo, 5);
        data.left = this.leftAttachment;
        this.mouseActionLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = this.leftAttachment;
        data.top = new FormAttachment((Control)this.mouseActionLabel, 5);
        data.right = new FormAttachment(100, -5);
        this.mouseActionCombo.setLayoutData((Object)data);
        SetResetDefaultsListener setResetListener = new SetResetDefaultsListener(this.setAsDefaultMouse, this.restoreDefaultsMouse, this.editMouse){

            protected boolean haveValuesChanged() {
                return ActionPropertySet.this.isMouseChanged(originalProperties);
            }

            protected void setDefaults(boolean isReset) {
                MousePressType mpt = ActionPropertySet.this.getMousePressType();
                MouseButtonState mbs = mpt != MousePressType.Hover ? ActionPropertySet.this.getMouseButton() : null;
                int mods = ActionPropertySet.this.getMouseModifiers();
                ActionPropertySet.this.setMouseDefaults(mbs, mpt, mods);
            }

            protected void resetDefaults() {
                ActionPropertySet.this.resetMouse();
            }
        };
        Object alignTo = this.buttonModifierSet != null ? this.buttonModifierSet.FUNCTION : this.mouseActionCombo;
        this.addDefaultButtons(this.mouseParms, (Control)alignTo, this.setAsDefaultMouse, this.restoreDefaultsMouse, this.editMouse, (SelectionListener)setResetListener);
    }

    protected void layOutTouchComposite() {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = this.leftAttachment;
        this.touchActionLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.touchActionLabel, 5);
        data.left = this.leftAttachment;
        data.right = new FormAttachment(100, -5);
        this.touchActionCombo.setLayoutData((Object)data);
        SetResetDefaultsListener setResetListener = new SetResetDefaultsListener(this.setAsDefaultTouch, this.restoreDefaultsTouch, this.editTouch){

            protected boolean haveValuesChanged() {
                return ActionPropertySet.this.isTouchChanged(originalProperties);
            }

            protected void setDefaults(boolean isReset) {
                ActionPropertySet.this.setTouchDefaults(ActionPropertySet.this.getTapPressType());
            }

            protected void resetDefaults() {
                ActionPropertySet.this.resetTouch();
            }
        };
        this.addDefaultButtons(this.touchParms, (Control)this.touchActionCombo, this.setAsDefaultTouch, this.restoreDefaultsTouch, this.editTouch, (SelectionListener)setResetListener);
    }

    protected void layOutKeyboardComposite() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.keyboardAcceptableKeyLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.keyboardText, 5);
        data.left = this.leftAttachment;
        this.keyboardIsCmd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.keyboardAcceptableKeyLabel, 5, 1024);
        data.left = new FormAttachment((Control)this.keyboardAcceptableKeyLabel, 0, 16384);
        this.keyboardTextLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.keyboardTextLabel, 5, 1024);
        data.left = new FormAttachment((Control)this.keyboardAcceptableKeyLabel, 0, 16384);
        data.right = new FormAttachment(100, -5);
        this.keyboardText.setLayoutData((Object)data);
        if (this.keyboardActionCombo != null) {
            data = new FormData();
            data.top = new FormAttachment((Control)this.keyboardIsCmd, 20);
            data.left = new FormAttachment((Control)this.keyboardAcceptableKeyLabel, 0, 16384);
            this.keyboardActionLabel.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.keyboardActionLabel, 5);
            data.left = new FormAttachment((Control)this.keyboardAcceptableKeyLabel, 0, 16384);
            data.right = new FormAttachment(100, -5);
            this.keyboardActionCombo.setLayoutData((Object)data);
        }
        SetResetDefaultsListener setResetListener = new SetResetDefaultsListener(this.setAsDefaultKeyboard, this.restoreDefaultsKeyboard, this.editKeyboard){

            protected boolean haveValuesChanged() {
                return ActionPropertySet.this.isKeyboardChanged(originalProperties);
            }

            protected void enableDefaultButtons(boolean isReset) {
                boolean defaultChanged = ActionPropertySet.this.isKeyboardChanged(ActionPropertySet.this.defaultProperties);
                this.setAsDefaults.setEnabled(defaultChanged);
                this.resetDefaults.setEnabled(!isReset && this.haveValuesChanged());
            }

            protected void setDefaults(boolean isReset) {
                String cmd = isReset ? ActionPropertySet.originalProperties.keyboardString : ActionPropertySet.this.getKeyboardString();
                ActionPropertySet.this.setKeyboardDefaults(ActionPropertySet.this.getKeyboardPressType(), cmd, ActionPropertySet.this.isKeyboardCmd());
            }

            protected void resetDefaults() {
                ActionPropertySet.this.resetKeyboard();
            }
        };
        this.addDefaultButtons(this.keyboardParms, (Control)this.keyboardSpecials.CAPSLOCK, this.setAsDefaultKeyboard, this.restoreDefaultsKeyboard, this.editKeyboard, (SelectionListener)setResetListener);
    }

    protected void layOutGraffitiComposite() {
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.graffitiText, 5);
        data.left = this.leftAttachment;
        this.graffitiIsCmd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = this.leftAttachment;
        this.graffitiTextLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.graffitiTextLabel, 5);
        data.left = new FormAttachment((Control)this.graffitiTextLabel, 0, 16384);
        data.right = new FormAttachment(100, -5);
        this.graffitiText.setLayoutData((Object)data);
        SetResetDefaultsListener setResetListener = new SetResetDefaultsListener(this.setAsDefaultGraffiti, this.restoreDefaultsGraffiti, this.editGraffiti){

            protected boolean haveValuesChanged() {
                return ActionPropertySet.this.isGraffitiChanged(originalProperties);
            }

            protected void enableDefaultButtons(boolean isReset) {
                boolean defaultChanged = ActionPropertySet.this.isGraffitiChanged(ActionPropertySet.this.defaultProperties);
                this.setAsDefaults.setEnabled(defaultChanged);
                this.resetDefaults.setEnabled(!isReset && this.haveValuesChanged());
            }

            protected void setDefaults(boolean isReset) {
                String cmd = isReset ? ActionPropertySet.originalProperties.graffitiString : ActionPropertySet.this.getGraffitiString();
                ActionPropertySet.this.setGraffitiDefaults(cmd, ActionPropertySet.this.isGraffitiCmd());
            }

            protected void resetDefaults() {
                ActionPropertySet.this.resetGraffiti();
            }
        };
        this.addDefaultButtons(this.graffitiParms, (Control)this.graffitiIsCmd, this.setAsDefaultGraffiti, this.restoreDefaultsGraffiti, this.editGraffiti, (SelectionListener)setResetListener);
    }

    protected void layOutVoiceComposite() {
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.voiceText, 0, 0x1000000);
        data.left = this.leftAttachment;
        this.voiceIsCmd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.voiceText, 0, 0x1000000);
        data.left = this.leftAttachment;
        this.voiceTextLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.voiceTextLabel, 5, 131072);
        data.right = new FormAttachment((Control)this.voiceIsCmd, -5, 16384);
        this.voiceText.setLayoutData((Object)data);
        SetResetDefaultsListener setResetListener = new SetResetDefaultsListener(this.setAsDefaultVoice, this.restoreDefaultsVoice, this.editVoice){

            protected boolean haveValuesChanged() {
                return ActionPropertySet.this.isVoiceChanged(originalProperties);
            }

            protected void enableDefaultButtons(boolean isReset) {
                boolean defaultChanged = ActionPropertySet.this.isVoiceChanged(ActionPropertySet.this.defaultProperties);
                this.setAsDefaults.setEnabled(defaultChanged);
                this.resetDefaults.setEnabled(!isReset && this.haveValuesChanged());
            }

            protected void setDefaults(boolean isReset) {
                String cmd = isReset ? ActionPropertySet.originalProperties.voiceString : ActionPropertySet.this.getVoiceString();
                ActionPropertySet.this.setVoiceDefaults(cmd, ActionPropertySet.this.isVoiceCmd());
            }

            protected void resetDefaults() {
                ActionPropertySet.this.resetVoice();
            }
        };
        this.addDefaultButtons(this.voiceParms, (Control)this.voiceText, this.setAsDefaultVoice, this.restoreDefaultsVoice, this.editVoice, (SelectionListener)setResetListener);
    }

    protected void handleModifiedText() {
        super.handleModifiedText();
        this.setAsDefaultKeyboard.setEnabled(this.isKeyboardChanged(this.defaultProperties));
    }

    protected Button createSetAsDefaultButton(Composite parent) {
        Button setAsDefault = new Button(parent, 8);
        setAsDefault.setText(setAsDefaultLabel);
        return setAsDefault;
    }

    protected Button createRestoreDefaultsButton(Composite parent) {
        Button restoreDefaults = new Button(parent, 8);
        restoreDefaults.setText(restoreDefaultsLabel);
        return restoreDefaults;
    }

    protected Button createEditButton(Composite parent) {
        Button edit = new Button(parent, 8);
        edit.setText(editLabel);
        return edit;
    }

    protected Composite createMouseComposite() {
        Composite c = super.createMouseComposite();
        this.setAsDefaultMouse = this.createSetAsDefaultButton(c);
        this.restoreDefaultsMouse = this.createRestoreDefaultsButton(c);
        this.editMouse = this.createEditButton(c);
        return c;
    }

    protected Composite createTouchComposite() {
        Composite c = super.createTouchComposite();
        this.setAsDefaultTouch = this.createSetAsDefaultButton(c);
        this.restoreDefaultsTouch = this.createRestoreDefaultsButton(c);
        this.editTouch = this.createEditButton(c);
        return c;
    }

    protected Composite createKeyComposite() {
        Composite c = super.createKeyComposite();
        ActionStringChangeHandler handler = new ActionStringChangeHandler();
        this.keyboardText.addSelectionListener((SelectionListener)handler);
        this.keyboardText.addFocusListener((FocusListener)handler);
        this.setAsDefaultKeyboard = this.createSetAsDefaultButton(c);
        this.restoreDefaultsKeyboard = this.createRestoreDefaultsButton(c);
        this.editKeyboard = this.createEditButton(c);
        return c;
    }

    protected Composite createGraffitiComposite() {
        Composite c = super.createGraffitiComposite();
        ActionStringChangeHandler handler = new ActionStringChangeHandler();
        this.graffitiText.addSelectionListener((SelectionListener)handler);
        this.graffitiText.addFocusListener((FocusListener)handler);
        this.graffitiText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ActionPropertySet.this.setAsDefaultGraffiti.setEnabled(ActionPropertySet.this.isGraffitiChanged(ActionPropertySet.this.defaultProperties));
            }
        });
        this.setAsDefaultGraffiti = this.createSetAsDefaultButton(c);
        this.restoreDefaultsGraffiti = this.createRestoreDefaultsButton(c);
        this.editGraffiti = this.createEditButton(c);
        return c;
    }

    protected Composite createVoiceComposite() {
        Composite c = super.createVoiceComposite();
        ActionStringChangeHandler handler = new ActionStringChangeHandler();
        this.voiceText.addSelectionListener((SelectionListener)handler);
        this.voiceText.addFocusListener((FocusListener)handler);
        this.voiceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ActionPropertySet.this.setAsDefaultVoice.setEnabled(ActionPropertySet.this.isVoiceChanged(ActionPropertySet.this.defaultProperties));
            }
        });
        this.setAsDefaultVoice = this.createSetAsDefaultButton(c);
        this.restoreDefaultsVoice = this.createRestoreDefaultsButton(c);
        this.editVoice = this.createEditButton(c);
        return c;
    }

    protected void layOutFrameComposite() {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = this.leftAttachment;
        this.frameNameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.frameNameLabel, 5, 1024);
        data.left = this.leftAttachment;
        data.right = new FormAttachment(100, -5);
        this.frameName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.frameName, 5, 1024);
        data.left = this.leftAttachment;
        data.right = new FormAttachment((Control)this.removeFrameImage, 0, 131072);
        this.setFrameImage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.setFrameImage, 5, 1024);
        data.left = this.leftAttachment;
        this.removeFrameImage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.removeFrameImage, 5, 1024);
        data.left = this.leftAttachment;
        data.right = new FormAttachment((Control)this.removeFrameImage, 0, 131072);
        this.setFrameWidgetColor.setLayoutData((Object)data);
    }

    protected void addDefaultButtons(Composite parms, Control last, Button setAsDefault, Button restoreDefaults, Button edit, SelectionListener buttonListener) {
        FormData data = new FormData();
        data.top = new FormAttachment(last, 5, 1024);
        data.left = this.leftAttachment;
        data.right = new FormAttachment((Control)restoreDefaults, 0, 131072);
        setAsDefault.setLayoutData((Object)data);
        setAsDefault.setEnabled(false);
        setAsDefault.addSelectionListener(buttonListener);
        data = new FormData();
        data.top = new FormAttachment((Control)setAsDefault, 5, 1024);
        data.left = this.leftAttachment;
        restoreDefaults.setLayoutData((Object)data);
        restoreDefaults.setEnabled(false);
        restoreDefaults.addSelectionListener(buttonListener);
        data = new FormData();
        data.top = new FormAttachment((Control)restoreDefaults, 5, 1024);
        data.left = this.leftAttachment;
        data.right = new FormAttachment((Control)restoreDefaults, 0, 131072);
        edit.setLayoutData((Object)data);
        edit.addSelectionListener(buttonListener);
    }

    public void setComposite(int device) {
        switch (device) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.propLabel.setText(transitionPropertiesLabel);
                super.setComposite(device);
                break;
            }
            case 7: {
                this.propLabel.setText(framePropertiesLabel);
                this.actionSettingsLayout.topControl = this.frameParms;
                break;
            }
            case 8: {
                this.actionSettingsLayout.topControl = this.multTransParms;
                break;
            }
            default: {
                this.propLabel.setText(propertiesLabel);
                this.actionSettingsLayout.topControl = this.emptyParms;
            }
        }
        this.actionSettings.layout();
    }

    protected void layoutHelper() {
        this.actionSettings = new Composite(this.parent, 0);
        this.actionSettings.setLayout((Layout)this.actionSettingsLayout);
        this.propLabel = new Label(this.parent, 0x1000000);
        this.propLabel.setText(propertiesLabel);
        Font labelFont = this.propLabel.getFont();
        FontData[] fData = labelFont.getFontData();
        String fontName = fData[0].getName();
        int fontSize = fData[0].getHeight();
        FontData font = new FontData(fontName, fontSize, 1);
        this.propLabel.setFont(new Font(null, font));
        FormData data = new FormData();
        data.left = this.leftAttachment;
        data.right = new FormAttachment(100, -5);
        this.propLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = this.leftAttachment;
        data.top = new FormAttachment((Control)this.propLabel, 5, 1024);
        data.right = new FormAttachment(100, -5);
        this.actionSettings.setLayoutData((Object)data);
        this.emptyParms = new Composite(this.actionSettings, 0);
        this.emptyParms.setLayout((Layout)new FormLayout());
        Label emptyLabel = new Label(this.emptyParms, 0);
        emptyLabel.setText(nothingSelectedText);
        data = new FormData();
        data.left = this.leftAttachment;
        data.top = new FormAttachment(0, 5);
        emptyLabel.setLayoutData((Object)data);
        this.multTransParms = new Composite(this.actionSettings, 0);
        this.multTransParms.setLayout((Layout)new FormLayout());
        Label multTransLabel = new Label(this.multTransParms, 64);
        multTransLabel.setText(noActionAvailableText);
        data = new FormData();
        data.left = this.leftAttachment;
        data.top = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        multTransLabel.setLayoutData((Object)data);
        this.frameParms = this.createFrameComposite();
        this.layOutFrameComposite();
    }

    public void useParameters(int mode) {
        this.setProperties(null, mode);
    }

    public void setProperties(IDesignEditorUI.ActionProperties props, int mode) {
        super.setProperties(props, mode);
        switch (mode) {
            case 5: {
                this.enableMouseParameters(false);
                this.setMouse(props);
                this.enableTouchParameters(false);
                this.setTap(props);
                this.enableGraffitiParameters(false);
                this.setGraffiti(props);
                this.enableKeyboardParameters(false);
                this.setKeyboard(props);
                this.enableVoiceParameters(false);
                this.setVoice(props);
                this.setComposite(5);
                break;
            }
            case 8: {
                this.enableMouseParameters(false);
                this.setMouse(props);
                this.enableTouchParameters(false);
                this.setTap(props);
                this.enableGraffitiParameters(false);
                this.setGraffiti(props);
                this.enableKeyboardParameters(false);
                this.setKeyboard(props);
                this.enableVoiceParameters(false);
                this.setVoice(props);
                this.setComposite(8);
                break;
            }
            case 0: {
                this.enableMouseParameters(true);
                this.setMouse(props);
                this.setComposite(0);
                this.setAsDefaultMouse.setEnabled(this.isMouseChanged(this.defaultProperties));
                this.enableTouchParameters(false);
                this.setTap(props);
                this.enableGraffitiParameters(false);
                this.setGraffiti(props);
                this.enableKeyboardParameters(false);
                this.setKeyboard(props);
                this.enableVoiceParameters(false);
                this.setVoice(props);
                break;
            }
            case 4: {
                this.enableTouchParameters(true);
                this.setTap(props);
                this.setComposite(4);
                this.setAsDefaultTouch.setEnabled(this.isTouchChanged(this.defaultProperties));
                this.enableMouseParameters(false);
                this.setMouse(props);
                this.enableGraffitiParameters(false);
                this.setGraffiti(props);
                this.enableKeyboardParameters(false);
                this.setKeyboard(props);
                this.enableVoiceParameters(false);
                this.setVoice(props);
                break;
            }
            case 1: {
                this.enableMouseParameters(false);
                this.setMouse(props);
                this.enableTouchParameters(false);
                this.setTap(props);
                this.enableGraffitiParameters(false);
                this.setGraffiti(props);
                this.enableKeyboardParameters(false);
                this.setKeyboard(props);
                this.enableVoiceParameters(true);
                this.setVoice(props);
                this.setComposite(1);
                this.setAsDefaultVoice.setEnabled(this.isVoiceChanged(this.defaultProperties));
                break;
            }
            case 2: {
                this.enableMouseParameters(false);
                this.setMouse(props);
                this.enableTouchParameters(false);
                this.setTap(props);
                this.enableGraffitiParameters(false);
                this.setGraffiti(props);
                this.enableKeyboardParameters(true);
                this.setKeyboard(props);
                this.setComposite(2);
                this.setAsDefaultKeyboard.setEnabled(this.isKeyboardChanged(this.defaultProperties));
                this.enableVoiceParameters(false);
                this.setVoice(props);
                break;
            }
            case 3: {
                this.enableMouseParameters(false);
                this.setMouse(props);
                this.enableTouchParameters(false);
                this.setTap(props);
                this.enableGraffitiParameters(true);
                this.setGraffiti(props);
                this.setComposite(3);
                this.setAsDefaultGraffiti.setEnabled(this.isGraffitiChanged(this.defaultProperties));
                this.enableKeyboardParameters(false);
                this.setKeyboard(props);
                this.enableVoiceParameters(false);
                this.setVoice(props);
                break;
            }
            default: {
                this.enableMouseParameters(true);
                this.setMouse(props);
                this.enableTouchParameters(true);
                this.setTap(props);
                this.enableGraffitiParameters(true);
                this.setGraffiti(props);
                this.enableKeyboardParameters(true);
                this.setKeyboard(props);
                this.enableVoiceParameters(true);
                this.setVoice(props);
                if (props == null) break;
                this.setComposite(props.useWhichParts);
            }
        }
    }

    public void setCurrentDeviceType(DeviceType type) {
        this.currentDeviceType = type;
    }

    public DeviceType getCurrentDeviceType() {
        return this.currentDeviceType;
    }

    protected boolean isMouseChanged(IDesignEditorUI.ActionProperties props) {
        boolean changed;
        boolean bl = changed = this.getMouseModifiers() != props.buttonState || this.getMousePressType() != props.buttonAction;
        if (props.buttonAction != MousePressType.Hover) {
            changed = this.getMouseButton() != props.mouseButton || changed;
        }
        return changed;
    }

    protected boolean isTouchChanged(IDesignEditorUI.ActionProperties props) {
        return this.getTapPressType() != props.tapAction;
    }

    protected boolean isKeyboardChanged(IDesignEditorUI.ActionProperties props) {
        return this.getKeyboardPressType() != props.keyboardAction || !this.getKeyboardString().equals(props.keyboardString) || this.isKeyboardCmd() != props.keyboardIsCmd;
    }

    protected boolean isGraffitiChanged(IDesignEditorUI.ActionProperties props) {
        return !this.getGraffitiString().equals(props.graffitiString) || this.isGraffitiCmd() != props.graffitiIsCmd;
    }

    protected boolean isVoiceChanged(IDesignEditorUI.ActionProperties props) {
        return !this.getVoiceString().equals(props.voiceString) || this.isVoiceCmd() != props.voiceIsCmd;
    }

    public void enableRemoveImage(boolean enable) {
        this.removeFrameImage.setEnabled(enable);
    }

    public void setFrameName(IFrame frame) {
        this.frameName.setText(frame.getName());
        this.frameName.setData((Object)frame);
    }

    public void setMouseDefaults(MouseButtonState mbs, MousePressType mpt, int state) {
        this.defaultProperties.mouseButton = mpt == MousePressType.Hover ? null : mbs;
        this.defaultProperties.buttonAction = mpt;
        this.defaultProperties.buttonState = state;
    }

    public void setTouchDefaults(TapPressType tpt) {
        this.defaultProperties.tapAction = tpt;
    }

    public void setKeyboardDefaults(KeyPressType kpt, String cmd, boolean isCmd) {
        this.defaultProperties.keyboardAction = kpt;
        this.defaultProperties.keyboardIsCmd = isCmd;
        this.defaultProperties.keyboardString = cmd;
    }

    public void setGraffitiDefaults(String cmd, boolean isCmd) {
        this.defaultProperties.graffitiIsCmd = isCmd;
        this.defaultProperties.graffitiString = cmd;
    }

    public void setVoiceDefaults(String cmd, boolean isCmd) {
        this.defaultProperties.voiceIsCmd = isCmd;
        this.defaultProperties.voiceString = cmd;
    }

    public IDesignEditorUI.ActionProperties getDefaultProperties() {
        return this.defaultProperties;
    }

    public void getProperties(IDesignEditorUI.ActionProperties props) {
        props.copyValues(this.defaultProperties);
        super.getProperties(props);
    }

    public void enableFrameName(boolean enable) {
        this.frameName.setEnabled(enable);
        this.frameNameLabel.setEnabled(enable);
        if (!enable) {
            this.frameName.setText(notApplicable);
        }
    }

    public void setLimitMode(int limitMode, int useWhichParts) {
        switch (useWhichParts) {
            case 0: {
                this.editMouse.setVisible(limitMode == 6);
                break;
            }
            case 4: {
                this.editTouch.setVisible(limitMode == 6);
                break;
            }
            case 2: {
                this.editKeyboard.setVisible(limitMode == 6);
                break;
            }
            case 3: {
                this.editGraffiti.setVisible(limitMode == 6);
                break;
            }
            case 1: {
                this.editVoice.setVisible(limitMode == 6);
            }
        }
    }

    protected abstract class SetResetDefaultsListener
    extends SelectionAdapter {
        protected Button setAsDefaults;
        protected Button resetDefaults;
        protected Button edit;

        public SetResetDefaultsListener(Button set, Button reset, Button e) {
            this.setAsDefaults = set;
            this.resetDefaults = reset;
            this.edit = e;
        }

        protected abstract boolean haveValuesChanged();

        protected abstract void setDefaults(boolean var1);

        protected abstract void resetDefaults();

        protected void enableDefaultButtons(boolean isReset) {
            this.setAsDefaults.setEnabled(false);
            this.resetDefaults.setEnabled(this.haveValuesChanged());
        }

        public void widgetSelected(SelectionEvent evt) {
            boolean isReset;
            if (evt.getSource() == this.edit) {
                ActionPropertySet.this.view.performAction(DesignEditorLID.EditTransition);
            }
            boolean bl = isReset = evt.getSource() == this.resetDefaults;
            if (isReset) {
                this.resetDefaults();
                if (!ActionPropertySet.this.performChangeWidgetAction()) {
                    return;
                }
            }
            this.setDefaults(isReset);
            this.enableDefaultButtons(isReset);
        }
    }

    protected class FrameNameStringChangeHandler
    extends SelectionAdapter
    implements FocusListener {
        protected boolean notActive = true;

        protected FrameNameStringChangeHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleEvent((EventObject)e);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.handleEvent((EventObject)e);
        }

        protected void handleEvent(EventObject e) {
            Text source = (Text)e.getSource();
            if (source.isEnabled() && this.notActive) {
                this.notActive = false;
                ActionPropertySet.this.performRenameFrameAction();
                this.notActive = true;
            }
        }
    }

    protected class ActionStringChangeHandler
    extends SelectionAdapter
    implements FocusListener {
        protected boolean notActive = true;

        protected ActionStringChangeHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.handleEvent((EventObject)e);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.handleEvent((EventObject)e);
        }

        protected void handleEvent(EventObject e) {
            Text source = (Text)e.getSource();
            if (source.isEnabled() && this.notActive) {
                this.notActive = false;
                ActionPropertySet.this.performChangeDeviceAction();
                this.notActive = true;
            }
        }
    }
}

