/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.util.AListenerAction;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AboutView
extends WindowUtil.SimpleDialog {
    public static Image logoImg = AboutView.loadLogo();
    protected static AboutView instance = null;

    public AboutView(Shell forWindow) {
        super(forWindow, L10N.get("CT.AboutTitle", "About CogTool"), 32768);
    }

    public AboutView() {
        super(L10N.get("CT.AboutTitle", "About CogTool"), 0);
    }

    protected static Image loadLogo() {
        InputStream stream = ClassLoader.getSystemResourceAsStream("edu/cmu/cs/hcii/cogtool/resources/CogTool_Icon.png");
        return new Image((Device)WindowUtil.globalDisplay, stream);
    }

    public void buildDialog() {
        GridLayout layout = new GridLayout(1, false);
        this.dialog.setLayout((Layout)layout);
        Label logo = new Label((Composite)this.dialog, 0x1000000);
        logo.setImage(logoImg);
        GridData imgLayout = new GridData();
        imgLayout.horizontalAlignment = 4;
        imgLayout.grabExcessHorizontalSpace = true;
        logo.setLayoutData((Object)imgLayout);
        Text version = new Text((Composite)this.dialog, 16394);
        GridData versionLayout = new GridData(64);
        version.setLayoutData((Object)versionLayout);
        version.setText(CogTool.getVersion());
        Label copyright = new Label((Composite)this.dialog, 0);
        GridData copyrightLayout = new GridData(64);
        copyright.setLayoutData((Object)copyrightLayout);
        copyright.setText(L10N.get("CT.Copyright", "\u00a9 2006 CogTool@Carnegie Mellon University"));
        Link link = new Link((Composite)this.dialog, 0);
        GridData linkLayout = new GridData(64);
        link.setLayoutData((Object)linkLayout);
        final String url = L10N.get("CT.MainURL", "http://www.cs.cmu.edu/~bej/cogtool");
        link.setText("<a href=\"" + url + "\">" + url + "</a>");
        link.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                Program.launch((String)url);
            }
        });
        if (OSUtils.WINDOWS) {
            Button okButton = new Button((Composite)this.dialog, 8);
            okButton.setText(L10N.get("B.OK", "OK"));
            okButton.setFocus();
            this.dialog.setDefaultButton(okButton);
            GridData okLayout = new GridData(64);
            okButton.setLayoutData((Object)okLayout);
            okButton.addListener(13, new Listener(){

                public void handleEvent(Event evt) {
                    AboutView.this.dialog.close();
                }
            });
        }
    }

    public static class PopAction
    extends AListenerAction {
        Shell window;

        public PopAction(Shell win) {
            this.window = win;
        }

        public boolean performAction(Object prms) {
            if (OSUtils.MACOSX) {
                if (instance == null || instance.dialog.isDisposed()) {
                    instance = new AboutView();
                    Object ignore = instance.open();
                } else {
                    instance.dialog.setActive();
                }
                return true;
            }
            instance = new AboutView(this.window);
            Object ignore = instance.open();
            return true;
        }
    }
}

