/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.view;

import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.MenuUtil;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.RcvrUIException;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.ContextMenuManager;
import edu.cmu.cs.hcii.cogtool.view.IView;
import edu.cmu.cs.hcii.cogtool.view.MenuFactory;
import java.security.InvalidParameterException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public abstract class AView
implements IView {
    public static final ThreadLocal drawingFlags = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.TRUE;
        }
    };
    protected static Image[] images;
    protected Shell shell;
    protected Menu mainMenu;
    protected ContextMenuManager contextMenus;
    protected ListenerIdentifierMap lIDMap;
    protected ListenerIdentifier.ILIDTransmuter transmuter;
    protected boolean performingAction = false;

    public AView(Shell windowShell, ListenerIdentifierMap listenerIDMap, ListenerIdentifier.ILIDTransmuter lIDtransformer, MenuFactory.IWindowMenuData menuData) {
        this.shell = windowShell;
        this.lIDMap = listenerIDMap;
        this.transmuter = lIDtransformer;
        if (OSUtils.WINDOWS) {
            if (images == null) {
                ImageLoader loader = new ImageLoader();
                ImageData[] imageData = loader.load(ClassLoader.getSystemResourceAsStream("edu/cmu/cs/hcii/cogtool/resources/CogTool.ico"));
                images = new Image[imageData.length];
                for (int i = 0; i < imageData.length; ++i) {
                    AView.images[i] = new Image((Device)WindowUtil.globalDisplay, imageData[i]);
                }
            }
            this.shell.setImages(images);
        }
        Listener selectionListener = new Listener(){

            public void handleEvent(Event evt) {
                AView.this.performAction((ListenerIdentifier)evt.widget.getData());
            }
        };
        menuData.setView(this);
        this.mainMenu = MenuFactory.buildMenu(this.neededMenus(), this.shell, selectionListener, this.lIDMap, menuData);
        MenuUtil.MenuItemDefinition[][] defs = this.getContextMenuDefinitions();
        if (defs != null) {
            this.contextMenus = new ContextMenuManager(this.shell, this.lIDMap, this.transmuter, defs);
        }
        this.shell.setMenuBar(this.mainMenu);
    }

    protected boolean performAction(ListenerIdentifier id) {
        return this.transmuter.performAction(id);
    }

    protected boolean performAction(ListenerIdentifier id, Object actionParms, boolean doCleanup) {
        return this.transmuter.performAction(id, actionParms, doCleanup);
    }

    protected abstract MenuFactory.MenuType[] neededMenus();

    public Shell getShell() {
        return this.shell;
    }

    public void setWindowTitle(String newTitle) {
        Shell window = this.getShell();
        if (window == null) {
            throw new RcvrUIException("No window available for setting window title.");
        }
        window.setText(newTitle);
    }

    public void setVisible(boolean visible) {
        Shell window = this.getShell();
        if (window != null) {
            if (visible) {
                WindowUtil.display(window, false);
                window.layout(true, true);
            } else {
                window.setVisible(false);
            }
        } else {
            throw new RcvrUIException("No window available for setting window visibility.");
        }
    }

    public void takeFocus() {
        Shell window = this.getShell();
        if (window == null) {
            throw new RcvrUIException("No window available for taking the focus.");
        }
        window.setActive();
    }

    public boolean requestClose() {
        Shell window = this.getShell();
        if (window != null) {
            window.close();
            return window.isDisposed();
        }
        throw new RcvrUIException("No window available to close.");
    }

    public void dispose() {
        Shell window = this.getShell();
        if (window != null) {
            if (!window.isDisposed()) {
                window.close();
                window.dispose();
            }
        } else {
            throw new RcvrUIException("No window available for recovering system resources.");
        }
        if (this.contextMenus != null) {
            this.contextMenus.dispose();
        }
    }

    public boolean isDisposed() {
        Shell window = this.getShell();
        if (window != null) {
            return window.isDisposed();
        }
        throw new RcvrUIException("No window available for testing if closed.");
    }

    public MenuUtil.MenuItemDefinition[][] getContextMenuDefinitions() {
        return null;
    }

    public static boolean isDrawingOK() {
        return true;
    }

    public static void setDrawingOK(boolean newVal) {
        drawingFlags.set(newVal ? Boolean.TRUE : Boolean.FALSE);
    }

    protected static Shell createShell(Rectangle bounds, int width, int height, Layout layout) {
        return WindowUtil.createNormalWindow(WindowUtil.globalDisplay, "", bounds != null ? bounds : new Rectangle(0, 0, width, height), bounds != null, layout);
    }

    public boolean isPerformingAction() {
        return this.performingAction;
    }

    public void setPerformingAction(boolean performing) {
        this.performingAction = performing;
    }

    protected class SWTWidgetChangeHandler
    extends SelectionAdapter {
        CogToolLID lid;

        public SWTWidgetChangeHandler(CogToolLID setLid) {
            if (setLid == null) {
                throw new InvalidParameterException("Cannot create a widgetChangeHandler with a null lid");
            }
            this.lid = setLid;
        }

        public void widgetSelected(SelectionEvent evt) {
            Control source = (Control)evt.getSource();
            if (source.isEnabled()) {
                AView.this.performAction(this.lid);
            }
            if (!source.isDisposed()) {
                source.forceFocus();
            }
        }
    }
}

