/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private ZipUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(List srcFiles, File dst) throws IOException {
        block6: {
            FileOutputStream fos;
            block7: {
                fos = null;
                ZipOutputStream zip = null;
                try {
                    fos = new FileOutputStream(dst);
                    zip = new ZipOutputStream(fos);
                    zip.setLevel(9);
                    zip.setMethod(8);
                    Iterator it = srcFiles.iterator();
                    while (it.hasNext()) {
                        File src = (File)it.next();
                        if (src.isDirectory()) {
                            ZipUtil.zipDirectory(src, "", zip);
                            continue;
                        }
                        ZipUtil.zipOneFile(src, "", zip);
                    }
                    Object var7_6 = null;
                    if (fos == null) break block6;
                    if (zip == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (fos != null) {
                        if (zip != null) {
                            zip.close();
                        }
                        fos.close();
                    }
                    throw throwable;
                }
                zip.close();
            }
            fos.close();
            {
            }
        }
    }

    private static void zipDirectory(File dir, String base, ZipOutputStream zout) throws IOException {
        File[] files = dir.listFiles();
        base = base + dir.getName() + "/";
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    ZipUtil.zipDirectory(files[i], base, zout);
                    continue;
                }
                ZipUtil.zipOneFile(files[i], base, zout);
            }
        } else {
            String name = base + dir.getName() + '/';
            ZipEntry entry = new ZipEntry(name);
            entry.setTime(dir.lastModified());
            zout.putNextEntry(entry);
            zout.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipOneFile(File file, String base, ZipOutputStream zout) throws IOException {
        String name = base + file.getName();
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(file.lastModified());
        zout.putNextEntry(entry);
        FileInputStream in = new FileInputStream(file);
        try {
            int chunkSize = 102400;
            byte[] buff = new byte[chunkSize];
            int len = chunkSize;
            for (long size = file.length(); size > 0L; size -= (long)len) {
                len = size < (long)chunkSize ? (int)size : chunkSize;
                int actualBytes = 0;
                int off = 0;
                do {
                    if ((actualBytes = in.read(buff, off, len)) == -1) {
                        zout.write(buff, off, len);
                        throw new RuntimeException("Bad math in zip!");
                    }
                    zout.write(buff, off, actualBytes);
                    size -= (long)actualBytes;
                    off += actualBytes;
                } while ((len -= actualBytes) > 0);
            }
        }
        finally {
            in.close();
        }
        zout.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(ZipFile zip, File fileDir) throws FileNotFoundException, IOException {
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            FileOutputStream fout;
            block10: {
                BufferedOutputStream out;
                block11: {
                    Object var17_15;
                    ZipEntry ze = en.nextElement();
                    String name = ze.getName();
                    File zeFile = new File(fileDir, name);
                    if (name.charAt(name.length() - 1) == '/') {
                        zeFile.mkdirs();
                        continue;
                    }
                    zeFile.getParentFile().mkdirs();
                    zeFile.createNewFile();
                    fout = null;
                    out = null;
                    InputStream zin = null;
                    try {
                        fout = new FileOutputStream(zeFile);
                        out = new BufferedOutputStream(fout);
                        zin = zip.getInputStream(ze);
                        zeFile.setLastModified(ze.getTime());
                        int chunkSize = 102400;
                        byte[] buff = new byte[chunkSize];
                        int len = chunkSize;
                        for (long size = ze.getSize(); size > 0L; size -= (long)len) {
                            len = size < (long)chunkSize ? (int)size : chunkSize;
                            int actualBytes = 0;
                            int off = 0;
                            do {
                                if ((actualBytes = zin.read(buff, off, len)) == -1) {
                                    ((OutputStream)out).write(buff, off, len);
                                    throw new RuntimeException("Bad math in unzip!");
                                }
                                ((OutputStream)out).write(buff, off, actualBytes);
                                size -= (long)actualBytes;
                                off += actualBytes;
                            } while ((len -= actualBytes) > 0);
                        }
                        var17_15 = null;
                        if (fout == null) continue;
                        if (out == null) break block10;
                        if (zin == null) break block11;
                    }
                    catch (Throwable throwable) {
                        var17_15 = null;
                        if (fout != null) {
                            if (out != null) {
                                if (zin != null) {
                                    zin.close();
                                }
                                ((OutputStream)out).close();
                            }
                            fout.close();
                        }
                        throw throwable;
                    }
                    zin.close();
                }
                ((OutputStream)out).close();
            }
            fout.close();
            {
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args[0].equals("zip")) {
                ArrayList<File> list = new ArrayList<File>(1);
                list.add(new File(args[1]));
                ZipUtil.zip(list, new File(args[2]));
            } else if (args[0].equals("unzip")) {
                ZipUtil.unzip(new ZipFile(new File(args[1])), new File(args[2]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

