/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.INamedObject;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.TextWithEnableFix;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WindowUtil {
    public static final int SELECT_CURSOR = 0;
    public static final int DRAW_CURSOR = 2;
    public static final int TEXT_CURSOR = 19;
    public static final int LINK_CURSOR = 21;
    public static final int HELP_CURSOR = 4;
    public static final int NOT_ALLOWED_CURSOR = 20;
    public static final int BUSY_CURSOR = 1;
    public static final int RESIZE_NS_CURSOR = 7;
    public static final int RESIZE_WE_CURSOR = 9;
    public static final int RESIZE_NW_SE_CURSOR = 8;
    public static final int RESIZE_NE_SW_CURSOR = 6;
    public static final int RESIZE_ALL_CURSOR = 5;
    public static final int MAC_MENU_HEIGHT = 24;
    public static final Display globalDisplay;
    private static Listener WindowClosed;
    public static Listener ExitApplication;
    public static final int CONFIRM_ITEMS_LIMIT = 12;

    public static Cursor getOpenHandCursor() {
        ImageData curData = GraphicsUtil.getImageDataFromResource("edu/cmu/cs/hcii/cogtool/resources/open_hand.gif");
        if (curData == null) {
            return null;
        }
        Cursor handCursor = new Cursor((Device)globalDisplay, curData, 8, 8);
        return handCursor;
    }

    public static Cursor getClosedHandCursor() {
        ImageData curData = GraphicsUtil.getImageDataFromResource("edu/cmu/cs/hcii/cogtool/resources/closed_hand.gif");
        if (curData == null) {
            return null;
        }
        Cursor handCursor = new Cursor((Device)globalDisplay, curData, 8, 8);
        return handCursor;
    }

    private WindowUtil() {
    }

    private static void incrementReferenceCount(Display display) {
        Integer refs = (Integer)display.getData();
        display.setData((Object)new Integer(refs == null ? 1 : refs + 1));
    }

    private static void decrementReferenceCount(Display display) {
        Integer refs = (Integer)display.getData();
        if (refs != null) {
            if (refs == 1) {
                if (!OSUtils.MACOSX || Boolean.getBoolean("edu.cmu.cs.hcii.cogtool.util.QuitAfterLastWindowClosed")) {
                    display.setData(null);
                } else {
                    display.setData((Object)new Integer(0));
                }
            } else {
                display.setData((Object)new Integer(refs - 1));
            }
        }
    }

    public static Shell createNormalWindow(Display display, String windowTitle, Rectangle bounds, boolean setPosition, Layout layout) {
        Shell window = new Shell(display, 1264);
        window.setLayout(layout);
        window.setText(windowTitle);
        if (setPosition) {
            window.setBounds(bounds);
        } else {
            window.setSize(bounds.width, bounds.height);
            Rectangle ca = display.getClientArea();
            Rectangle wb = window.getBounds();
            int minY = OSUtils.MACOSX ? 24 : 0;
            int newY = wb.y;
            int diff = ca.height - (wb.y + wb.height);
            if (diff < 0) {
                newY += diff;
            }
            if (newY < minY) {
                newY = minY;
            }
            int newX = wb.x;
            diff = ca.width - (wb.x + wb.width);
            if (diff < 0) {
                newX += diff;
            }
            if (newX < 0) {
                newX = 0;
            }
            window.setLocation(newX, newY);
        }
        WindowUtil.incrementReferenceCount(display);
        window.addListener(12, WindowClosed);
        return window;
    }

    public static void display(Shell shell, boolean packContents) {
        if (packContents) {
            shell.pack();
        }
        shell.open();
    }

    public static void display(Shell shell, boolean packContents, boolean changed) {
        if (packContents) {
            shell.pack(changed);
        }
        shell.open();
    }

    public static void interact() {
        block3: {
            try {
                while (globalDisplay.getData() != null) {
                    if (globalDisplay.readAndDispatch()) continue;
                    globalDisplay.sleep();
                }
            }
            catch (SWTException e) {
                if (e.getMessage().equals("Device is disposed")) break block3;
                System.err.println("SWTException caught in main CogTool loop.");
                e.printStackTrace();
                System.err.println();
                throw e;
            }
        }
    }

    public static void interact(Shell shell) {
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void displayAndInteract(Shell shell) {
        WindowUtil.displayAndInteract(shell, true);
    }

    public static void displayAndInteract(Shell shell, boolean packContents) {
        WindowUtil.display(shell, packContents);
        WindowUtil.interact(shell);
    }

    public static MessageBox createMessageDialog(Shell parent, String title, String message, int buttons, int icon, int mode) {
        MessageBox msgBox = new MessageBox(parent, buttons | icon | mode);
        msgBox.setText(title);
        msgBox.setMessage(message);
        return msgBox;
    }

    public static int presentMessageDialog(Shell parent, String title, String message, int buttons, int icon, int mode) {
        MessageBox msgBox = WindowUtil.createMessageDialog(parent, title, message, buttons, icon, mode);
        return msgBox.open();
    }

    public static MessageBox createErrorDialog(Shell parent, String title, String message) {
        return WindowUtil.createMessageDialog(parent, title, message, 32, 1, 32768);
    }

    public static int presentErrorDialog(Shell parent, String title, String message) {
        return WindowUtil.presentMessageDialog(parent, title, message, 32, 1, 32768);
    }

    public static MessageBox createWarningDialog(Shell parent, String title, String message) {
        return WindowUtil.createMessageDialog(parent, title, message, 32, 8, 32768);
    }

    public static int presentWarningDialog(Shell parent, String title, String message) {
        return WindowUtil.presentMessageDialog(parent, title, message, 32, 8, 32768);
    }

    public static MessageBox createInformationDialog(Shell parent, String title, String message) {
        return WindowUtil.createMessageDialog(parent, title, message, 32, 2, 32768);
    }

    public static int presentInformationDialog(Shell parent, String title, String message) {
        return WindowUtil.presentMessageDialog(parent, title, message, 32, 2, 32768);
    }

    public static MessageBox createErrorAbortDialog(Shell parent, String title, String message) {
        return WindowUtil.createMessageDialog(parent, title, message, 1280, 1, 32768);
    }

    public static int presentErrorAbortDialog(Shell parent, String title, String message) {
        return WindowUtil.presentMessageDialog(parent, title, message, 1280, 1, 32768);
    }

    public static MessageBox createConfirmDialog(Shell parent, String title, String message) {
        return WindowUtil.createMessageDialog(parent, title, message, 288, 4, 32768);
    }

    public static int presentConfirmDialog(Shell parent, String title, String message) {
        return WindowUtil.presentMessageDialog(parent, title, message, 288, 4, 32768);
    }

    public static int presentConfirmItemsDialog(Shell parent, String title, String message, INamedObject[] items) {
        String indent = "\n    ";
        StringBuffer formattedMessage = new StringBuffer(message);
        int limit = items.length;
        if (limit > 13) {
            limit = 12;
        }
        for (int i = 0; i < limit; ++i) {
            formattedMessage.append(indent);
            formattedMessage.append(items[i].getName());
        }
        if (limit < items.length) {
            formattedMessage.append(indent);
            MessageFormat m = new MessageFormat(L10N.get("CT.moreItems", "and {0, number, integer} more."));
            Object[] args = new Object[]{new Integer(items.length - limit)};
            formattedMessage.append(m.format(args));
        }
        return WindowUtil.presentMessageDialog(parent, title, formattedMessage.toString(), 288, 4, 32768);
    }

    public static int presentConfirmItemsDialog(Shell parent, String title, String message, String[] itemNames) {
        INamedObject[] surrogates = new NamedItem[itemNames.length];
        for (int i = 0; i < itemNames.length; ++i) {
            surrogates[i] = new NamedItem(itemNames[i]);
        }
        return WindowUtil.presentConfirmItemsDialog(parent, title, message, surrogates);
    }

    public static MessageBox createYesNoQuestionDialog(Shell parent, String title, String message) {
        return WindowUtil.createMessageDialog(parent, title, message, 192, 4, 32768);
    }

    public static int presentYesNoQuestionDialog(Shell parent, String title, String message) {
        return WindowUtil.presentMessageDialog(parent, title, message, 192, 4, 32768);
    }

    public static MessageBox createYesNoCancelDialog(Shell parent, String title, String message) {
        return WindowUtil.createMessageDialog(parent, title, message, 448, 4, 32768);
    }

    public static int presentYesNoCancelDialog(Shell parent, String title, String message) {
        return WindowUtil.presentMessageDialog(parent, title, message, 448, 4, 32768);
    }

    public static void scheduleAsynchronously(Runnable r) {
        if (!globalDisplay.isDisposed()) {
            globalDisplay.asyncExec(r);
        }
    }

    static {
        Display.setAppName((String)"CogTool");
        System.setProperty("dock:name", "CogTool");
        globalDisplay = Display.getDefault();
        WindowClosed = new Listener(){

            public void handleEvent(Event evt) {
                WindowUtil.decrementReferenceCount(evt.display);
            }
        };
        ExitApplication = new Listener(){

            public void handleEvent(Event evt) {
                if (evt.doit) {
                    evt.display.setData(null);
                }
            }
        };
    }

    public static class CustomDialog
    extends SimpleDialog {
        public static final String OK = "OK";
        public static final String CANCEL = "Cancel";
        protected Button okButton;
        protected Button cancelButton;
        protected Label rightOfButtons;
        protected Listener okListener = new Listener(this){
            private final /* synthetic */ CustomDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void handleEvent(Event evt) {
                this.this$0.onOK();
            }
        };

        public CustomDialog(Shell parent, String title, int mode, int style) {
            super(parent, title, mode, 0x860 | style);
        }

        public CustomDialog(Shell parent, String title, int mode) {
            this(parent, title, mode, 0);
        }

        public Button getOK() {
            return this.okButton;
        }

        protected void onOK() {
            this.userResponse = OK;
            this.dialog.close();
        }

        protected void buildDialog() {
            GridLayout layout = new GridLayout(4, false);
            if (OSUtils.MACOSX) {
                layout.marginLeft = 19;
                layout.marginRight = 13;
                layout.marginTop = 7;
                layout.marginBottom = 12;
            }
            this.dialog.setLayout((Layout)layout);
            this.addMoreFields();
            Label emptyCell = new Label((Composite)this.dialog, 0);
            GridData emptyCellLayout = new GridData();
            emptyCellLayout.grabExcessHorizontalSpace = true;
            emptyCell.setLayoutData((Object)emptyCellLayout);
            if (OSUtils.WINDOWS) {
                this.okButton = new Button((Composite)this.dialog, 8);
                this.cancelButton = new Button((Composite)this.dialog, 8);
            } else {
                this.rightOfButtons = new Label((Composite)this.dialog, 0);
                emptyCellLayout = new GridData();
                emptyCellLayout.grabExcessHorizontalSpace = true;
                this.rightOfButtons.setLayoutData((Object)emptyCellLayout);
                this.cancelButton = new Button((Composite)this.dialog, 8);
                this.okButton = new Button((Composite)this.dialog, 8);
            }
            if (this.buttonFont != null) {
                this.okButton.setFont(this.buttonFont);
                this.cancelButton.setFont(this.buttonFont);
            }
            this.okButton.setText(L10N.get("B.OK", OK));
            this.cancelButton.setText(L10N.get("B.CANCEL", CANCEL));
            this.dialog.setDefaultButton(this.okButton);
            GridData okLayout = new GridData(128);
            GridData cancelLayout = new GridData(128);
            this.okButton.setLayoutData((Object)okLayout);
            this.cancelButton.setLayoutData((Object)cancelLayout);
            if (OSUtils.MACOSX) {
                okLayout.widthHint = 82;
                cancelLayout.widthHint = 82;
            } else {
                this.rightOfButtons = new Label((Composite)this.dialog, 0);
                emptyCellLayout = new GridData();
                emptyCellLayout.grabExcessHorizontalSpace = true;
                this.rightOfButtons.setLayoutData((Object)emptyCellLayout);
            }
            this.okButton.addListener(13, this.okListener);
            this.cancelButton.addListener(13, new Listener(this){
                private final /* synthetic */ CustomDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleEvent(Event e) {
                    this.this$0.userResponse = "Cancel";
                    this.this$0.dialog.close();
                }
            });
            this.addMoreButtons();
        }

        protected void addMoreFields() {
        }

        protected void addMoreButtons() {
        }
    }

    public static class PromptDialog
    extends CustomDialog {
        protected String responseLabel;
        protected String request;
        protected String promptResponse;
        protected Text responseBox;

        public PromptDialog(Shell parent, String title, int mode, String responseLbl, String requestQuestion, String defaultResponse, int style) {
            super(parent, title, mode, style);
            this.responseLabel = responseLbl;
            this.request = requestQuestion;
            this.promptResponse = defaultResponse;
        }

        public PromptDialog(Shell parent, String title, int mode, String responseLbl, String requestQuestion, String defaultResponse) {
            this(parent, title, mode, responseLbl, requestQuestion, defaultResponse, 2144);
        }

        public PromptDialog(Shell parent, String title, int mode, String responseLbl, String requestQuestion) {
            this(parent, title, mode, responseLbl, requestQuestion, "", 2144);
        }

        public PromptDialog(Shell parent, String title, int mode, String responseLbl) {
            this(parent, title, mode, responseLbl, "", "", 2144);
        }

        protected void onOK() {
            this.promptResponse = this.responseBox.getText();
            super.onOK();
        }

        public String getPromptResponse() {
            return this.promptResponse;
        }

        protected void addMoreFields() {
            if (this.request != null && this.request != "") {
                Label request = new Label((Composite)this.dialog, 0);
                if (this.textFont != null) {
                    request.setFont(this.textFont);
                }
                request.setText(this.request);
                GridData reqLayout = new GridData();
                reqLayout.grabExcessHorizontalSpace = true;
                reqLayout.horizontalSpan = 4;
                request.setLayoutData((Object)reqLayout);
            }
            if (this.responseLabel != null && this.responseLabel != "") {
                Label lbl = new Label((Composite)this.dialog, 0);
                if (this.textFont != null) {
                    lbl.setFont(this.textFont);
                }
                lbl.setText(this.responseLabel);
                GridData lblLayout = new GridData(128);
                lbl.setLayoutData((Object)lblLayout);
            }
            this.responseBox = new TextWithEnableFix((Composite)this.dialog, 2052);
            if (this.promptResponse != null && this.promptResponse != "") {
                if (this.textFont != null) {
                    this.responseBox.setFont(this.textFont);
                }
                this.responseBox.setText(this.promptResponse);
                this.responseBox.selectAll();
            }
            GridData responseLayout = new GridData(256);
            responseLayout.grabExcessHorizontalSpace = true;
            responseLayout.horizontalSpan = this.responseLabel != null && this.responseLabel != "" ? 3 : 4;
            this.responseBox.setLayoutData((Object)responseLayout);
            this.responseBox.setFocus();
        }

        protected void addMoreButtons() {
        }
    }

    public static abstract class SimpleDialog {
        protected String dialogTitle;
        protected int popupMode;
        protected int style;
        protected Font buttonFont;
        protected Font textFont;
        protected Object userResponse = null;
        protected Shell dialog;
        protected Shell parent;

        public SimpleDialog(Shell parent, String title, int mode, int style) {
            this.parent = parent;
            this.dialogTitle = title;
            this.popupMode = mode;
            this.style = style;
            this.userResponse = null;
            this.dialog = null;
            if (OSUtils.MACOSX) {
                this.textFont = this.buttonFont = new Font((Device)globalDisplay, "Lucida Grande", 13, 0);
            }
        }

        public SimpleDialog(Shell parent, String title, int mode) {
            this(parent, title, mode, 2144);
        }

        public SimpleDialog(String title, int mode, int style) {
            this(null, title, mode, style);
        }

        public SimpleDialog(String title, int mode) {
            this(null, title, mode, 2144);
        }

        protected abstract void buildDialog();

        public Object open() {
            this.dialog = this.parent != null ? new Shell(this.parent, this.style | this.popupMode) : new Shell(globalDisplay, this.style | this.popupMode);
            this.dialog.addDisposeListener(new DisposeListener(this){
                private final /* synthetic */ SimpleDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetDisposed(DisposeEvent arg0) {
                    if (this.this$0.buttonFont != null) {
                        this.this$0.buttonFont.dispose();
                    }
                }
            });
            this.dialog.setText(this.dialogTitle);
            this.buildDialog();
            WindowUtil.display(this.dialog, true);
            if (this.parent != null) {
                Point parentLoc = this.parent.getLocation();
                Point parentSize = this.parent.getSize();
                Point size = this.dialog.getSize();
                int x = parentLoc.x + parentSize.x / 2 - size.x / 2;
                int y = parentLoc.y + parentSize.y / 2 - size.y / 2;
                this.dialog.setLocation(x, y);
            }
            WindowUtil.interact(this.dialog);
            return this.userResponse;
        }
    }

    protected static class NamedItem
    implements INamedObject {
        protected final String name;

        public NamedItem(String objectName) {
            this.name = objectName;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class CloseListener
    implements Listener {
        Shell window;

        public CloseListener(Shell win) {
            this.window = win;
        }

        public void handleEvent(Event evt) {
            if (evt.doit) {
                this.window.close();
            }
        }
    }
}

