/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.Alerter;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.RcvrCannotUndoRedoException;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UndoManagerFactory {
    protected Map nexuses = new HashMap();

    public UndoManager getUndoManager(Object nexusObject) {
        UndoManagerNexus nexus = (UndoManagerNexus)this.nexuses.get(nexusObject);
        if (nexus == null) {
            nexus = new UndoManagerNexus();
            this.nexuses.put(nexusObject, nexus);
        }
        return nexus.getUndoManager(nexusObject, true);
    }

    public UndoManager getUndoManager(Object editObject, Object nexusObject) {
        UndoManagerNexus nexus = (UndoManagerNexus)this.nexuses.get(nexusObject);
        if (nexus == null) {
            throw new RcvrCannotUndoRedoException("Complex model has no UndoManagerNexus");
        }
        return nexus.getUndoManager(editObject, false);
    }

    public void addSavePointChangeHandler(Object nexusObject, IAlertHandler handler) {
        UndoManagerNexus nexus = (UndoManagerNexus)this.nexuses.get(nexusObject);
        if (nexus == null) {
            throw new RcvrCannotUndoRedoException("Complex model has no UndoManagerNexus");
        }
        nexus.addHandler(null, SavePointChange.class, handler);
    }

    public void removeSavePointChangeHandler(Object nexusObject, IAlertHandler handler) {
        UndoManagerNexus nexus = (UndoManagerNexus)this.nexuses.get(nexusObject);
        if (nexus == null) {
            throw new RcvrCannotUndoRedoException("Complex model has no UndoManagerNexus");
        }
        nexus.removeHandler(SavePointChange.class, handler);
    }

    public void markSavePoint(Object nexusObject) {
        UndoManagerNexus nexus = (UndoManagerNexus)this.nexuses.get(nexusObject);
        if (nexus == null) {
            throw new RcvrCannotUndoRedoException("Complex model has no UndoManagerNexus");
        }
        nexus.propagateSavePoint();
    }

    public boolean isAtSavePoint(Object nexusObject) {
        UndoManagerNexus nexus = (UndoManagerNexus)this.nexuses.get(nexusObject);
        if (nexus == null) {
            throw new RcvrCannotUndoRedoException("Complex model has no UndoManagerNexus");
        }
        return nexus.isAtSavePoint();
    }

    public void recoverNexus(Object nexusObject) {
        this.nexuses.remove(nexusObject);
    }

    protected static class UndoManagerNexus
    extends Alerter
    implements UndoManager.ISaveNexus {
        protected Map managers = new HashMap();
        protected int modifiedCount = 0;
        protected SavePointChange nowAtSavePointEvent = new SavePointChange(this, true);
        protected SavePointChange noLongerAtSavePointEvent = new SavePointChange(this, false);

        protected UndoManagerNexus() {
        }

        public void partIsNowAtSavePoint(UndoManager mgr) {
            if (this.modifiedCount == 0) {
                throw new RcvrCannotUndoRedoException("Decrement save point count too far.");
            }
            --this.modifiedCount;
            if (this.modifiedCount == 0) {
                this.raiseAlert(this.nowAtSavePointEvent);
            }
        }

        public void partIsNoLongerAtSavePoint(UndoManager mgr) {
            ++this.modifiedCount;
            if (this.modifiedCount == 1) {
                this.raiseAlert(this.noLongerAtSavePointEvent);
            }
        }

        public boolean isAtSavePoint() {
            return this.modifiedCount == 0;
        }

        public void propagateSavePoint() {
            Iterator mgrs = this.managers.values().iterator();
            while (mgrs.hasNext()) {
                UndoManager mgr = (UndoManager)mgrs.next();
                mgr.markSavePoint();
            }
        }

        public UndoManager getUndoManager(Object editObject, boolean isNexusObject) {
            UndoManager mgr = (UndoManager)this.managers.get(editObject);
            if (mgr == null) {
                mgr = new UndoManager(this, !isNexusObject && this.isAtSavePoint());
                this.managers.put(editObject, mgr);
            }
            return mgr;
        }
    }

    public static class SavePointChange
    extends EventObject {
        public boolean nowAtSavePoint;

        public SavePointChange(UndoManagerNexus nexusMgr, boolean atSavePoint) {
            super(nexusMgr);
            this.nowAtSavePoint = atSavePoint;
        }
    }
}

