/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.Alerter;
import edu.cmu.cs.hcii.cogtool.util.CannotRedoException;
import edu.cmu.cs.hcii.cogtool.util.CannotUndoException;
import edu.cmu.cs.hcii.cogtool.util.IUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.IUndoableEditSequence;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class UndoManager
extends Alerter
implements IUndoableEditSequence {
    protected ISaveNexus saveNexus = null;
    protected List edits = new LinkedList();
    protected int undoableEditLimit = 100;
    protected int undoFenceIndex = 0;
    protected static final int NO_SAVE_POINT = -1;
    protected int savedAtIndex = -1;

    public UndoManager(ISaveNexus nexus, boolean isAtSavePoint) {
        this.saveNexus = nexus;
        if (isAtSavePoint) {
            this.savedAtIndex = 0;
        } else if (this.saveNexus != null) {
            this.saveNexus.partIsNoLongerAtSavePoint(this);
        }
    }

    public UndoManager(ISaveNexus nexus, boolean isAtSavePoint, int undoLimit) {
        this(nexus, isAtSavePoint);
        this.setLimit(undoLimit);
    }

    public void setLimit(int undoLimit) {
        if (undoLimit >= 0) {
            this.undoableEditLimit = undoLimit;
            if (undoLimit > 0) {
                this.raiseAlert(new EventObject(this));
            }
        } else {
            throw new IllegalArgumentException("Cannot set the undo limit to a negative number");
        }
    }

    public int getLimit() {
        return this.undoableEditLimit;
    }

    public void markSavePoint() {
        if (this.savedAtIndex != this.undoFenceIndex) {
            this.savedAtIndex = this.undoFenceIndex;
            if (this.saveNexus != null) {
                this.saveNexus.partIsNowAtSavePoint(this);
            }
            this.raiseAlert(new EventObject(this));
        }
    }

    public boolean isSavePoint() {
        return this.undoFenceIndex == this.savedAtIndex;
    }

    protected void trimEdits() {
        int editCount = this.edits.size();
        if (this.undoFenceIndex < editCount) {
            if (this.savedAtIndex > this.undoFenceIndex) {
                this.savedAtIndex = -1;
            }
            ListIterator editsInReverse = this.edits.listIterator(editCount);
            while (this.undoFenceIndex < editCount && editsInReverse.hasPrevious()) {
                IUndoableEdit edit = (IUndoableEdit)editsInReverse.previous();
                edit.die();
                editsInReverse.remove();
                --editCount;
            }
        }
    }

    public boolean addEdit(IUndoableEdit newEdit) {
        this.trimEdits();
        this.edits.add(this.undoFenceIndex, newEdit);
        if (this.saveNexus != null && this.undoFenceIndex == this.savedAtIndex) {
            this.saveNexus.partIsNoLongerAtSavePoint(this);
        }
        ++this.undoFenceIndex;
        if (this.undoableEditLimit > 0 && this.edits.size() > this.undoableEditLimit) {
            IUndoableEdit excessEdit = (IUndoableEdit)this.edits.get(0);
            excessEdit.die();
            this.edits.remove(0);
            if (this.savedAtIndex != -1) {
                --this.savedAtIndex;
            }
            --this.undoFenceIndex;
        }
        this.raiseAlert(new EventObject(this));
        return true;
    }

    public IUndoableEdit editToBeRedone() {
        if (this.undoFenceIndex < this.edits.size()) {
            return (IUndoableEdit)this.edits.get(this.undoFenceIndex);
        }
        return null;
    }

    public IUndoableEdit editToBeUndone() {
        if (this.undoFenceIndex > 0) {
            return (IUndoableEdit)this.edits.get(this.undoFenceIndex - 1);
        }
        return null;
    }

    public String getRedoPresentationName() {
        IUndoableEdit nextRedo = this.editToBeRedone();
        if (nextRedo != null) {
            return nextRedo.getRedoPresentationName();
        }
        return L10N.get("UNDO.Redo", "Redo");
    }

    public String getUndoPresentationName() {
        IUndoableEdit nextUndo = this.editToBeUndone();
        if (nextUndo != null) {
            return nextUndo.getUndoPresentationName();
        }
        return L10N.get("UNDO.Undo", "Undo");
    }

    public void discardAllEdits() {
        this.undoFenceIndex = 0;
        this.trimEdits();
        this.raiseAlert(new EventObject(this));
    }

    public void redo() {
        IUndoableEdit nextRedo = this.editToBeRedone();
        if (nextRedo == null) {
            throw new CannotRedoException();
        }
        nextRedo.redo();
        if (this.saveNexus != null) {
            if (this.savedAtIndex == this.undoFenceIndex) {
                this.saveNexus.partIsNoLongerAtSavePoint(this);
            } else if (this.savedAtIndex == this.undoFenceIndex + 1) {
                this.saveNexus.partIsNowAtSavePoint(this);
            }
        }
        ++this.undoFenceIndex;
        this.raiseAlert(new EventObject(this));
    }

    public void undo() {
        IUndoableEdit nextUndo = this.editToBeUndone();
        if (nextUndo == null) {
            throw new CannotUndoException();
        }
        nextUndo.undo();
        if (this.saveNexus != null) {
            if (this.savedAtIndex == this.undoFenceIndex) {
                this.saveNexus.partIsNoLongerAtSavePoint(this);
            } else if (this.savedAtIndex == this.undoFenceIndex - 1) {
                this.saveNexus.partIsNowAtSavePoint(this);
            }
        }
        --this.undoFenceIndex;
        if (!nextUndo.canRedo()) {
            this.trimEdits();
        }
        this.raiseAlert(new EventObject(this));
    }

    public static interface ISaveNexus {
        public void partIsNowAtSavePoint(UndoManager var1);

        public void partIsNoLongerAtSavePoint(UndoManager var1);

        public boolean isAtSavePoint();
    }
}

