/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.AProgressCallback;
import edu.cmu.cs.hcii.cogtool.util.ICancelable;
import edu.cmu.cs.hcii.cogtool.util.IEnableDisable;
import edu.cmu.cs.hcii.cogtool.util.IProgressCallback;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.SimpleProgressBar;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ThreadProgressBar
extends SimpleProgressBar
implements IProgressCallback {
    protected IProgressCallback progressCallback = new AProgressCallback(){

        protected void progressCallback(double progress, String status) {
            ThreadProgressBar.this.setProgressBar(progress);
            if (ThreadProgressBar.this.statusLabel != null && status != null) {
                ThreadProgressBar.this.statusLabel.setText(status);
            }
        }

        public void dispose() {
            ThreadProgressBar.this.dispose();
        }
    };
    protected IEnableDisable disabler = new IEnableDisable(){
        protected boolean isEnabled = true;

        public void setEnabled(boolean enabl) {
            if (ThreadProgressBar.this.cancelButton != null) {
                ThreadProgressBar.this.statusLabel.setText(L10N.get("TPB.PleaseWait", "Please wait"));
                ThreadProgressBar.this.cancelButton.setEnabled(enabl);
                this.isEnabled = enabl;
            }
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    };
    protected ICancelable cancelListener = null;
    protected String initialStatus = null;
    protected Label statusLabel = null;
    protected Button cancelButton = null;

    public ThreadProgressBar(String windowTitle, int style) {
        this(null, windowTitle, null, null, style);
    }

    public ThreadProgressBar(String windowTitle, ICancelable cancelable, int style) {
        this(null, windowTitle, cancelable, null, style);
    }

    public ThreadProgressBar(String windowTitle, String initialStatusText, int style) {
        this(null, windowTitle, null, initialStatusText, style);
    }

    public ThreadProgressBar(Shell window, String windowTitle, ICancelable cancelable, String initialStatusText, int style) {
        super(window, windowTitle, style);
        this.initialStatus = initialStatusText;
        this.cancelListener = cancelable;
        if (this.cancelListener != null) {
            this.shell.setSize(300, this.initialStatus != null ? 110 : 90);
        }
    }

    public IEnableDisable getDisabler() {
        return this.disabler;
    }

    protected void addAboveBar() {
        this.shell.setLayout((Layout)new FormLayout());
        if (this.initialStatus != null) {
            this.statusLabel = new Label((Composite)this.shell, 0);
            this.statusLabel.setText(this.initialStatus);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 20);
            data.top = new FormAttachment(0, 10);
            data.right = new FormAttachment(100, -20);
            this.statusLabel.setLayoutData((Object)data);
        }
    }

    protected void addBelowBar() {
        FormData data = new FormData();
        if (this.statusLabel != null) {
            data.top = new FormAttachment((Control)this.statusLabel, 10, 1024);
            data.bottom = new FormAttachment((Control)this.statusLabel, 25, 1024);
        } else {
            data.top = new FormAttachment(0, 10);
            data.bottom = new FormAttachment(0, 25);
        }
        data.left = new FormAttachment(0, 20);
        data.right = new FormAttachment(100, -20);
        this.bar.setLayoutData((Object)data);
        if (this.cancelListener != null) {
            this.cancelButton = new Button((Composite)this.shell, 8);
            this.cancelButton.setText(L10N.get("B.Cancel", "Cancel"));
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    ThreadProgressBar.this.cancelListener.cancel();
                }
            });
            data = new FormData();
            data.left = new FormAttachment((Control)this.bar, 0, 0x1000000);
            data.top = new FormAttachment((Control)this.bar, 5, 1024);
            this.cancelButton.setLayoutData((Object)data);
        }
    }

    public void updateProgress(double progress, String status) {
        this.progressCallback.updateProgress(progress, status);
    }
}

