/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.RcvrWorkThreadException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ThreadManager {
    protected List threadQueue = new ArrayList();
    protected Map activeThreads = new HashMap();
    public int maxActiveThreads = 3;
    protected Object maxActiveThreadsSync = new Object();
    protected SchedulerThread scheduler = null;
    public static final ThreadManager ONLY = new ThreadManager();

    protected ThreadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxThreadCount() {
        Object object = this.maxActiveThreadsSync;
        synchronized (object) {
            return this.maxActiveThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxThreadCount(int maxThreads) {
        Object object = this.maxActiveThreadsSync;
        synchronized (object) {
            this.maxActiveThreads = maxThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOkToStart() {
        int maxThreadCount;
        int activeThreadCount;
        Object object = this.activeThreads;
        synchronized (object) {
            activeThreadCount = this.activeThreads.size();
        }
        object = this.maxActiveThreadsSync;
        synchronized (object) {
            maxThreadCount = this.maxActiveThreads;
        }
        return activeThreadCount < maxThreadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startWorkThread(final IWorkThread workThread, int priority) {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    workThread.doWork();
                }
                catch (Exception e) {
                    workThread.setWorkException(new RcvrWorkThreadException(e));
                }
                finally {
                    workThread.done();
                }
                Map map = ThreadManager.this.activeThreads;
                synchronized (map) {
                    ThreadManager.this.activeThreads.remove(workThread);
                }
            }
        };
        Map map = this.activeThreads;
        synchronized (map) {
            this.activeThreads.put(workThread, t);
        }
        t.setPriority(priority);
        t.start();
    }

    protected int prunePriority(int priority) {
        if (priority < 1) {
            return 1;
        }
        if (priority > 10) {
            return 10;
        }
        return priority;
    }

    public void startNewThread(IWorkThread workThread) {
        this.startNewThread(workThread, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewThread(IWorkThread workThread, int priority) {
        boolean isSchedulerInactive;
        if (workThread == null) {
            throw new IllegalArgumentException("Work thread cannot be null");
        }
        priority = this.prunePriority(priority);
        List list = this.threadQueue;
        synchronized (list) {
            isSchedulerInactive = this.scheduler == null;
        }
        if (isSchedulerInactive && this.isOkToStart()) {
            this.startWorkThread(workThread, priority);
        } else {
            list = this.threadQueue;
            synchronized (list) {
                this.threadQueue.add(new WorkThreadEntry(workThread, priority));
                isSchedulerInactive = this.scheduler == null;
            }
            if (isSchedulerInactive) {
                this.scheduler = new SchedulerThread();
                this.scheduler.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(IWorkThread workThread, int newPriority) {
        newPriority = this.prunePriority(newPriority);
        boolean notDone = true;
        List list = this.threadQueue;
        synchronized (list) {
            Iterator pendingWorkThreads = this.threadQueue.iterator();
            while (pendingWorkThreads.hasNext()) {
                WorkThreadEntry entry = (WorkThreadEntry)pendingWorkThreads.next();
                if (entry.workThread != workThread) continue;
                entry.priority = newPriority;
                notDone = false;
                break;
            }
        }
        if (notDone) {
            Thread workExecutionThread = null;
            Map map = this.activeThreads;
            synchronized (map) {
                workExecutionThread = (Thread)this.activeThreads.get(workThread);
            }
            if (workExecutionThread != null) {
                workExecutionThread.setPriority(newPriority);
            }
        }
    }

    protected class SchedulerThread
    extends Thread {
        protected SchedulerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (ThreadManager.this.isOkToStart()) {
                    WorkThreadEntry workThreadEntry = null;
                    List list = ThreadManager.this.threadQueue;
                    synchronized (list) {
                        if (ThreadManager.this.threadQueue.size() > 0) {
                            workThreadEntry = (WorkThreadEntry)ThreadManager.this.threadQueue.remove(0);
                        } else {
                            ThreadManager.this.scheduler = null;
                        }
                    }
                    if (workThreadEntry == null) {
                        return;
                    }
                    ThreadManager.this.startWorkThread(workThreadEntry.workThread, workThreadEntry.priority);
                    try {
                        SchedulerThread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    SchedulerThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    protected static class WorkThreadEntry {
        public IWorkThread workThread;
        public int priority;

        public WorkThreadEntry(IWorkThread wt, int p) {
            this.workThread = wt;
            this.priority = p;
        }
    }

    public static interface IWorkThread {
        public void doWork();

        public void done();

        public RcvrWorkThreadException getWorkException();

        public void setWorkException(RcvrWorkThreadException var1);
    }
}

