/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.model.ToActr;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOException;
import edu.cmu.cs.hcii.cogtool.util.RcvrIllegalStateException;
import edu.cmu.cs.hcii.cogtool.util.RcvrInterprocessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Subprocess {
    protected static final File LISP_DEBUG_FILE = new File("lisp", "cogtool-lisp-debug.lisp");

    private Subprocess() {
    }

    public static int exec(List cmd, List outLines, List errLines) {
        return Subprocess.exec(cmd, null, null, outLines, errLines);
    }

    public static int exec(List cmd, List envp, File workingDir, final List outLines, List errLines) {
        String[] cmdArray = cmd.toArray(new String[cmd.size()]);
        String[] envArray = null;
        if (envp != null) {
            envArray = envp.toArray(new String[cmd.size()]);
        }
        System.out.print("CMD: ");
        for (int i = 0; i < cmdArray.length; ++i) {
            if (cmdArray[i] == null) continue;
            if (cmdArray[i].length() > 0 && cmdArray[i].charAt(0) == '(') {
                System.out.print("'" + cmdArray[i] + "'");
            } else {
                System.out.print(cmdArray[i]);
            }
            System.out.print(' ');
        }
        System.out.println();
        try {
            Process p = Runtime.getRuntime().exec(cmdArray, envArray, workingDir);
            final BufferedReader outReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader errReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        String output = outReader.readLine();
                        while (output != null) {
                            System.out.println("[stdout] " + output);
                            if (outLines != null) {
                                outLines.add(output);
                            }
                            output = outReader.readLine();
                        }
                    }
                    catch (IOException e) {
                        throw new RcvrIOException("subprocess output reader IOException", e);
                    }
                }
            }, "subprocess output reader");
            t.start();
            String output = errReader.readLine();
            while (output != null) {
                System.out.println("[stderr] " + output);
                if (errLines != null) {
                    errLines.add(output);
                }
                output = errReader.readLine();
            }
            t.join();
            return p.waitFor();
        }
        catch (IOException e) {
            throw new RcvrIOException("IOException reading subprocess error stream", e);
        }
        catch (InterruptedException e) {
            throw new RcvrInterprocessException("Subprocess or stdout reading thread interrupted", e);
        }
    }

    public static int execLisp(String memoryImageName, List filesToLoad, String initialCommand, List outLines, List errLines) {
        Iterator<String> it;
        String lispProgName = null;
        String osName = null;
        if (OSUtils.WINDOWS) {
            lispProgName = "lisp.exe";
            osName = "win";
        } else if (OSUtils.MACOSX) {
            lispProgName = "lisp.run";
            osName = OSUtils.isIntelMac() ? "mac-intel" : "mac-ppc";
        } else {
            throw new RcvrIllegalStateException("Unknown Operating System");
        }
        File clispDir = new File("clisp-" + osName);
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(new File(clispDir, lispProgName).getPath());
        cmdList.add("-q");
        cmdList.add("-M");
        cmdList.add(new File(clispDir, memoryImageName).getPath());
        if (LISP_DEBUG_FILE.exists()) {
            cmdList.add("-i");
            cmdList.add(LISP_DEBUG_FILE.getPath());
        }
        if (filesToLoad != null) {
            it = filesToLoad.iterator();
            while (it.hasNext()) {
                cmdList.add("-i");
                cmdList.add(((File)it.next()).getPath());
            }
        }
        cmdList.add("-x");
        cmdList.add(initialCommand);
        if (OSUtils.WINDOWS) {
            it = cmdList.listIterator();
            while (it.hasNext()) {
                String cmd = (String)it.next();
                if (cmd == null || cmd.length() <= 0 || cmd.charAt(0) != '(') continue;
                it.set("\"" + ToActr.clean(cmd) + "\"");
            }
        }
        return Subprocess.exec(cmdList, outLines, errLines);
    }
}

