/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class SashUtility {
    public static int sashPercentage = -1;

    public static Sash createVerticalSash(final Composite parent, final int minSize, final int maxSize, int loc, Composite editor, FormData editorData, Composite props, FormData propsData) {
        parent.setLayout((Layout)new FormLayout());
        final FormData sashData = new FormData();
        final Sash sash = new Sash(parent, 66048);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Rectangle shellRect = parent.getClientArea();
                int width = shellRect.width;
                int limitMaxPercentage = PrecisionUtilities.round((double)maxSize / (double)width * 100.0);
                int limitMinPercentage = PrecisionUtilities.round((double)minSize / (double)width * 100.0);
                sashPercentage = PrecisionUtilities.round((double)e.x / (double)width * 100.0);
                sashPercentage = Math.max(Math.min(sashPercentage, 100 - limitMaxPercentage), limitMinPercentage);
                e.x = PrecisionUtilities.round((double)width * (double)sashPercentage / 100.0);
                sashData.left = new FormAttachment(sashPercentage, 0);
                parent.layout();
            }
        });
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle sashRect = sash.getBounds();
                Rectangle shellRect = parent.getClientArea();
                int width = shellRect.width;
                int limitMaxPercentage = PrecisionUtilities.round((double)maxSize / (double)width * 100.0);
                int limitMinPercentage = PrecisionUtilities.round((double)minSize / (double)width * 100.0);
                if (sashPercentage > 100 - limitMaxPercentage) {
                    sashPercentage = 100 - limitMaxPercentage;
                } else if (sashPercentage < limitMinPercentage) {
                    sashPercentage = limitMinPercentage;
                }
                sashRect.x = PrecisionUtilities.round((double)width * (double)sashPercentage / 100.0);
                sash.setBounds(sashRect);
                sashData.left = new FormAttachment(sashPercentage, 0);
                parent.layout();
            }
        });
        sashData.left = sashPercentage == -1 ? new FormAttachment(100, -maxSize) : new FormAttachment(sashPercentage, 0);
        sashData.top = new FormAttachment(0, 0);
        sashData.bottom = new FormAttachment(100, 0);
        sash.setLayoutData((Object)sashData);
        editorData.right = new FormAttachment((Control)sash, 0, 16384);
        editor.setLayoutData((Object)editorData);
        propsData.left = new FormAttachment((Control)sash, 0, 131072);
        props.setLayoutData((Object)propsData);
        return sash;
    }
}

