/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public abstract class SWTTextEditor
extends Text {
    public static final int LEFT_JUSTIFY = 16384;
    public static final int CENTER_TEXT = 0x1000000;
    protected static final int KEEP_FOCUS = 0;
    protected static final int MOVE_FOCUS = 1;
    protected static final int LOSE_FOCUS = 2;

    public SWTTextEditor(Composite parent, int justification) {
        super(parent, 4 | justification);
        this.setVisible(false);
        this.addKeyListener(this.getKeyListener());
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SWTTextEditor.this.confirmRename(2);
            }
        });
    }

    protected TextKeyListener getKeyListener() {
        return new TextKeyListener();
    }

    protected abstract void confirmRename(int var1);

    protected void cancelRename() {
        this.cleanup();
    }

    public void editText(String initialText, IFigure data, double scale) {
        this.setText(initialText);
        this.setData(data);
        this.setVisible(true);
        this.selectAll();
        this.setFocus();
        this.repaintTextEditor(scale);
        this.redraw();
    }

    public boolean inUse() {
        return this.isVisible();
    }

    public void cleanup() {
        this.setVisible(false);
        this.setText("");
    }

    protected int computeX(Rectangle bounds, double scale, int offset) {
        return PrecisionUtilities.round((double)bounds.x * scale) + offset;
    }

    protected int computeY(Rectangle bounds, double scale, int offset) {
        return PrecisionUtilities.round((double)bounds.y * scale) + offset;
    }

    protected int computeWidth(Rectangle bounds, double scale, int offset) {
        return PrecisionUtilities.round((double)bounds.width * scale) - 2 * offset;
    }

    protected int computeHeight(Rectangle bounds, double scale, int offset) {
        return PrecisionUtilities.round((double)bounds.height * scale) - 2 * offset;
    }

    protected Font getFontToUse() {
        return ((IFigure)this.getData()).getFont();
    }

    protected int computeFontHeight(int editorHeight, double scale, int offset) {
        int heightAdjustment = OSUtils.MACOSX ? 3 : (int)(3.0 * scale + 1.0);
        return editorHeight - 2 * heightAdjustment;
    }

    public void repaintTextEditor(double scale) {
        if (this.getVisible()) {
            Rectangle bounds = ((IFigure)this.getData()).getBounds();
            int offset = OSUtils.MACOSX ? -2 : 1;
            int x = this.computeX(bounds, scale, offset);
            int y = this.computeY(bounds, scale, offset);
            this.setLocation(x, y);
            int width = this.computeWidth(bounds, scale, offset);
            int height = this.computeHeight(bounds, scale, offset);
            this.setSize(width, height);
            Font font = this.getFontToUse();
            if (font == null) {
                return;
            }
            FontData[] fontData = font.getFontData();
            if (fontData == null) {
                return;
            }
            if (fontData.length > 0) {
                String fontName = fontData[0].getName();
                int fontStyle = fontData[0].getStyle();
                FontData newFontData = new FontData(fontName, this.computeFontHeight(height, scale, offset), fontStyle);
                this.setFont(new Font((Device)WindowUtil.globalDisplay, newFontData));
            }
        }
    }

    protected void checkSubclass() {
    }

    public class TextKeyListener
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 10 || e.keyCode == 13) {
                SWTTextEditor.this.confirmRename(0);
            } else if (e.keyCode == 9) {
                SWTTextEditor.this.confirmRename(1);
            } else if (e.keyCode == 27) {
                SWTTextEditor.this.cancelRename();
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

