/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.Enumerated;
import edu.cmu.cs.hcii.cogtool.util.ObjectPersist;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ecf.core.util.Base64;

public class ObjectSaver
implements ObjectPersist {
    protected static Map saverRegistry = new HashMap();
    protected Map savedObjects = new IdentityHashMap();
    protected Writer sink;
    protected String indent = "";
    protected int idGen = 1;
    protected Object purpose;

    public ObjectSaver(Writer objectSink) throws IOException {
        this(objectSink, null);
    }

    public ObjectSaver(Writer objectSink, Object savePurpose) throws IOException {
        this.sink = objectSink;
        this.purpose = savePurpose;
        this.sink.write("<persist" + this.addAttribute("version", Integer.toString(2)) + this.addAttribute("cogtool_version", System.getProperty("cogtool.version")) + this.addAttribute("cogtool_revision", System.getProperty("cogtool.revision")) + this.addAttribute("cogtool_buildtime", System.getProperty("cogtool.build")) + this.addAttribute("java_version", System.getProperty("java.version")) + this.addAttribute("os_version", System.getProperty("os.version")) + this.addAttribute("os_name", System.getProperty("os.name")) + ">\n");
    }

    public void finish() throws IOException {
        this.sink.write("</persist>\n");
        this.sink.flush();
    }

    public Object getPurpose() {
        return this.purpose;
    }

    public static void registerSaver(String className, IDataSaver saver) {
        saverRegistry.put(className, saver);
    }

    public static IDataSaver getSaver(String className) {
        return (IDataSaver)saverRegistry.get(className);
    }

    protected String quote(String str) {
        return str != null ? str.replaceAll("\"", "&quot;") : "";
    }

    protected String addAttribute(String attr, String value) {
        return " " + attr + "=\"" + this.quote(value) + "\"";
    }

    protected String addVariableAttribute(String variable) {
        return variable != null ? this.addAttribute("var", variable) : "";
    }

    public void saveInt(int value) throws IOException {
        this.saveInt(value, null);
    }

    public void saveDouble(double value) throws IOException {
        this.saveDouble(value, null);
    }

    public void saveBoolean(boolean value) throws IOException {
        this.saveBoolean(value, null);
    }

    public void saveString(String value) throws IOException {
        this.saveString(value, null);
    }

    public void saveChar(char value) throws IOException {
        this.saveChar(value, null);
    }

    public void saveObject(Object value) throws IOException {
        this.saveObject(value, null);
    }

    public void saveInt(int value, String variable) throws IOException {
        this.sink.write(this.indent + "<" + "int" + this.addVariableAttribute(variable) + this.addAttribute("val", Integer.toString(value)) + "/>\n");
    }

    public void saveDouble(double value, String variable) throws IOException {
        this.sink.write(this.indent + "<" + "dbl" + this.addVariableAttribute(variable) + this.addAttribute("val", Double.toString(value)) + "/>\n");
    }

    public void saveBoolean(boolean value, String variable) throws IOException {
        this.sink.write(this.indent + "<" + "bool" + this.addVariableAttribute(variable) + this.addAttribute("val", value ? "t" : "f") + "/>\n");
    }

    public void saveString(String value, String variable) throws IOException {
        if (value == null) {
            this.sink.write(this.indent + "<" + "null" + this.addVariableAttribute(variable) + "/>\n");
        } else {
            this.sink.write(this.indent + "<" + "str" + this.addVariableAttribute(variable) + this.addAttribute("size", Integer.toString(value.length())) + "><![CDATA[" + value + "@" + "]]></" + "str" + ">\n");
        }
    }

    public void saveChar(char value, String variable) throws IOException {
        this.sink.write(this.indent + "<" + "char" + this.addVariableAttribute(variable) + "><![CDATA[" + Character.toString(value) + "@" + "]]></" + "char" + ">\n");
    }

    protected void saveReference(Integer id, String variable) throws IOException {
        this.sink.write(this.indent + "<" + "ref" + this.addVariableAttribute(variable) + this.addAttribute("idref", id.toString()) + "/>\n");
    }

    protected void saveEnum(String className, IDataSaver saver, Object value, String variable) throws IOException {
        String version = Integer.toString(saver.getVersion());
        String enumCode = ((Enumerated)value).persistenceValue();
        this.sink.write(this.indent + "<" + "enum" + this.addVariableAttribute(variable) + this.addAttribute("val", enumCode) + this.addAttribute("class", className) + this.addAttribute("version", version) + "/>\n");
    }

    protected void saveArray(Class valueClass, Object value, Integer id, String variable) throws IOException {
        Class<?> eltType = valueClass.getComponentType();
        if (eltType == Byte.TYPE) {
            String encoded = Base64.encode((byte[])((byte[])value));
            this.sink.write(this.indent + "<" + "byte" + this.addVariableAttribute(variable) + this.addAttribute("id", id.toString()) + this.addAttribute("size", Integer.toString(encoded.length())) + ">");
            this.sink.write(encoded);
            this.sink.write("</byte>\n");
        } else {
            int count = Array.getLength(value);
            this.sink.write(this.indent + "<" + "arr" + this.addVariableAttribute(variable) + this.addAttribute("id", id.toString()) + this.addAttribute("class", eltType.getName()) + this.addAttribute("size", Integer.toString(count)) + ">\n");
            String oldIndent = this.indent;
            this.indent = this.indent + " ";
            if (eltType.isPrimitive()) {
                if (eltType == Integer.TYPE) {
                    for (int i = 0; i < count; ++i) {
                        this.saveInt(Array.getInt(value, i));
                    }
                } else if (eltType == Double.TYPE) {
                    for (int i = 0; i < count; ++i) {
                        this.saveDouble(Array.getDouble(value, i));
                    }
                } else if (eltType == Boolean.TYPE) {
                    for (int i = 0; i < count; ++i) {
                        this.saveBoolean(Array.getBoolean(value, i));
                    }
                } else if (eltType == Character.TYPE) {
                    for (int i = 0; i < count; ++i) {
                        this.saveChar(Array.getChar(value, i));
                    }
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    this.saveObject(Array.get(value, i));
                }
            }
            this.indent = oldIndent;
            this.sink.write(this.indent + "</" + "arr" + ">\n");
        }
    }

    protected void saveMap(Map mapping, Integer id, String variable) throws IOException {
        int count = mapping.size();
        this.sink.write(this.indent + "<" + "map" + this.addVariableAttribute(variable) + this.addAttribute("id", id.toString()) + this.addAttribute("size", Integer.toString(count)) + ">\n");
        String oldIndent = this.indent;
        this.indent = this.indent + " ";
        Iterator pairs = mapping.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry entry = pairs.next();
            this.sink.write(this.indent + "<" + "key" + ">\n");
            String currentIndent = this.indent;
            this.indent = this.indent + " ";
            this.saveObject(entry.getKey());
            this.indent = currentIndent;
            this.sink.write(this.indent + "</" + "key" + ">\n");
            this.saveObject(entry.getValue());
        }
        this.indent = oldIndent;
        this.sink.write(this.indent + "</" + "map" + ">\n");
    }

    protected void saveCollection(Collection elts, Integer id, String variable) throws IOException {
        int count = elts.size();
        this.sink.write(this.indent + "<" + "elts" + this.addVariableAttribute(variable) + this.addAttribute("id", id.toString()) + this.addAttribute("size", Integer.toString(count)) + ">\n");
        String oldIndent = this.indent;
        this.indent = this.indent + " ";
        Iterator eltIt = elts.iterator();
        while (eltIt.hasNext()) {
            this.saveObject(eltIt.next());
        }
        this.indent = oldIndent;
        this.sink.write(this.indent + "</" + "elts" + ">\n");
    }

    public void saveObject(Object value, String variable) throws IOException {
        if (value == null) {
            this.sink.write(this.indent + "<" + "null" + this.addVariableAttribute(variable) + "/>\n");
        } else {
            Integer id = (Integer)this.savedObjects.get(value);
            if (id != null) {
                this.saveReference(id, variable);
            } else {
                Class<?> valueClass = value.getClass();
                if (valueClass == Integer.class) {
                    this.saveInt((Integer)value, variable);
                } else if (valueClass == Double.class) {
                    this.saveDouble((Double)value, variable);
                } else if (valueClass == Boolean.class) {
                    this.saveBoolean((Boolean)value, variable);
                } else if (valueClass == String.class) {
                    this.saveString((String)value, variable);
                } else if (valueClass == Character.class) {
                    this.saveChar(((Character)value).charValue(), variable);
                } else {
                    String className = valueClass.getName();
                    IDataSaver saver = ObjectSaver.getSaver(className);
                    if (saver != null && saver.isEnum()) {
                        this.saveEnum(className, saver, value, variable);
                    } else {
                        id = new Integer(this.idGen++);
                        this.savedObjects.put(value, id);
                        if (valueClass.isArray()) {
                            this.saveArray(valueClass, value, id, variable);
                        } else if (Map.class.isAssignableFrom(valueClass)) {
                            this.saveMap((Map)value, id, variable);
                        } else if (Collection.class.isAssignableFrom(valueClass)) {
                            this.saveCollection((Collection)value, id, variable);
                        } else {
                            if (saver == null) {
                                throw new IllegalStateException("no saver found for: " + className);
                            }
                            String version = Integer.toString(saver.getVersion());
                            this.sink.write(this.indent + "<" + "obj" + this.addVariableAttribute(variable) + this.addAttribute("id", id.toString()) + this.addAttribute("class", className) + this.addAttribute("version", version) + ">\n");
                            String oldIndent = this.indent;
                            this.indent = this.indent + " ";
                            this.saveAsSuper(value, valueClass);
                            saver.saveData(value, this);
                            this.indent = oldIndent;
                            this.sink.write(this.indent + "</" + "obj" + ">\n");
                        }
                    }
                }
            }
        }
    }

    public Object filterObject(Object value) throws IOException {
        return value;
    }

    protected void saveAsSuper(Object obj, Class subclass) throws IOException {
        Class superclass;
        String superclassName;
        IDataSaver saver;
        if (subclass != Object.class && (saver = ObjectSaver.getSaver(superclassName = (superclass = subclass.getSuperclass()).getName())) != null) {
            this.saveAsSuper(obj, superclass);
            this.saveSuper(obj, superclassName, saver);
        }
    }

    protected void saveSuper(Object value, String className, IDataSaver saver) throws IOException {
        this.sink.write(this.indent + "<" + "sup" + this.addAttribute("class", className) + this.addAttribute("version", Integer.toString(saver.getVersion())) + ">\n");
        String oldIndent = this.indent;
        this.indent = this.indent + " ";
        saver.saveData(value, this);
        this.indent = oldIndent;
        this.sink.write(this.indent + "</" + "sup" + ">\n");
    }

    public static class ADataSaver
    implements IDataSaver {
        public boolean isEnum() {
            return false;
        }

        public void saveData(Object value, ObjectSaver saver) throws IOException {
            throw new UnsupportedOperationException("saveData");
        }

        public int getVersion() {
            throw new UnsupportedOperationException("getVersion");
        }
    }

    public static interface IDataSaver {
        public int getVersion();

        public boolean isEnum();

        public void saveData(Object var1, ObjectSaver var2) throws IOException;
    }
}

