/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.IPersist;
import edu.cmu.cs.hcii.cogtool.util.ObjectLoader;
import edu.cmu.cs.hcii.cogtool.util.ObjectSaver;
import edu.cmu.cs.hcii.cogtool.util.ZipUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ObjectPersister
implements IPersist {
    protected static final String PERSIST_FILE = "PERSIST";
    protected static final File tmpDir = new File(System.getProperty("java.io.tmpdir"));
    protected static String tmpFilePrefix = "CGT";
    protected static String ckpFileSuffix = ".ckp";
    protected Map fileInfos = new HashMap();
    private Map objInfos = new HashMap();

    protected PersistInfo getInfoByObject(Object obj) {
        return (PersistInfo)this.objInfos.get(obj);
    }

    protected PersistInfo getInfoByName(String canonicalFileName) {
        return (PersistInfo)this.fileInfos.get(canonicalFileName);
    }

    protected static void checkDiskSpace(File dstFile, long size, String msg) throws FileNotFoundException, IOException {
        RandomAccessFile rndFile = new RandomAccessFile(dstFile, "rw");
        try {
            rndFile.setLength(size);
        }
        catch (IOException e) {
            IOException newE = new IOException(msg);
            newE.initCause(e);
            throw newE;
        }
        finally {
            rndFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long diskSize(File file) throws IOException {
        if (file.isFile()) {
            long size;
            RandomAccessFile f = null;
            try {
                f = new RandomAccessFile(file, "r");
                size = f.length();
            }
            finally {
                if (f != null) {
                    f.close();
                }
            }
            return size;
        }
        File[] files = file.listFiles();
        long sum = 0L;
        for (int i = 0; i < files.length; ++i) {
            sum += ObjectPersister.diskSize(files[i]);
        }
        return sum;
    }

    protected static File createTempDirectory() throws IOException {
        File uniqueFileName = File.createTempFile(tmpFilePrefix, ckpFileSuffix, tmpDir);
        File tmpDirName = uniqueFileName.getCanonicalFile();
        if (!uniqueFileName.delete()) {
            throw new IOException("Could not delete temp filename");
        }
        if (!tmpDirName.mkdir()) {
            throw new IOException("Could not register temp directory");
        }
        return tmpDirName;
    }

    protected static void deleteAll(File fileOrDir) {
        if (fileOrDir.exists()) {
            if (fileOrDir.isFile()) {
                if (!fileOrDir.delete()) {
                    fileOrDir.deleteOnExit();
                }
            } else if (fileOrDir.isDirectory()) {
                File[] files = fileOrDir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    ObjectPersister.deleteAll(files[i]);
                }
                if (!fileOrDir.delete()) {
                    fileOrDir.deleteOnExit();
                }
            }
        }
    }

    public boolean isPermanent(Object obj) {
        PersistInfo info = this.getInfoByObject(obj);
        return info.originalFile != null;
    }

    public void registerForPersistence(Object obj) throws IOException {
        File chkptFile = ObjectPersister.createTempDirectory();
        PersistInfo info = new PersistInfo(obj, chkptFile);
        this.objInfos.put(obj, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(File src) throws IOException {
        String canonicalFileName = src.getCanonicalPath();
        PersistInfo info = this.getInfoByName(canonicalFileName);
        if (info != null) {
            return info.obj;
        }
        File sizeCheckFile = File.createTempFile(tmpFilePrefix, ".size", tmpDir);
        try {
            ObjectPersister.checkDiskSpace(sizeCheckFile, 3L * src.length(), "Not enough temp space on disk to open file: " + src);
        }
        finally {
            sizeCheckFile.delete();
        }
        File chkptFile = ObjectPersister.createTempDirectory();
        ZipFile zip = null;
        try {
            zip = new ZipFile(src);
            ZipUtil.unzip(zip, chkptFile);
        }
        catch (ZipException ex) {
            IOException newE = new IOException("load encountered zip compression error");
            newE.initCause(ex);
            throw newE;
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
        ObjectLoader l = new ObjectLoader();
        Object obj = null;
        Reader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(new File(chkptFile, PERSIST_FILE)), "UTF-8");
            Collection objSet = l.load(new InputSource(reader), null);
            Iterator objs = objSet.iterator();
            if (objs.hasNext()) {
                obj = objs.next();
            }
            info = new PersistInfo(obj, chkptFile, src);
            this.objInfos.put(obj, info);
            this.fileInfos.put(canonicalFileName, info);
        }
        catch (ParserConfigurationException e) {
            IOException newE = new IOException("load encountered parser error");
            newE.initCause(e);
            throw newE;
        }
        catch (SAXException e) {
            IOException newE = new IOException("load encountered SAX error");
            newE.initCause(e);
            throw newE;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return obj;
    }

    public Object[] recoverFiles() throws IOException {
        File[] chkptDirs = tmpDir.listFiles(PrefixFilter.ONLY);
        ObjectLoader l = new ObjectLoader();
        Object[] recovered = new Object[chkptDirs.length];
        for (int i = 0; i < recovered.length; ++i) {
            InputStreamReader reader = null;
            try {
                reader = new FileReader(new File(chkptDirs[i], PERSIST_FILE));
                recovered[i] = l.load(new InputSource(reader), null);
                PersistInfo info = new PersistInfo(recovered[i], chkptDirs[i]);
                this.objInfos.put(recovered[i], info);
                continue;
            }
            catch (ParserConfigurationException e) {
                IOException newE = new IOException("load encountered parser error");
                newE.initCause(e);
                throw newE;
            }
            catch (SAXException e) {
                IOException newE = new IOException("load encountered SAX error");
                newE.initCause(e);
                throw newE;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return recovered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(Object obj) throws IOException {
        PersistInfo info = this.getInfoByObject(obj);
        if (info == null) {
            throw new IllegalArgumentException("Cannot find persistence info for given object");
        }
        File chkpt = new File(info.checkpointDir, PERSIST_FILE);
        File oldChkpt = null;
        if (chkpt.exists()) {
            oldChkpt = new File(info.checkpointDir, "PERSIST.old");
            if (oldChkpt.exists()) {
                oldChkpt.delete();
            }
            if (!chkpt.renameTo(oldChkpt)) {
                throw new IOException("Cannot rename old checkpoint file");
            }
        }
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(chkpt), "UTF-8");
            ObjectSaver s = new ObjectSaver(writer);
            s.saveObject(obj);
            s.finish();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        if (oldChkpt != null && !oldChkpt.delete()) {
            throw new IOException("Cannot delete old checkpoint file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Object obj, File dst) throws IOException {
        PersistInfo info = this.getInfoByObject(obj);
        if (info == null) {
            throw new IllegalArgumentException("Cannot find persistence info for given object");
        }
        if (dst == null) {
            if (info.originalFile == null) {
                throw new IllegalStateException("Unspecified save location!");
            }
            dst = info.originalFile;
        }
        this.checkpoint(obj);
        File tmp = File.createTempFile(tmpFilePrefix, ".cgt", dst.getParentFile());
        try {
            ObjectPersister.checkDiskSpace(tmp, ObjectPersister.diskSize(info.checkpointDir), "Insufficient space to save project to file: " + dst);
        }
        finally {
            tmp.delete();
        }
        File[] files = info.checkpointDir.listFiles();
        ZipUtil.zip(Arrays.asList(files), tmp);
        if (dst.exists() && !dst.delete()) {
            throw new IOException("File cannot be deleted: " + dst.getAbsolutePath());
        }
        tmp.renameTo(dst);
        String originalCanonicalPath = info.originalFile != null ? info.originalFile.getCanonicalPath() : "";
        String dstCanonicalPath = dst.getCanonicalPath();
        if (!dstCanonicalPath.equals(originalCanonicalPath)) {
            this.fileInfos.remove(originalCanonicalPath);
            info.originalFile = new File(dstCanonicalPath);
            this.fileInfos.put(dstCanonicalPath, info);
        }
    }

    public void close(Object obj) throws IOException {
        PersistInfo info = this.getInfoByObject(obj);
        if (info == null) {
            throw new IllegalArgumentException("Cannot find persistence info for given object");
        }
        ObjectPersister.deleteAll(info.checkpointDir);
        this.objInfos.remove(obj);
        if (info.originalFile != null) {
            this.fileInfos.remove(info.originalFile.getCanonicalPath());
        }
    }

    public boolean isRegistered(File dst, Object obj) throws IOException {
        String canonicalFileName = dst.getCanonicalPath();
        PersistInfo info = this.getInfoByName(canonicalFileName);
        if (info != null) {
            return info.obj != obj;
        }
        return false;
    }

    protected static class PrefixFilter
    implements FileFilter {
        public static final PrefixFilter ONLY = new PrefixFilter();

        private PrefixFilter() {
        }

        public boolean accept(File f) {
            String fName = f.getName();
            return f.isDirectory() && fName.startsWith(tmpFilePrefix) && fName.endsWith(ckpFileSuffix);
        }
    }

    protected static class PersistInfo {
        public Object obj;
        public File checkpointDir;
        public File originalFile;

        public PersistInfo(Object o, File chkptFile) {
            this(o, chkptFile, null);
        }

        public PersistInfo(Object o, File chkptFile, File origFile) {
            this.obj = o;
            this.checkpointDir = chkptFile;
            this.originalFile = origFile;
        }
    }
}

