/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.ObjectPersist;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.ecf.core.util.Base64;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ObjectLoader
extends DefaultHandler
implements ObjectPersist {
    protected static Map loaderRegistry = new HashMap();
    protected Stack activeLoaders = new Stack();
    protected Stack pendingObjects = new Stack();
    protected Map loadedObjects = new HashMap();
    protected static final int ARRAY_STACK_DEPTH = 100;
    protected int[] arrayIndexes = new int[100];
    protected int arrayStackTop = -1;
    static SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    protected static final int NORMAL = 0;
    protected static final int IN_STRING = 1;
    protected static final int IN_CHAR = 2;
    protected static final int IN_BYTES = 3;
    protected static final int ASSIGNED = -1;
    protected int assignmentState = 0;
    protected int idref;
    protected static final char NONE = ' ';
    protected static final char IN_OBJECT = 'o';
    protected static final char IN_ARRAY = 'a';
    protected static final char IN_COLLECTION = 'c';
    protected static final char IN_MAP = 'm';
    protected static final char IN_KEY = 'k';
    protected char objectState = (char)32;
    protected StringBuffer stateStack = new StringBuffer();
    protected Object entryKey;
    protected String pendingVariable;
    protected int stringLength;
    protected StringBuffer accumulator = new StringBuffer();

    public static void registerLoader(String className, int version, IObjectLoader loader) {
        loaderRegistry.put(className + "#" + Integer.toString(version), loader);
    }

    public static IObjectLoader getLoader(String className, int version) {
        return (IObjectLoader)loaderRegistry.get(className + "#" + Integer.toString(version));
    }

    public static void registerEnumLoader(String className, int version, IEnumLoader loader) {
        loaderRegistry.put(className + "#" + Integer.toString(version), loader);
    }

    public static IEnumLoader getEnumLoader(String className, int version) {
        return (IEnumLoader)loaderRegistry.get(className + "#" + Integer.toString(version));
    }

    public Object getPendingObject(int depthIndex) {
        if (depthIndex < 0) {
            throw new IllegalArgumentException("Index cannot be negative.");
        }
        int lastValidStackIndex = this.pendingObjects.size() - 1;
        if (depthIndex > lastValidStackIndex) {
            return null;
        }
        return this.pendingObjects.get(lastValidStackIndex - depthIndex);
    }

    public Object getPendingObject(Class ofType) {
        return this.getPendingObject(ofType, 0);
    }

    public Object getPendingObject(Class ofType, int depthIndexOfType) {
        if (depthIndexOfType < 0) {
            throw new IllegalArgumentException("Index cannot be negative.");
        }
        for (int i = this.pendingObjects.size() - 1; i >= 0; --i) {
            Object pendingObject = this.pendingObjects.get(i);
            if (!ofType.isInstance(pendingObject)) continue;
            if (depthIndexOfType == 0) {
                return pendingObject;
            }
            --depthIndexOfType;
        }
        return null;
    }

    public Collection load(InputSource src, IAggregateLoader initialLoader) throws ParserConfigurationException, SAXException, IOException {
        this.activeLoaders.push(initialLoader != null ? initialLoader : AAggregateLoader.ONLY);
        this.pendingObjects.push(new ArrayList());
        this.pushObjectState('c');
        SAXParser p = parserFactory.newSAXParser();
        p.parse(src, (DefaultHandler)this);
        return (Collection)this.pendingObjects.peek();
    }

    protected void pushObjectState(char newObjectState) {
        this.stateStack.append(this.objectState);
        this.objectState = newObjectState;
    }

    protected void popObjectState() {
        int lastIndex = this.stateStack.length() - 1;
        this.objectState = this.stateStack.charAt(lastIndex);
        this.stateStack.deleteCharAt(lastIndex);
    }

    protected void pushObject(Attributes attrs, Object value, ILoader loader, char newState) {
        this.loadedObjects.put(new Integer(this.getIntAttribute(attrs, "id")), value);
        this.pendingObjects.push(value);
        this.activeLoaders.push(loader);
        this.pushObjectState(newState);
    }

    protected void pushArrayIndex() {
        if (++this.arrayStackTop < 100) {
            throw new IndexOutOfBoundsException("array nesting too deep");
        }
        this.arrayIndexes[this.arrayStackTop] = 0;
    }

    protected void popArrayIndex() {
        --this.arrayStackTop;
    }

    protected int nextArrayIndex() {
        int n = this.arrayStackTop;
        int n2 = this.arrayIndexes[n];
        this.arrayIndexes[n] = n2 + 1;
        return n2;
    }

    private void printAttrs(Attributes attrs) {
        int count = attrs.getLength();
        for (int i = 0; i < count; ++i) {
            System.out.println("    " + attrs.getQName(i) + ": " + attrs.getValue(i));
        }
    }

    protected int getIntAttribute(Attributes attrs, String key) {
        return Integer.parseInt(attrs.getValue(key));
    }

    protected double getDoubleAttribute(Attributes attrs, String key) {
        return Double.parseDouble(attrs.getValue(key));
    }

    protected boolean getBooleanAttribute(Attributes attrs, String key) {
        return attrs.getValue(key).equalsIgnoreCase("t");
    }

    protected char getCharAttribute(Attributes attrs, String key) {
        return attrs.getValue(key).charAt(0);
    }

    protected String getStringAttribute(Attributes attrs, String key) {
        return attrs.getValue(key);
    }

    protected String getVariable(Attributes attrs) {
        String variable = this.getStringAttribute(attrs, "var");
        if (variable == null) {
            throw new IllegalStateException("variable attribute not found");
        }
        return variable;
    }

    protected void addObject(Attributes attrs, Object value) {
        this.addObject((ILoader)this.activeLoaders.peek(), attrs, value);
    }

    protected void addObject(ILoader loader, Attributes attrs, Object value) {
        switch (this.objectState) {
            case 'o': {
                IObjectLoader objectLoader = (IObjectLoader)loader;
                objectLoader.set(this, this.pendingObjects.peek(), this.getVariable(attrs), value);
                break;
            }
            case 'a': {
                IAggregateLoader aggLoader = (IAggregateLoader)loader;
                aggLoader.addToArray(this, this.pendingObjects.peek(), this.nextArrayIndex(), value);
                break;
            }
            case 'c': {
                IAggregateLoader aggLoader = (IAggregateLoader)loader;
                aggLoader.addToCollection(this, (Collection)this.pendingObjects.peek(), value);
                break;
            }
            case 'k': {
                this.entryKey = value;
                break;
            }
            case 'm': {
                IAggregateLoader aggLoader = (IAggregateLoader)loader;
                aggLoader.putInMap(this, (Map)this.pendingObjects.peek(), this.entryKey, value);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (qName.equalsIgnoreCase("key")) {
            this.pushObjectState('k');
        } else if (qName.equalsIgnoreCase("arr")) {
            IAggregateLoader aggregateLoader;
            Object value;
            int eltCount = this.getIntAttribute(attrs, "size");
            String eltClass = this.getStringAttribute(attrs, "class");
            if (this.objectState == 'o') {
                String variable;
                IObjectLoader loader = (IObjectLoader)this.activeLoaders.peek();
                value = Array.newInstance(loader.getArrayEltType(this, variable = this.getVariable(attrs), eltClass), eltCount);
                if (value == null) {
                    throw new IllegalStateException("array create was not successful");
                }
                loader.set(this, this.pendingObjects.peek(), variable, value);
                aggregateLoader = loader.getLoader(this, variable);
            } else {
                IAggregateLoader loader = (IAggregateLoader)this.activeLoaders.peek();
                value = Array.newInstance(loader.getArrayEltType(this, eltClass), eltCount);
                if (value == null) {
                    throw new IllegalStateException("array create was not successful");
                }
                this.addObject(loader, attrs, value);
                aggregateLoader = loader.getLoader(this);
            }
            this.pushArrayIndex();
            this.pushObject(attrs, value, aggregateLoader, 'a');
        } else if (qName.equalsIgnoreCase("elts")) {
            IAggregateLoader aggregateLoader;
            Collection value;
            int eltCount = this.getIntAttribute(attrs, "size");
            if (this.objectState == 'o') {
                IObjectLoader loader = (IObjectLoader)this.activeLoaders.peek();
                String variable = this.getVariable(attrs);
                value = loader.createCollection(this, this.pendingObjects.peek(), variable, eltCount);
                if (value == null) {
                    throw new IllegalStateException("collection create was not successful");
                }
                aggregateLoader = loader.getLoader(this, variable);
            } else {
                IAggregateLoader loader = (IAggregateLoader)this.activeLoaders.peek();
                value = loader.createCollection(this, eltCount);
                if (value == null) {
                    throw new IllegalStateException("collection create was not successful");
                }
                this.addObject(loader, attrs, value);
                aggregateLoader = loader.getLoader(this);
            }
            this.pushObject(attrs, value, aggregateLoader, 'c');
        } else if (qName.equalsIgnoreCase("map")) {
            IAggregateLoader aggregateLoader;
            Map value;
            int eltCount = this.getIntAttribute(attrs, "size");
            if (this.objectState == 'o') {
                IObjectLoader loader = (IObjectLoader)this.activeLoaders.peek();
                String variable = this.getVariable(attrs);
                value = loader.createMap(this, this.pendingObjects.peek(), variable, eltCount);
                if (value == null) {
                    throw new IllegalStateException("map create was not successful for " + variable);
                }
                aggregateLoader = loader.getLoader(this, variable);
            } else {
                IAggregateLoader loader = (IAggregateLoader)this.activeLoaders.peek();
                value = loader.createMap(this, eltCount);
                if (value == null) {
                    throw new IllegalStateException("map create was not successful");
                }
                this.addObject(loader, attrs, value);
                aggregateLoader = loader.getLoader(this);
            }
            this.pushObject(attrs, value, aggregateLoader, 'm');
        } else if (qName.equalsIgnoreCase("obj")) {
            IObjectLoader loader = ObjectLoader.getLoader(this.getStringAttribute(attrs, "class"), this.getIntAttribute(attrs, "version"));
            if (loader == null) {
                throw new IllegalStateException("object class loader not found for class:" + this.getStringAttribute(attrs, "class") + " version " + this.getIntAttribute(attrs, "version"));
            }
            Object newObj = loader.createObject(this);
            if (newObj == null) {
                throw new IllegalStateException("object creation was not successful for class:" + this.getStringAttribute(attrs, "class") + " version " + this.getIntAttribute(attrs, "version"));
            }
            this.addObject(attrs, newObj);
            this.pushObject(attrs, newObj, loader, 'o');
        } else if (qName.equalsIgnoreCase("sup")) {
            IObjectLoader loader = ObjectLoader.getLoader(this.getStringAttribute(attrs, "class"), this.getIntAttribute(attrs, "version"));
            if (loader == null) {
                throw new IllegalStateException("super class loader not found for class:" + this.getStringAttribute(attrs, "class") + " version " + this.getIntAttribute(attrs, "version"));
            }
            this.activeLoaders.push(loader);
        } else if (qName.equalsIgnoreCase("ref")) {
            int id = this.getIntAttribute(attrs, "idref");
            Object refObject = this.loadedObjects.get(new Integer(id));
            if (refObject == null) {
                throw new IllegalStateException("ref object with id=" + id + " not found");
            }
            this.addObject(attrs, refObject);
        } else if (qName.equalsIgnoreCase("null")) {
            this.addObject(attrs, null);
        } else if (qName.equalsIgnoreCase("int")) {
            int value = this.getIntAttribute(attrs, "val");
            switch (this.objectState) {
                case 'o': {
                    IObjectLoader loader = (IObjectLoader)this.activeLoaders.peek();
                    loader.set(this, this.pendingObjects.peek(), this.getVariable(attrs), value);
                    break;
                }
                case 'a': {
                    Array.setInt(this.pendingObjects.peek(), this.nextArrayIndex(), value);
                    break;
                }
                case 'c': {
                    IAggregateLoader loader = (IAggregateLoader)this.activeLoaders.peek();
                    loader.addToCollection(this, (Collection)this.pendingObjects.peek(), new Integer(value));
                    break;
                }
                case 'k': {
                    this.entryKey = new Integer(value);
                    break;
                }
                case 'm': {
                    IAggregateLoader loader = (IAggregateLoader)this.activeLoaders.peek();
                    loader.putInMap(this, (Map)this.pendingObjects.peek(), this.entryKey, new Integer(value));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        } else if (qName.equalsIgnoreCase("dbl")) {
            double value = this.getDoubleAttribute(attrs, "val");
            switch (this.objectState) {
                case 'o': {
                    IObjectLoader loader = (IObjectLoader)this.activeLoaders.peek();
                    loader.set(this, this.pendingObjects.peek(), this.getVariable(attrs), value);
                    break;
                }
                case 'a': {
                    Array.setDouble(this.pendingObjects.peek(), this.nextArrayIndex(), value);
                    break;
                }
                case 'c': {
                    IAggregateLoader loader = (IAggregateLoader)this.activeLoaders.peek();
                    loader.addToCollection(this, (Collection)this.pendingObjects.peek(), new Double(value));
                    break;
                }
                case 'k': {
                    this.entryKey = new Double(value);
                    break;
                }
                case 'm': {
                    IAggregateLoader loader = (IAggregateLoader)this.activeLoaders.peek();
                    loader.putInMap(this, (Map)this.pendingObjects.peek(), this.entryKey, new Double(value));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        } else if (qName.equalsIgnoreCase("bool")) {
            boolean value = this.getBooleanAttribute(attrs, "val");
            switch (this.objectState) {
                case 'o': {
                    IObjectLoader loader = (IObjectLoader)this.activeLoaders.peek();
                    loader.set(this, this.pendingObjects.peek(), this.getVariable(attrs), value);
                    break;
                }
                case 'a': {
                    Array.setBoolean(this.pendingObjects.peek(), this.nextArrayIndex(), value);
                    break;
                }
                case 'c': {
                    IAggregateLoader loader = (IAggregateLoader)this.activeLoaders.peek();
                    loader.addToCollection(this, (Collection)this.pendingObjects.peek(), new Boolean(value));
                    break;
                }
                case 'k': {
                    this.entryKey = new Boolean(value);
                    break;
                }
                case 'm': {
                    IAggregateLoader loader = (IAggregateLoader)this.activeLoaders.peek();
                    loader.putInMap(this, (Map)this.pendingObjects.peek(), this.entryKey, new Boolean(value));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        } else if (qName.equalsIgnoreCase("str")) {
            if (this.objectState == 'o') {
                this.pendingVariable = this.getVariable(attrs);
            }
            this.stringLength = this.getIntAttribute(attrs, "size") + 1;
            this.assignmentState = 1;
            this.accumulator.delete(0, this.accumulator.length());
        } else if (qName.equalsIgnoreCase("char")) {
            if (this.objectState == 'o') {
                this.pendingVariable = this.getVariable(attrs);
            }
            this.assignmentState = 2;
            this.accumulator.delete(0, this.accumulator.length());
        } else if (qName.equalsIgnoreCase("byte")) {
            if (this.objectState == 'o') {
                this.pendingVariable = this.getVariable(attrs);
            }
            this.assignmentState = 3;
            this.idref = this.getIntAttribute(attrs, "id");
            this.stringLength = this.getIntAttribute(attrs, "size");
            this.accumulator.delete(0, this.accumulator.length());
        } else if (qName.equalsIgnoreCase("enum")) {
            IEnumLoader loader = ObjectLoader.getEnumLoader(this.getStringAttribute(attrs, "class"), this.getIntAttribute(attrs, "version"));
            if (loader == null) {
                throw new IllegalStateException("enum class loader not found");
            }
            Object newEnum = loader.createEnum(this, this.getStringAttribute(attrs, "val"));
            if (newEnum == null) {
                throw new IllegalStateException("enum create was not successful");
            }
            this.addObject(attrs, newEnum);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("arr") || qName.equalsIgnoreCase("elts") || qName.equalsIgnoreCase("map") || qName.equalsIgnoreCase("obj")) {
            ILoader loader = (ILoader)this.activeLoaders.pop();
            Object obj = this.pendingObjects.pop();
            this.popObjectState();
            if (qName.equalsIgnoreCase("arr")) {
                this.popArrayIndex();
            }
            loader.evolve(obj);
        } else if (qName.equalsIgnoreCase("sup")) {
            ILoader loader = (ILoader)this.activeLoaders.pop();
            Object obj = this.pendingObjects.peek();
            loader.evolve(obj);
        } else if (qName.equalsIgnoreCase("key")) {
            this.popObjectState();
        } else if (qName.equalsIgnoreCase("str")) {
            this.assignmentState = 0;
        } else if (qName.equalsIgnoreCase("char")) {
            this.assignmentState = 0;
        } else if (qName.equalsIgnoreCase("byte")) {
            this.assignmentState = 0;
        }
    }

    public void characters(char[] str, int start, int length) throws SAXException {
        if (this.assignmentState == -1) {
            throw new IllegalStateException("incorrect state for assigning char(s)");
        }
        boolean okToAssign = true;
        if (this.assignmentState == 1 || this.assignmentState == 3) {
            Object value = null;
            this.accumulator.append(str, start, length);
            if (this.assignmentState == 1) {
                if (this.accumulator.length() == this.stringLength) {
                    value = this.accumulator.substring(0, this.stringLength - 1);
                } else {
                    okToAssign = false;
                }
            } else if (this.assignmentState == 3) {
                if (this.accumulator.length() == this.stringLength) {
                    value = Base64.decode((String)this.accumulator.toString());
                    this.loadedObjects.put(new Integer(this.idref), value);
                } else {
                    okToAssign = false;
                }
            }
            if (okToAssign) {
                if (this.objectState == 'o') {
                    IObjectLoader loader = (IObjectLoader)this.activeLoaders.peek();
                    loader.set(this, this.pendingObjects.peek(), this.pendingVariable, value);
                } else {
                    this.addObject(null, value);
                }
                this.assignmentState = -1;
            }
        } else if (this.assignmentState == 2) {
            char value = '\u0000';
            if (length < 2) {
                this.accumulator.append(str, start, length);
                if (this.accumulator.length() == 2) {
                    value = this.accumulator.charAt(0);
                } else {
                    okToAssign = false;
                }
            } else if (length == 2) {
                value = str[0];
            } else {
                throw new IllegalStateException("char length incorrect");
            }
            if (okToAssign) {
                switch (this.objectState) {
                    case 'o': {
                        IObjectLoader loader = (IObjectLoader)this.activeLoaders.peek();
                        loader.set(this, this.pendingObjects.peek(), this.pendingVariable, value);
                        break;
                    }
                    case 'a': {
                        Array.setChar(this.pendingObjects.peek(), this.nextArrayIndex(), value);
                        break;
                    }
                    case 'c': {
                        IAggregateLoader loader = (IAggregateLoader)this.activeLoaders.peek();
                        loader.addToCollection(this, (Collection)this.pendingObjects.peek(), new Character(value));
                        break;
                    }
                    case 'k': {
                        this.entryKey = new Character(value);
                        break;
                    }
                    case 'm': {
                        IAggregateLoader loader = (IAggregateLoader)this.activeLoaders.peek();
                        loader.putInMap(this, (Map)this.pendingObjects.peek(), this.entryKey, new Character(value));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown state");
                    }
                }
                this.assignmentState = -1;
            }
        }
    }

    public void endDocument() throws SAXException {
    }

    public void error(SAXParseException e) throws SAXException {
        System.out.println("error");
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.out.println("fatalError");
    }

    public void warning(SAXParseException e) throws SAXException {
        System.out.println("warning");
    }

    public static class AObjectLoader
    extends ALoader
    implements IObjectLoader {
        public Object createObject(ObjectLoader l) {
            return this.createObject();
        }

        public Object createObject() {
            throw new UnsupportedOperationException("createObject");
        }

        public void set(ObjectLoader l, Object target, String variable, int value) {
            this.set(target, variable, value);
        }

        public void set(Object target, String variable, int value) {
            throw new UnsupportedOperationException("set int");
        }

        public void set(ObjectLoader l, Object target, String variable, double value) {
            this.set(target, variable, value);
        }

        public void set(Object target, String variable, double value) {
            throw new UnsupportedOperationException("set double");
        }

        public void set(ObjectLoader l, Object target, String variable, boolean value) {
            this.set(target, variable, value);
        }

        public void set(Object target, String variable, boolean value) {
            throw new UnsupportedOperationException("set boolean");
        }

        public void set(ObjectLoader l, Object target, String variable, char value) {
            this.set(target, variable, value);
        }

        public void set(Object target, String variable, char value) {
            throw new UnsupportedOperationException("set char");
        }

        public void set(ObjectLoader l, Object target, String variable, Object value) {
            this.set(target, variable, value);
        }

        public void set(Object target, String variable, Object value) {
            throw new UnsupportedOperationException("set object");
        }

        public Map createMap(ObjectLoader l, Object target, String variable, int size) {
            return this.createMap(target, variable, size);
        }

        public Map createMap(Object target, String variable, int size) {
            throw new UnsupportedOperationException("createMap");
        }

        public Collection createCollection(ObjectLoader l, Object target, String variable, int size) {
            return this.createCollection(target, variable, size);
        }

        public Collection createCollection(Object target, String variable, int size) {
            throw new UnsupportedOperationException("createCollection");
        }

        public Class getArrayEltType(ObjectLoader l, String variable, String className) {
            return this.getArrayEltType(variable, className);
        }

        public Class getArrayEltType(String variable, String className) {
            throw new UnsupportedOperationException("getArrayEltType");
        }

        public IAggregateLoader getLoader(ObjectLoader l, String variable) {
            return this.getLoader(variable);
        }

        public IAggregateLoader getLoader(String variable) {
            return AAggregateLoader.ONLY;
        }
    }

    public static class AEnumLoader
    implements IEnumLoader {
        public Object createEnum(ObjectLoader l, String persistentValue) {
            return this.createEnum(persistentValue);
        }

        public Object createEnum(String persistentValue) {
            throw new UnsupportedOperationException("createEnum");
        }
    }

    public static class AAggregateLoader
    extends ALoader
    implements IAggregateLoader {
        public static final AAggregateLoader ONLY = new AAggregateLoader();

        public Map createMap(ObjectLoader l, int size) {
            return this.createMap(size);
        }

        public Map createMap(int size) {
            throw new UnsupportedOperationException("createMap");
        }

        public Collection createCollection(ObjectLoader l, int size) {
            return this.createCollection(size);
        }

        public Collection createCollection(int size) {
            throw new UnsupportedOperationException("createCollection");
        }

        public Class getArrayEltType(ObjectLoader l, String className) {
            return this.getArrayEltType(className);
        }

        public Class getArrayEltType(String className) {
            throw new UnsupportedOperationException("getArrayEltType");
        }

        public IAggregateLoader getLoader(ObjectLoader l) {
            return this.getLoader();
        }

        public IAggregateLoader getLoader() {
            return ONLY;
        }

        public void putInMap(ObjectLoader l, Map m, Object key, Object v) {
            this.putInMap(m, key, v);
        }

        public void putInMap(Map m, Object key, Object v) {
            m.put(key, v);
        }

        public void addToCollection(ObjectLoader l, Collection c, Object v) {
            this.addToCollection(c, v);
        }

        public void addToCollection(Collection c, Object v) {
            c.add(v);
        }

        public void addToArray(ObjectLoader l, Object a, int i, Object v) {
            this.addToArray(a, i, v);
        }

        public void addToArray(Object a, int i, Object v) {
            Array.set(a, i, v);
        }
    }

    public static class ALoader {
        public void evolve(Object target) {
        }
    }

    public static interface IObjectLoader
    extends ILoader {
        public Object createObject();

        public Object createObject(ObjectLoader var1);

        public void set(ObjectLoader var1, Object var2, String var3, int var4);

        public void set(Object var1, String var2, int var3);

        public void set(ObjectLoader var1, Object var2, String var3, double var4);

        public void set(Object var1, String var2, double var3);

        public void set(ObjectLoader var1, Object var2, String var3, boolean var4);

        public void set(Object var1, String var2, boolean var3);

        public void set(ObjectLoader var1, Object var2, String var3, char var4);

        public void set(Object var1, String var2, char var3);

        public void set(ObjectLoader var1, Object var2, String var3, Object var4);

        public void set(Object var1, String var2, Object var3);

        public Map createMap(ObjectLoader var1, Object var2, String var3, int var4);

        public Map createMap(Object var1, String var2, int var3);

        public Collection createCollection(ObjectLoader var1, Object var2, String var3, int var4);

        public Collection createCollection(Object var1, String var2, int var3);

        public Class getArrayEltType(ObjectLoader var1, String var2, String var3);

        public Class getArrayEltType(String var1, String var2);

        public IAggregateLoader getLoader(ObjectLoader var1, String var2);

        public IAggregateLoader getLoader(String var1);
    }

    public static interface IAggregateLoader
    extends ILoader {
        public Map createMap(int var1);

        public Map createMap(ObjectLoader var1, int var2);

        public Collection createCollection(int var1);

        public Collection createCollection(ObjectLoader var1, int var2);

        public Class getArrayEltType(String var1);

        public Class getArrayEltType(ObjectLoader var1, String var2);

        public IAggregateLoader getLoader();

        public IAggregateLoader getLoader(ObjectLoader var1);

        public void putInMap(Map var1, Object var2, Object var3);

        public void putInMap(ObjectLoader var1, Map var2, Object var3, Object var4);

        public void addToCollection(Collection var1, Object var2);

        public void addToCollection(ObjectLoader var1, Collection var2, Object var3);

        public void addToArray(Object var1, int var2, Object var3);

        public void addToArray(ObjectLoader var1, Object var2, int var3, Object var4);
    }

    public static interface ILoader {
        public void evolve(Object var1);
    }

    public static interface IEnumLoader {
        public Object createEnum(String var1);

        public Object createEnum(ObjectLoader var1, String var2);
    }
}

