/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class MenuUtil {
    public static final SimpleMenuItemDefinition SEPARATOR = new SimpleMenuItemDefinition();
    public static final boolean ENABLED = true;
    public static final boolean DISABLED = false;
    public static final int[] keyCodes = new int[]{0x1000002, 0x1000001, 0x1000003, 0x1000004, 16777302, 8, 13, 127, 0x1000008, 27, 0x100000A, 0x100000B, 0x100000C, 0x100000D, 0x100000E, 0x100000F, 0x1000010, 0x1000011, 0x1000012, 0x1000013, 0x1000014, 0x1000015, 0x1000016, 0x1000017, 0x1000018, 0x1000051, 0x1000007, 0x1000009, 0x1000030, 0x1000031, 16777266, 0x1000033, 16777268, 16777269, 16777270, 16777271, 16777272, 16777273, 16777259, 0x1000050, 16777262, 16777263, 16777277, 16777258, 16777261, 0x1000006, 0x1000005, 0x1000055, 16777303, 32, 9};
    public static final String[] keyLabels = new String[]{L10N.get("MU.Down", "Down"), L10N.get("MU.Up", "Up"), L10N.get("MU.Left", "Left"), L10N.get("MU.Right", "Right"), L10N.get("MU.Break", "Break"), L10N.get("MU.Backspace", "Backspace"), L10N.get("MU.Enter", "Enter"), L10N.get("MU.Delete", "Delete"), L10N.get("MU.End", "End"), L10N.get("MU.Esc", "Esc"), L10N.get("MU.F1", "F1"), L10N.get("MU.F2", "F2"), L10N.get("MU.F3", "F3"), L10N.get("MU.F4", "F4"), L10N.get("MU.F5", "F5"), L10N.get("MU.F6", "F6"), L10N.get("MU.F7", "F7"), L10N.get("MU.F8", "F8"), L10N.get("MU.F9", "F9"), L10N.get("MU.F10", "F10"), L10N.get("MU.F11", "F11"), L10N.get("MU.F12", "F12"), L10N.get("MU.F13", "F13"), L10N.get("MU.F14", "F14"), L10N.get("MU.F15", "F15"), L10N.get("MU.Help", "Help"), L10N.get("MU.Home", "Home"), L10N.get("MU.Insert", "Insert"), L10N.get("MU.Keypad0", "Keypad0"), L10N.get("MU.Keypad1", "Keypad1"), L10N.get("MU.Keypad2", "Keypad2"), L10N.get("MU.Keypad3", "Keypad3"), L10N.get("MU.Keypad4", "Keypad4"), L10N.get("MU.Keypad5", "Keypad5"), L10N.get("MU.Keypad6", "Keypad6"), L10N.get("MU.Keypad7", "Keypad7"), L10N.get("MU.Keypad8", "Keypad8"), L10N.get("MU.Keypad9", "Keypad9"), L10N.get("MU.Keypad+", "Keypad+"), L10N.get("MU.KeypadEnter", "KeypadEnter"), L10N.get("MU.KeypadPeriod", "KeypadPeriod"), L10N.get("MU.Keypad/", "Keypad/"), L10N.get("MU.Keypad=", "Keypad="), L10N.get("MU.Keypad*", "Keypad*"), L10N.get("MU.Keypad-", "Keypad-"), L10N.get("MU.PageDown", "PageDown"), L10N.get("MU.PageUp", "PageUp"), L10N.get("MU.Pause", "Pause"), L10N.get("MU.PrintScreen", "PrintScreen"), L10N.get("MU.Space", "Space"), L10N.get("MU.Tab", "Tab")};

    protected MenuUtil() {
    }

    public static int platformControlKey() {
        if (OSUtils.MACOSX) {
            return 0x400000;
        }
        return 262144;
    }

    public static int notPlatformControlKey() {
        if (OSUtils.MACOSX) {
            return 262144;
        }
        return 0x400000;
    }

    private static void createMenuStep(Shell shell, Menu parent, MenuItemDefinition defn, Boolean availability, Listener selectionListener, ListenerIdentifierMap lIDMap) {
        if (defn.isSingle()) {
            SimpleMenuItemDefinition itemDef = (SimpleMenuItemDefinition)defn;
            MenuUtil.renderShortcut(itemDef);
            MenuItem item = MenuUtil.addMenuItem(parent, itemDef.name, itemDef.image, itemDef.style, itemDef.accelerator, itemDef.enabledInitially, itemDef.selectedInitially);
            if (itemDef.listenerID != null) {
                item.setData((Object)itemDef.listenerID);
                item.addListener(13, selectionListener);
                lIDMap.addWidget(itemDef.listenerID, item, availability);
            }
        } else {
            CascadingMenuItemDefinition itemDef = (CascadingMenuItemDefinition)defn;
            MenuItem item = MenuUtil.addMenuItem(parent, itemDef.name, itemDef.image, 64);
            Menu cascadeParent = new Menu((Decorations)shell, 4);
            item.setMenu(cascadeParent);
            if (itemDef.menuItems != null) {
                for (int i = 0; i < itemDef.menuItems.length; ++i) {
                    MenuUtil.createMenuStep(shell, cascadeParent, itemDef.menuItems[i], availability, selectionListener, lIDMap);
                }
            }
        }
    }

    public static Menu createMenu(Shell shell, int rootStyle, MenuItemDefinition[] defn, Boolean availability, Listener selectionListener, ListenerIdentifierMap lIDMap) {
        Menu root = new Menu((Decorations)shell, rootStyle);
        for (int i = 0; i < defn.length; ++i) {
            MenuUtil.createMenuStep(shell, root, defn[i], availability, selectionListener, lIDMap);
        }
        return root;
    }

    public static MenuItem addMenuItem(Menu parentMenu, String menuItemName, Image menuItemImage, int menuItemStyle, int accelerator, boolean enabled, boolean selected) {
        MenuItem mItem = new MenuItem(parentMenu, menuItemStyle);
        if (menuItemName != null) {
            mItem.setText(menuItemName);
        }
        if (menuItemImage != null) {
            mItem.setImage(menuItemImage);
        }
        mItem.setAccelerator(accelerator);
        mItem.setEnabled(enabled);
        mItem.setSelection(selected);
        return mItem;
    }

    public static MenuItem addMenuItem(Menu parentMenu, String menuItemName, Image menuItemImage, int menuItemStyle) {
        return MenuUtil.addMenuItem(parentMenu, menuItemName, menuItemImage, menuItemStyle, 0, true, false);
    }

    public static MenuItem addMenuItem(Menu parentMenu, String menuItemName, int menuItemStyle, int accelerator) {
        return MenuUtil.addMenuItem(parentMenu, menuItemName, null, menuItemStyle, accelerator, true, false);
    }

    public static MenuItem addMenuItem(Menu parentMenu, String menuItemName, int menuItemStyle) {
        return MenuUtil.addMenuItem(parentMenu, menuItemName, null, menuItemStyle, 0, true, false);
    }

    public static MenuItem addMenuItem(Menu parentMenu, Image menuItemImage, int menuItemStyle, int accelerator) {
        return MenuUtil.addMenuItem(parentMenu, null, menuItemImage, menuItemStyle, accelerator, true, false);
    }

    public static MenuItem addMenuItem(Menu parentMenu, Image menuItemImage, int menuItemStyle) {
        return MenuUtil.addMenuItem(parentMenu, null, menuItemImage, menuItemStyle, 0, true, false);
    }

    public static MenuItem[] addMenuItemSet(Menu parentMenu, String[] menuItemNames, int[] menuItemStyles, int[] accelerators) {
        int count = menuItemNames.length;
        MenuItem[] result = null;
        if (menuItemStyles.length == count && accelerators.length == count) {
            result = new MenuItem[count];
            for (int i = 0; i < count; ++i) {
                result[i] = MenuUtil.addMenuItem(parentMenu, menuItemNames[i], menuItemStyles[i], accelerators[i]);
            }
        }
        return result;
    }

    public static void relabelItem(MenuItem item, String newLabel) {
        int tabIdx = item.getText().indexOf(9);
        if (OSUtils.WINDOWS && tabIdx >= 0) {
            String shortcut = new String(item.getText().substring(tabIdx));
            item.setText(newLabel + shortcut);
        } else {
            item.setText(newLabel);
        }
    }

    public static void renderShortcut(SimpleMenuItemDefinition itemDef) {
        if (OSUtils.WINDOWS && itemDef.name != null && itemDef.name.indexOf(9) == -1) {
            String shortcut = "\t";
            if ((itemDef.accelerator & 0x40000) > 0) {
                shortcut = shortcut + L10N.get("MU.Ctrl+", "Ctrl+");
            }
            if ((itemDef.accelerator & 0x10000) > 0) {
                shortcut = shortcut + L10N.get("MU.Alt+", "Alt+");
            }
            if ((itemDef.accelerator & 0x20000) > 0) {
                shortcut = shortcut + L10N.get("MU.Shift+", "Shift+");
            }
            boolean done = false;
            int key = itemDef.accelerator & 0x100FFFF;
            for (int i = 0; i < keyCodes.length; ++i) {
                if (key != keyCodes[i]) continue;
                shortcut = shortcut + keyLabels[i];
                done = true;
            }
            if (!done) {
                shortcut = shortcut + Character.toUpperCase((char)key);
            }
            itemDef.name = itemDef.name + shortcut;
        }
    }

    public static class CascadingMenuItemDefinition
    extends MenuItemDefinition {
        public MenuItemDefinition[] menuItems;

        public CascadingMenuItemDefinition(String inName, MenuItemDefinition[] inMenuItems) {
            super(inName);
            this.menuItems = inMenuItems;
        }

        public CascadingMenuItemDefinition(String inName, Image inImage, MenuItemDefinition[] inMenuItems) {
            super(inName, inImage);
            this.menuItems = inMenuItems;
        }

        public boolean isSingle() {
            return false;
        }
    }

    public static class SimpleMenuItemDefinition
    extends MenuItemDefinition {
        public int accelerator = 0;
        public int style = 8;
        public ListenerIdentifier listenerID;
        public boolean enabledInitially = false;
        public boolean selectedInitially = false;

        public SimpleMenuItemDefinition() {
            super(null);
            this.style = 2;
            this.listenerID = null;
        }

        public SimpleMenuItemDefinition(String inName, ListenerIdentifier inLID) {
            super(inName);
            this.listenerID = inLID;
        }

        public SimpleMenuItemDefinition(String inName, ListenerIdentifier inLID, boolean enabled) {
            super(inName);
            this.listenerID = inLID;
            this.enabledInitially = enabled;
        }

        public SimpleMenuItemDefinition(String inName, Image inImage, ListenerIdentifier inLID) {
            super(inName, inImage);
            this.listenerID = inLID;
        }

        public SimpleMenuItemDefinition(String inName, Image inImage, ListenerIdentifier inLID, boolean enabled) {
            super(inName, inImage);
            this.listenerID = inLID;
            this.enabledInitially = enabled;
        }

        public SimpleMenuItemDefinition(String inName, ListenerIdentifier inLID, int inAccelerator) {
            super(inName);
            this.listenerID = inLID;
            this.accelerator = inAccelerator;
        }

        public SimpleMenuItemDefinition(String inName, ListenerIdentifier inLID, int inAccelerator, boolean enabled) {
            super(inName);
            this.listenerID = inLID;
            this.accelerator = inAccelerator;
            this.enabledInitially = enabled;
        }

        public SimpleMenuItemDefinition(String inName, Image inImage, ListenerIdentifier inLID, int inAccelerator) {
            super(inName, inImage);
            this.listenerID = inLID;
            this.accelerator = inAccelerator;
        }

        public SimpleMenuItemDefinition(String inName, Image inImage, ListenerIdentifier inLID, int inAccelerator, boolean enabled) {
            super(inName, inImage);
            this.listenerID = inLID;
            this.accelerator = inAccelerator;
            this.enabledInitially = enabled;
        }

        public SimpleMenuItemDefinition(String inName, ListenerIdentifier inLID, int inAccelerator, int inStyle) {
            super(inName);
            this.listenerID = inLID;
            this.accelerator = inAccelerator;
            this.style = inStyle;
        }

        public SimpleMenuItemDefinition(String inName, ListenerIdentifier inLID, int inAccelerator, int inStyle, boolean inEnabled) {
            super(inName);
            this.listenerID = inLID;
            this.accelerator = inAccelerator;
            this.style = inStyle;
            this.enabledInitially = inEnabled;
        }

        public SimpleMenuItemDefinition(String inName, ListenerIdentifier inLID, int inAccelerator, int inStyle, boolean inEnabled, boolean inSelected) {
            super(inName);
            this.listenerID = inLID;
            this.accelerator = inAccelerator;
            this.style = inStyle;
            this.enabledInitially = inEnabled;
            this.selectedInitially = inSelected;
        }

        public SimpleMenuItemDefinition(String inName, Image inImage, ListenerIdentifier inLID, int inAccelerator, int inStyle) {
            super(inName, inImage);
            this.listenerID = inLID;
            this.accelerator = inAccelerator;
            this.style = inStyle;
        }

        public SimpleMenuItemDefinition(String inName, Image inImage, ListenerIdentifier inLID, int inAccelerator, int inStyle, boolean enabled) {
            super(inName, inImage);
            this.listenerID = inLID;
            this.accelerator = inAccelerator;
            this.style = inStyle;
            this.enabledInitially = enabled;
        }

        public SimpleMenuItemDefinition(String inName, Image inImage, ListenerIdentifier inLID, int inAccelerator, int inStyle, boolean enabled, boolean selected) {
            super(inName, inImage);
            this.listenerID = inLID;
            this.accelerator = inAccelerator;
            this.style = inStyle;
            this.enabledInitially = enabled;
            this.selectedInitially = selected;
        }

        public boolean isSingle() {
            return true;
        }
    }

    public static abstract class MenuItemDefinition {
        public String name;
        public Image image = null;

        protected MenuItemDefinition(String inName) {
            this.name = inName;
        }

        protected MenuItemDefinition(String inName, Image inImage) {
            this.name = inName;
            this.image = inImage;
        }

        public abstract boolean isSingle();
    }
}

