/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.EmptyIterator;
import edu.cmu.cs.hcii.cogtool.util.IListenerAction;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class ListenerIdentifierMap {
    public static final Boolean ALL = null;
    public static final Boolean NORMAL = new Boolean(true);
    public static final Boolean CONTEXT = new Boolean(false);
    protected Map idActions = new HashMap();
    protected Map idWidgets = new HashMap();

    public IListenerAction setAction(ListenerIdentifier id, IListenerAction action) {
        return this.idActions.put(id, action);
    }

    public IListenerAction removeAction(ListenerIdentifier id) {
        return (IListenerAction)this.idActions.remove(id);
    }

    public IListenerAction getAction(ListenerIdentifier id) {
        return (IListenerAction)this.idActions.get(id);
    }

    public boolean performAction(ListenerIdentifier id, Object actionParms) {
        IListenerAction action = this.getAction(id);
        if (action != null) {
            Class requiredClass = action.getParameterClass();
            if (requiredClass == null || actionParms != null && requiredClass.isAssignableFrom(actionParms.getClass())) {
                return action.performAction(actionParms);
            }
            if (actionParms != null) {
                throw new IllegalArgumentException("Provided parameter type (" + actionParms.getClass().getName() + ") is not assignable to the type expected by the action (" + requiredClass.getName() + ")");
            }
            throw new IllegalArgumentException("Provided parameter type is null when " + requiredClass.getName() + " is expected.");
        }
        return true;
    }

    public boolean performAction(ListenerIdentifier.ILIDTransmuter transmuter, ListenerIdentifier id, boolean isContextSelection) {
        ListenerIdentifier transmutedLID = transmuter.transmute(id, isContextSelection);
        Object actionParms = transmuter.getParameters(id, transmutedLID, isContextSelection);
        boolean okToContinue = this.performAction(transmutedLID, actionParms);
        transmuter.cleanup(okToContinue, false);
        return okToContinue;
    }

    public void addWidget(ListenerIdentifier id, Object widget, Boolean availability) {
        HashMap<Object, Boolean> targets = (HashMap<Object, Boolean>)this.idWidgets.get(id);
        if (targets == null) {
            targets = new HashMap<Object, Boolean>();
            this.idWidgets.put(id, targets);
        }
        targets.put(widget, availability);
    }

    public Iterator getWidgets(ListenerIdentifier id, Boolean availability) {
        Map targets = (Map)this.idWidgets.get(id);
        if (targets != null) {
            return new FilterByAvailability(targets.entrySet().iterator(), availability);
        }
        return new EmptyIterator();
    }

    protected static class FilterByAvailability
    implements Iterator {
        protected Iterator widgets;
        protected Boolean availability;
        protected Object nextWidget = null;

        public FilterByAvailability(Iterator allWidgets, Boolean avail) {
            this.widgets = allWidgets;
            this.availability = avail;
            this.hasNext();
        }

        public boolean hasNext() {
            if (this.widgets != null) {
                if (this.nextWidget != null) {
                    return true;
                }
                while (this.widgets.hasNext()) {
                    Map.Entry entry = (Map.Entry)this.widgets.next();
                    if (this.availability != ALL && !this.availability.equals((Boolean)entry.getValue())) continue;
                    this.nextWidget = entry.getKey();
                    return true;
                }
                this.widgets = null;
            }
            return false;
        }

        public Object next() {
            if (this.widgets != null && this.nextWidget != null) {
                Object returnValue = this.nextWidget;
                this.nextWidget = null;
                this.hasNext();
                return returnValue;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

